/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.BlockBamboo;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;

public class WorldGenFeatureBamboo
extends WorldGenerator<WorldGenFeatureConfigurationChance> {
    private static final IBlockData BAMBOO_TRUNK = (IBlockData)((IBlockData)((IBlockData)Blocks.BAMBOO.defaultBlockState().setValue(BlockBamboo.AGE, 1)).setValue(BlockBamboo.LEAVES, BlockPropertyBambooSize.NONE)).setValue(BlockBamboo.STAGE, 0);
    private static final IBlockData BAMBOO_FINAL_LARGE = (IBlockData)((IBlockData)BAMBOO_TRUNK.setValue(BlockBamboo.LEAVES, BlockPropertyBambooSize.LARGE)).setValue(BlockBamboo.STAGE, 1);
    private static final IBlockData BAMBOO_TOP_LARGE = (IBlockData)BAMBOO_TRUNK.setValue(BlockBamboo.LEAVES, BlockPropertyBambooSize.LARGE);
    private static final IBlockData BAMBOO_TOP_SMALL = (IBlockData)BAMBOO_TRUNK.setValue(BlockBamboo.LEAVES, BlockPropertyBambooSize.SMALL);

    public WorldGenFeatureBamboo(Codec<WorldGenFeatureConfigurationChance> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureConfigurationChance> var0) {
        int var1 = 0;
        BlockPosition var2 = var0.origin();
        GeneratorAccessSeed var3 = var0.level();
        Random var4 = var0.random();
        WorldGenFeatureConfigurationChance var5 = var0.config();
        BlockPosition.MutableBlockPosition var6 = var2.mutable();
        BlockPosition.MutableBlockPosition var7 = var2.mutable();
        if (var3.isEmptyBlock(var6)) {
            if (Blocks.BAMBOO.defaultBlockState().canSurvive(var3, var6)) {
                int var9;
                int var8 = var4.nextInt(12) + 5;
                if (var4.nextFloat() < var5.probability) {
                    var9 = var4.nextInt(4) + 1;
                    for (int var10 = var2.getX() - var9; var10 <= var2.getX() + var9; ++var10) {
                        for (int var11 = var2.getZ() - var9; var11 <= var2.getZ() + var9; ++var11) {
                            int var13;
                            int var12 = var10 - var2.getX();
                            if (var12 * var12 + (var13 = var11 - var2.getZ()) * var13 > var9 * var9) continue;
                            var7.set(var10, var3.getHeight(HeightMap.Type.WORLD_SURFACE, var10, var11) - 1, var11);
                            if (!WorldGenFeatureBamboo.isDirt(var3.getBlockState(var7))) continue;
                            var3.setBlock(var7, Blocks.PODZOL.defaultBlockState(), 2);
                        }
                    }
                }
                for (var9 = 0; var9 < var8 && var3.isEmptyBlock(var6); ++var9) {
                    var3.setBlock(var6, BAMBOO_TRUNK, 2);
                    var6.move(EnumDirection.UP, 1);
                }
                if (var6.getY() - var2.getY() >= 3) {
                    var3.setBlock(var6, BAMBOO_FINAL_LARGE, 2);
                    var3.setBlock(var6.move(EnumDirection.DOWN, 1), BAMBOO_TOP_LARGE, 2);
                    var3.setBlock(var6.move(EnumDirection.DOWN, 1), BAMBOO_TOP_SMALL, 2);
                }
            }
            ++var1;
        }
        return var1 > 0;
    }
}

