/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class DripstoneClusterFeature
extends WorldGenerator<DripstoneClusterConfiguration> {
    public DripstoneClusterFeature(Codec<DripstoneClusterConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<DripstoneClusterConfiguration> var0) {
        GeneratorAccessSeed var1 = var0.level();
        BlockPosition var2 = var0.origin();
        DripstoneClusterConfiguration var3 = var0.config();
        Random var4 = var0.random();
        if (!DripstoneUtils.isEmptyOrWater(var1, var2)) {
            return false;
        }
        int var5 = var3.height.sample(var4);
        float var6 = var3.wetness.sample(var4);
        float var7 = var3.density.sample(var4);
        int var8 = var3.radius.sample(var4);
        int var9 = var3.radius.sample(var4);
        for (int var10 = -var8; var10 <= var8; ++var10) {
            for (int var11 = -var9; var11 <= var9; ++var11) {
                double var12 = this.getChanceOfStalagmiteOrStalactite(var8, var9, var10, var11, var3);
                BlockPosition var14 = var2.offset(var10, 0, var11);
                this.placeColumn(var1, var4, var14, var10, var11, var6, var12, var5, var7, var3);
            }
        }
        return true;
    }

    private void placeColumn(GeneratorAccessSeed var0, Random var1, BlockPosition var2, int var3, int var4, float var5, double var6, int var8, float var9, DripstoneClusterConfiguration var10) {
        int var22;
        int var23;
        int var21;
        int var17;
        int var20;
        int var19;
        boolean var18;
        Column var15;
        boolean var14;
        Optional<Column> var11 = Column.scan(var0, var2, var10.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isDripstoneBaseOrLava);
        if (!var11.isPresent()) {
            return;
        }
        OptionalInt var12 = var11.get().getCeiling();
        OptionalInt var13 = var11.get().getFloor();
        if (!var12.isPresent() && !var13.isPresent()) {
            return;
        }
        boolean bl = var14 = var1.nextFloat() < var5;
        if (var14 && var13.isPresent() && this.canPlacePool(var0, var2.atY(var13.getAsInt()))) {
            int var16 = var13.getAsInt();
            var15 = var11.get().withFloor(OptionalInt.of(var16 - 1));
            var0.setBlock(var2.atY(var16), Blocks.WATER.defaultBlockState(), 2);
        } else {
            var15 = var11.get();
        }
        OptionalInt var16 = var15.getFloor();
        boolean bl2 = var18 = var1.nextDouble() < var6;
        if (var12.isPresent() && var18 && !this.isLava(var0, var2.atY(var12.getAsInt()))) {
            var19 = var10.dripstoneBlockLayerThickness.sample(var1);
            this.replaceBlocksWithDripstoneBlocks(var0, var2.atY(var12.getAsInt()), var19, EnumDirection.UP);
            var20 = var16.isPresent() ? Math.min(var8, var12.getAsInt() - var16.getAsInt()) : var8;
            var17 = this.getDripstoneHeight(var1, var3, var4, var9, var20, var10);
        } else {
            var17 = 0;
        }
        int n2 = var20 = var1.nextDouble() < var6 ? 1 : 0;
        if (var16.isPresent() && var20 != 0 && !this.isLava(var0, var2.atY(var16.getAsInt()))) {
            var21 = var10.dripstoneBlockLayerThickness.sample(var1);
            this.replaceBlocksWithDripstoneBlocks(var0, var2.atY(var16.getAsInt()), var21, EnumDirection.DOWN);
            var19 = var12.isPresent() ? Math.max(0, var17 + MathHelper.randomBetweenInclusive(var1, -var10.maxStalagmiteStalactiteHeightDiff, var10.maxStalagmiteStalactiteHeightDiff)) : this.getDripstoneHeight(var1, var3, var4, var9, var8, var10);
        } else {
            var19 = 0;
        }
        if (var12.isPresent() && var16.isPresent() && var12.getAsInt() - var17 <= var16.getAsInt() + var19) {
            var23 = var16.getAsInt();
            int var24 = var12.getAsInt();
            int var25 = Math.max(var24 - var17, var23 + 1);
            int var26 = Math.min(var23 + var19, var24 - 1);
            int var27 = MathHelper.randomBetweenInclusive(var1, var25, var26 + 1);
            int var28 = var27 - 1;
            var21 = var24 - var27;
            var22 = var28 - var23;
        } else {
            var21 = var17;
            var22 = var19;
        }
        int n3 = var23 = var1.nextBoolean() && var21 > 0 && var22 > 0 && var15.getHeight().isPresent() && var21 + var22 == var15.getHeight().getAsInt() ? 1 : 0;
        if (var12.isPresent()) {
            DripstoneUtils.growPointedDripstone(var0, var2.atY(var12.getAsInt() - 1), EnumDirection.DOWN, var21, var23 != 0);
        }
        if (var16.isPresent()) {
            DripstoneUtils.growPointedDripstone(var0, var2.atY(var16.getAsInt() + 1), EnumDirection.UP, var22, var23 != 0);
        }
    }

    private boolean isLava(IWorldReader var0, BlockPosition var1) {
        return var0.getBlockState(var1).is(Blocks.LAVA);
    }

    private int getDripstoneHeight(Random var0, int var1, int var2, float var3, int var4, DripstoneClusterConfiguration var5) {
        if (var0.nextFloat() > var3) {
            return 0;
        }
        int var6 = Math.abs(var1) + Math.abs(var2);
        float var7 = (float)MathHelper.clampedMap((double)var6, 0.0, (double)var5.maxDistanceFromCenterAffectingHeightBias, (double)var4 / 2.0, 0.0);
        return (int)DripstoneClusterFeature.randomBetweenBiased(var0, 0.0f, var4, var7, var5.heightDeviation);
    }

    private boolean canPlacePool(GeneratorAccessSeed var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        if (var2.is(Blocks.WATER) || var2.is(Blocks.DRIPSTONE_BLOCK) || var2.is(Blocks.POINTED_DRIPSTONE)) {
            return false;
        }
        for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            if (this.canBeAdjacentToWater(var0, var1.relative(var4))) continue;
            return false;
        }
        return this.canBeAdjacentToWater(var0, var1.below());
    }

    private boolean canBeAdjacentToWater(GeneratorAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        return var2.is(TagsBlock.BASE_STONE_OVERWORLD) || var2.getFluidState().is(TagsFluid.WATER);
    }

    private void replaceBlocksWithDripstoneBlocks(GeneratorAccessSeed var0, BlockPosition var1, int var2, EnumDirection var3) {
        BlockPosition.MutableBlockPosition var4 = var1.mutable();
        for (int var5 = 0; var5 < var2; ++var5) {
            if (!DripstoneUtils.placeDripstoneBlockIfPossible(var0, var4)) {
                return;
            }
            var4.move(var3);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int var0, int var1, int var2, int var3, DripstoneClusterConfiguration var4) {
        int var5 = var0 - Math.abs(var2);
        int var6 = var1 - Math.abs(var3);
        int var7 = Math.min(var5, var6);
        return MathHelper.clampedMap(var7, 0.0f, var4.maxDistanceFromEdgeAffectingChanceOfDripstoneColumn, var4.chanceOfDripstoneColumnAtMaxDistanceFromCenter, 1.0f);
    }

    private static float randomBetweenBiased(Random var0, float var1, float var2, float var3, float var4) {
        return ClampedNormalFloat.sample(var0, var3, var4, var1, var2);
    }
}

