/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.WorldGenerationContext;

public abstract class VerticalAnchor {
    public static final Codec<VerticalAnchor> CODEC = ExtraCodecs.xor(b.CODEC, ExtraCodecs.xor(a.CODEC, c.CODEC)).xmap(VerticalAnchor::merge, VerticalAnchor::split);
    private static final VerticalAnchor BOTTOM = VerticalAnchor.aboveBottom(0);
    private static final VerticalAnchor TOP = VerticalAnchor.belowTop(0);
    private final int value;

    protected VerticalAnchor(int var0) {
        this.value = var0;
    }

    public static VerticalAnchor absolute(int var0) {
        return new b(var0);
    }

    public static VerticalAnchor aboveBottom(int var0) {
        return new a(var0);
    }

    public static VerticalAnchor belowTop(int var0) {
        return new c(var0);
    }

    public static VerticalAnchor bottom() {
        return BOTTOM;
    }

    public static VerticalAnchor top() {
        return TOP;
    }

    private static VerticalAnchor merge(Either<b, Either<a, c>> var02) {
        return (VerticalAnchor)var02.map(Function.identity(), var0 -> (VerticalAnchor)var0.map(Function.identity(), Function.identity()));
    }

    private static Either<b, Either<a, c>> split(VerticalAnchor var0) {
        if (var0 instanceof b) {
            return Either.left((Object)((b)var0));
        }
        return Either.right((Object)(var0 instanceof a ? Either.left((Object)((a)var0)) : Either.right((Object)((c)var0))));
    }

    protected int value() {
        return this.value;
    }

    public abstract int resolveY(WorldGenerationContext var1);

    static final class b
    extends VerticalAnchor {
        public static final Codec<b> CODEC = Codec.intRange((int)DimensionManager.MIN_Y, (int)DimensionManager.MAX_Y).fieldOf("absolute").xmap(b::new, VerticalAnchor::value).codec();

        protected b(int var0) {
            super(var0);
        }

        @Override
        public int resolveY(WorldGenerationContext var0) {
            return this.value();
        }

        public String toString() {
            return this.value() + " absolute";
        }
    }

    static final class a
    extends VerticalAnchor {
        public static final Codec<a> CODEC = Codec.intRange((int)DimensionManager.MIN_Y, (int)DimensionManager.MAX_Y).fieldOf("above_bottom").xmap(a::new, VerticalAnchor::value).codec();

        protected a(int var0) {
            super(var0);
        }

        @Override
        public int resolveY(WorldGenerationContext var0) {
            return var0.getMinGenY() + this.value();
        }

        public String toString() {
            return this.value() + " above bottom";
        }
    }

    static final class c
    extends VerticalAnchor {
        public static final Codec<c> CODEC = Codec.intRange((int)DimensionManager.MIN_Y, (int)DimensionManager.MAX_Y).fieldOf("below_top").xmap(c::new, VerticalAnchor::value).codec();

        protected c(int var0) {
            super(var0);
        }

        @Override
        public int resolveY(WorldGenerationContext var0) {
            return var0.getGenDepth() - 1 + var0.getMinGenY() - this.value();
        }

        public String toString() {
            return this.value() + " below top";
        }
    }
}

