/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class SurfaceRules {
    public static final f ON_FLOOR = SurfaceRules.stoneDepthCheck(0, false, false, CaveSurface.FLOOR);
    public static final f UNDER_FLOOR = SurfaceRules.stoneDepthCheck(0, true, false, CaveSurface.FLOOR);
    public static final f ON_CEILING = SurfaceRules.stoneDepthCheck(0, false, false, CaveSurface.CEILING);
    public static final f UNDER_CEILING = SurfaceRules.stoneDepthCheck(0, true, false, CaveSurface.CEILING);

    public static f stoneDepthCheck(int var0, boolean var1, boolean var2, CaveSurface var3) {
        return new t(var0, var1, var2, var3);
    }

    public static f not(f var0) {
        return new n(var0);
    }

    public static f yBlockCheck(VerticalAnchor var0, int var1) {
        return new aa(var0, var1, false);
    }

    public static f yStartCheck(VerticalAnchor var0, int var1) {
        return new aa(var0, var1, true);
    }

    public static f waterBlockCheck(int var0, int var1) {
        return new z(var0, var1, false);
    }

    public static f waterStartCheck(int var0, int var1) {
        return new z(var0, var1, true);
    }

    @SafeVarargs
    public static f isBiome(ResourceKey<BiomeBase> ... var0) {
        return SurfaceRules.isBiome(List.of(var0));
    }

    private static c isBiome(List<ResourceKey<BiomeBase>> var0) {
        return new c(var0);
    }

    public static f noiseCondition(ResourceKey<NoiseGeneratorNormal.a> var0, double var1) {
        return SurfaceRules.noiseCondition(var0, var1, Double.MAX_VALUE);
    }

    public static f noiseCondition(ResourceKey<NoiseGeneratorNormal.a> var0, double var1, double var3) {
        return new l(var0, var1, var3);
    }

    public static f verticalGradient(String var0, VerticalAnchor var1, VerticalAnchor var2) {
        return new y(new MinecraftKey(var0), var1, var2);
    }

    public static f steep() {
        return s.INSTANCE;
    }

    public static f hole() {
        return h.INSTANCE;
    }

    public static f abovePreliminarySurface() {
        return a.INSTANCE;
    }

    public static f temperature() {
        return v.INSTANCE;
    }

    public static o ifTrue(f var0, o var1) {
        return new x(var0, var1);
    }

    public static o sequence(o ... var0) {
        if (var0.length == 0) {
            throw new IllegalArgumentException("Need at least 1 rule for a sequence");
        }
        return new q(Arrays.asList(var0));
    }

    public static o state(IBlockData var0) {
        return new d(var0);
    }

    public static o bandlands() {
        return b.INSTANCE;
    }

    static final class t
    extends Record
    implements f {
        final int offset;
        final boolean addSurfaceDepth;
        final boolean addSurfaceSecondaryDepth;
        private final CaveSurface surfaceType;
        static final Codec<t> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("offset").forGetter(t::offset), (App)Codec.BOOL.fieldOf("add_surface_depth").forGetter(t::addSurfaceDepth), (App)Codec.BOOL.fieldOf("add_surface_secondary_depth").forGetter(t::addSurfaceSecondaryDepth), (App)CaveSurface.CODEC.fieldOf("surface_type").forGetter(t::surfaceType)).apply((Applicative)var0, t::new));

        t(int var0, boolean var1, boolean var2, CaveSurface var3) {
            this.offset = var0;
            this.addSurfaceDepth = var1;
            this.addSurfaceSecondaryDepth = var2;
            this.surfaceType = var3;
        }

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            boolean var1 = this.surfaceType == CaveSurface.CEILING;
            class A
            extends k {
                final /* synthetic */ g a;
                final /* synthetic */ boolean b;

                A(g g2, boolean bl) {
                    this.a = g2;
                    this.b = bl;
                    super(g2);
                }

                @Override
                protected boolean compute() {
                    return (this.b ? this.context.stoneDepthBelow : this.context.stoneDepthAbove) <= 1 + t.this.offset + (t.this.addSurfaceDepth ? this.context.surfaceDepth : 0) + (t.this.addSurfaceSecondaryDepth ? this.context.getSurfaceSecondaryDepth() : 0);
                }
            }
            return new A(var0, var1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{t.class, "offset;addSurfaceDepth;addSurfaceSecondaryDepth;surfaceType", "offset", "addSurfaceDepth", "addSurfaceSecondaryDepth", "surfaceType"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{t.class, "offset;addSurfaceDepth;addSurfaceSecondaryDepth;surfaceType", "offset", "addSurfaceDepth", "addSurfaceSecondaryDepth", "surfaceType"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{t.class, "offset;addSurfaceDepth;addSurfaceSecondaryDepth;surfaceType", "offset", "addSurfaceDepth", "addSurfaceSecondaryDepth", "surfaceType"}, this, var0);
        }

        public int offset() {
            return this.offset;
        }

        public boolean addSurfaceDepth() {
            return this.addSurfaceDepth;
        }

        public boolean addSurfaceSecondaryDepth() {
            return this.addSurfaceSecondaryDepth;
        }

        public CaveSurface surfaceType() {
            return this.surfaceType;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    record n(f target) implements f
    {
        static final Codec<n> CODEC = f.CODEC.xmap(n::new, n::target).fieldOf("invert").codec();

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            return new m((e)this.target.apply(var0));
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    public static interface f
    extends Function<g, e> {
        public static final Codec<f> CODEC = IRegistry.CONDITION.byNameCodec().dispatch(f::codec, Function.identity());

        public static Codec<? extends f> bootstrap() {
            IRegistry.register(IRegistry.CONDITION, "biome", c.CODEC);
            IRegistry.register(IRegistry.CONDITION, "noise_threshold", l.CODEC);
            IRegistry.register(IRegistry.CONDITION, "vertical_gradient", y.CODEC);
            IRegistry.register(IRegistry.CONDITION, "y_above", aa.CODEC);
            IRegistry.register(IRegistry.CONDITION, "water", z.CODEC);
            IRegistry.register(IRegistry.CONDITION, "temperature", v.CODEC);
            IRegistry.register(IRegistry.CONDITION, "steep", s.CODEC);
            IRegistry.register(IRegistry.CONDITION, "not", n.CODEC);
            IRegistry.register(IRegistry.CONDITION, "hole", h.CODEC);
            IRegistry.register(IRegistry.CONDITION, "above_preliminary_surface", a.CODEC);
            IRegistry.register(IRegistry.CONDITION, "stone_depth", t.CODEC);
            return (Codec)IRegistry.CONDITION.iterator().next();
        }

        public Codec<? extends f> codec();
    }

    static final class aa
    extends Record
    implements f {
        final VerticalAnchor anchor;
        final int surfaceDepthMultiplier;
        final boolean addStoneDepth;
        static final Codec<aa> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)VerticalAnchor.CODEC.fieldOf("anchor").forGetter(aa::anchor), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(aa::surfaceDepthMultiplier), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(aa::addStoneDepth)).apply((Applicative)var0, aa::new));

        aa(VerticalAnchor var0, int var1, boolean var2) {
            this.anchor = var0;
            this.surfaceDepthMultiplier = var1;
            this.addStoneDepth = var2;
        }

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            class A
            extends k {
                final /* synthetic */ g a;

                A(g g2) {
                    this.a = g2;
                    super(g2);
                }

                @Override
                protected boolean compute() {
                    return this.context.blockY + (aa.this.addStoneDepth ? this.context.stoneDepthAbove : 0) >= aa.this.anchor.resolveY(this.context.context) + this.context.surfaceDepth * aa.this.surfaceDepthMultiplier;
                }
            }
            return new A(var0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{aa.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "anchor", "surfaceDepthMultiplier", "addStoneDepth"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{aa.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "anchor", "surfaceDepthMultiplier", "addStoneDepth"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{aa.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "anchor", "surfaceDepthMultiplier", "addStoneDepth"}, this, var0);
        }

        public VerticalAnchor anchor() {
            return this.anchor;
        }

        public int surfaceDepthMultiplier() {
            return this.surfaceDepthMultiplier;
        }

        public boolean addStoneDepth() {
            return this.addStoneDepth;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    static final class z
    extends Record
    implements f {
        final int offset;
        final int surfaceDepthMultiplier;
        final boolean addStoneDepth;
        static final Codec<z> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("offset").forGetter(z::offset), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(z::surfaceDepthMultiplier), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(z::addStoneDepth)).apply((Applicative)var0, z::new));

        z(int var0, int var1, boolean var2) {
            this.offset = var0;
            this.surfaceDepthMultiplier = var1;
            this.addStoneDepth = var2;
        }

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            class A
            extends k {
                final /* synthetic */ g a;

                A(g g2) {
                    this.a = g2;
                    super(g2);
                }

                @Override
                protected boolean compute() {
                    return this.context.waterHeight == Integer.MIN_VALUE || this.context.blockY + (z.this.addStoneDepth ? this.context.stoneDepthAbove : 0) >= this.context.waterHeight + z.this.offset + this.context.surfaceDepth * z.this.surfaceDepthMultiplier;
                }
            }
            return new A(var0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{z.class, "offset;surfaceDepthMultiplier;addStoneDepth", "offset", "surfaceDepthMultiplier", "addStoneDepth"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{z.class, "offset;surfaceDepthMultiplier;addStoneDepth", "offset", "surfaceDepthMultiplier", "addStoneDepth"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{z.class, "offset;surfaceDepthMultiplier;addStoneDepth", "offset", "surfaceDepthMultiplier", "addStoneDepth"}, this, var0);
        }

        public int offset() {
            return this.offset;
        }

        public int surfaceDepthMultiplier() {
            return this.surfaceDepthMultiplier;
        }

        public boolean addStoneDepth() {
            return this.addStoneDepth;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    record c(List<ResourceKey<BiomeBase>> biomes) implements f
    {
        static final Codec<c> CODEC = ResourceKey.codec(IRegistry.BIOME_REGISTRY).listOf().fieldOf("biome_is").xmap(SurfaceRules::isBiome, c::biomes).codec();

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            Set<ResourceKey<BiomeBase>> var1 = Set.copyOf(this.biomes);
            class A
            extends k {
                final /* synthetic */ g a;
                final /* synthetic */ Set b;

                A(g g2, Set set) {
                    this.a = g2;
                    this.b = set;
                    super(g2);
                }

                @Override
                protected boolean compute() {
                    return this.b.contains(this.context.biomeKey.get());
                }
            }
            return new A(var0, var1);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    static final class l
    extends Record
    implements f {
        private final ResourceKey<NoiseGeneratorNormal.a> noise;
        final double minThreshold;
        final double maxThreshold;
        static final Codec<l> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ResourceKey.codec(IRegistry.NOISE_REGISTRY).fieldOf("noise").forGetter(l::noise), (App)Codec.DOUBLE.fieldOf("min_threshold").forGetter(l::minThreshold), (App)Codec.DOUBLE.fieldOf("max_threshold").forGetter(l::maxThreshold)).apply((Applicative)var0, l::new));

        l(ResourceKey<NoiseGeneratorNormal.a> var0, double var1, double var3) {
            this.noise = var0;
            this.minThreshold = var1;
            this.maxThreshold = var3;
        }

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            NoiseGeneratorNormal var1 = var0.system.getOrCreateNoise(this.noise);
            class A
            extends j {
                final /* synthetic */ g a;
                final /* synthetic */ NoiseGeneratorNormal b;

                A(g g2, NoiseGeneratorNormal noiseGeneratorNormal) {
                    this.a = g2;
                    this.b = noiseGeneratorNormal;
                    super(g2);
                }

                @Override
                protected boolean compute() {
                    double var0 = this.b.getValue(this.context.blockX, 0.0, this.context.blockZ);
                    return var0 >= l.this.minThreshold && var0 <= l.this.maxThreshold;
                }
            }
            return new A(var0, var1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{l.class, "noise;minThreshold;maxThreshold", "noise", "minThreshold", "maxThreshold"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{l.class, "noise;minThreshold;maxThreshold", "noise", "minThreshold", "maxThreshold"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{l.class, "noise;minThreshold;maxThreshold", "noise", "minThreshold", "maxThreshold"}, this, var0);
        }

        public ResourceKey<NoiseGeneratorNormal.a> noise() {
            return this.noise;
        }

        public double minThreshold() {
            return this.minThreshold;
        }

        public double maxThreshold() {
            return this.maxThreshold;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    record y(MinecraftKey randomName, VerticalAnchor trueAtAndBelow, VerticalAnchor falseAtAndAbove) implements f
    {
        static final Codec<y> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("random_name").forGetter(y::randomName), (App)VerticalAnchor.CODEC.fieldOf("true_at_and_below").forGetter(y::trueAtAndBelow), (App)VerticalAnchor.CODEC.fieldOf("false_at_and_above").forGetter(y::falseAtAndAbove)).apply((Applicative)var0, y::new));

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            int var1 = this.trueAtAndBelow().resolveY(var0.context);
            int var2 = this.falseAtAndAbove().resolveY(var0.context);
            PositionalRandomFactory var3 = var0.system.getOrCreateRandomFactory(this.randomName());
            class A
            extends k {
                final /* synthetic */ g a;
                final /* synthetic */ int b;
                final /* synthetic */ int c;
                final /* synthetic */ PositionalRandomFactory f;

                A(g g2, int n2, int n3, PositionalRandomFactory positionalRandomFactory) {
                    this.a = g2;
                    this.b = n2;
                    this.c = n3;
                    this.f = positionalRandomFactory;
                    super(g2);
                }

                @Override
                protected boolean compute() {
                    int var0 = this.context.blockY;
                    if (var0 <= this.b) {
                        return true;
                    }
                    if (var0 >= this.c) {
                        return false;
                    }
                    double var1 = MathHelper.map((double)var0, (double)this.b, (double)this.c, 1.0, 0.0);
                    RandomSource var3 = this.f.at(this.context.blockX, var0, this.context.blockZ);
                    return (double)var3.nextFloat() < var1;
                }
            }
            return new A(var0, var1, var2, var3);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    static final class s
    extends Enum<s>
    implements f {
        public static final /* enum */ s INSTANCE = new s();
        static final Codec<s> CODEC;
        private static final /* synthetic */ s[] d;

        public static s[] values() {
            return (s[])d.clone();
        }

        public static s valueOf(String var0) {
            return Enum.valueOf(s.class, var0);
        }

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            return var0.steep;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }

        private static /* synthetic */ s[] b() {
            return new s[]{INSTANCE};
        }

        static {
            d = s.b();
            CODEC = Codec.unit((Object)INSTANCE);
        }
    }

    static final class h
    extends Enum<h>
    implements f {
        public static final /* enum */ h INSTANCE = new h();
        static final Codec<h> CODEC;
        private static final /* synthetic */ h[] d;

        public static h[] values() {
            return (h[])d.clone();
        }

        public static h valueOf(String var0) {
            return Enum.valueOf(h.class, var0);
        }

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            return var0.hole;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }

        private static /* synthetic */ h[] b() {
            return new h[]{INSTANCE};
        }

        static {
            d = h.b();
            CODEC = Codec.unit((Object)INSTANCE);
        }
    }

    static final class a
    extends Enum<a>
    implements f {
        public static final /* enum */ a INSTANCE = new a();
        static final Codec<a> CODEC;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            return var0.abovePreliminarySurface;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }

        private static /* synthetic */ a[] b() {
            return new a[]{INSTANCE};
        }

        static {
            d = a.b();
            CODEC = Codec.unit((Object)INSTANCE);
        }
    }

    static final class v
    extends Enum<v>
    implements f {
        public static final /* enum */ v INSTANCE = new v();
        static final Codec<v> CODEC;
        private static final /* synthetic */ v[] d;

        public static v[] values() {
            return (v[])d.clone();
        }

        public static v valueOf(String var0) {
            return Enum.valueOf(v.class, var0);
        }

        @Override
        public Codec<? extends f> codec() {
            return CODEC;
        }

        @Override
        public e apply(g var0) {
            return var0.temperature;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }

        private static /* synthetic */ v[] b() {
            return new v[]{INSTANCE};
        }

        static {
            d = v.b();
            CODEC = Codec.unit((Object)INSTANCE);
        }
    }

    record x(f ifTrue, o thenRun) implements o
    {
        static final Codec<x> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)f.CODEC.fieldOf("if_true").forGetter(x::ifTrue), (App)o.CODEC.fieldOf("then_run").forGetter(x::thenRun)).apply((Applicative)var0, x::new));

        @Override
        public Codec<? extends o> codec() {
            return CODEC;
        }

        @Override
        public u apply(g var0) {
            return new w((e)this.ifTrue.apply(var0), (u)this.thenRun.apply(var0));
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    public static interface o
    extends Function<g, u> {
        public static final Codec<o> CODEC = IRegistry.RULE.byNameCodec().dispatch(o::codec, Function.identity());

        public static Codec<? extends o> bootstrap() {
            IRegistry.register(IRegistry.RULE, "bandlands", b.CODEC);
            IRegistry.register(IRegistry.RULE, "block", d.CODEC);
            IRegistry.register(IRegistry.RULE, "sequence", q.CODEC);
            IRegistry.register(IRegistry.RULE, "condition", x.CODEC);
            return (Codec)IRegistry.RULE.iterator().next();
        }

        public Codec<? extends o> codec();
    }

    record q(List<o> sequence) implements o
    {
        static final Codec<q> CODEC = o.CODEC.listOf().xmap(q::new, q::sequence).fieldOf("sequence").codec();

        @Override
        public Codec<? extends o> codec() {
            return CODEC;
        }

        @Override
        public u apply(g var0) {
            if (this.sequence.size() == 1) {
                return (u)this.sequence.get(0).apply(var0);
            }
            ImmutableList.Builder var1 = ImmutableList.builder();
            for (o var3 : this.sequence) {
                var1.add((Object)((u)var3.apply(var0)));
            }
            return new p((List<u>)var1.build());
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    record d(IBlockData resultState, r rule) implements o
    {
        static final Codec<d> CODEC = IBlockData.CODEC.xmap(d::new, d::resultState).fieldOf("result_state").codec();

        d(IBlockData var0) {
            this(var0, new r(var0));
        }

        @Override
        public Codec<? extends o> codec() {
            return CODEC;
        }

        @Override
        public u apply(g var0) {
            return this.rule;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }
    }

    static final class b
    extends Enum<b>
    implements o {
        public static final /* enum */ b INSTANCE = new b();
        static final Codec<b> CODEC;
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        @Override
        public Codec<? extends o> codec() {
            return CODEC;
        }

        @Override
        public u apply(g var0) {
            return var0.system::getBand;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((g)object);
        }

        private static /* synthetic */ b[] b() {
            return new b[]{INSTANCE};
        }

        static {
            d = b.b();
            CODEC = Codec.unit((Object)INSTANCE);
        }
    }

    record p(List<u> rules) implements u
    {
        @Override
        @Nullable
        public IBlockData tryApply(int var0, int var1, int var2) {
            for (u var4 : this.rules) {
                IBlockData var5 = var4.tryApply(var0, var1, var2);
                if (var5 == null) continue;
                return var5;
            }
            return null;
        }
    }

    record w(e condition, u followup) implements u
    {
        @Override
        @Nullable
        public IBlockData tryApply(int var0, int var1, int var2) {
            if (!this.condition.test()) {
                return null;
            }
            return this.followup.tryApply(var0, var1, var2);
        }
    }

    record r(IBlockData state) implements u
    {
        @Override
        public IBlockData tryApply(int var0, int var1, int var2) {
            return this.state;
        }
    }

    protected static interface u {
        @Nullable
        public IBlockData tryApply(int var1, int var2, int var3);
    }

    record m(e target) implements e
    {
        @Override
        public boolean test() {
            return !this.target.test();
        }
    }

    static abstract class k
    extends i {
        protected k(g var0) {
            super(var0);
        }

        @Override
        protected long getContextLastUpdate() {
            return this.context.lastUpdateY;
        }
    }

    static abstract class j
    extends i {
        protected j(g var0) {
            super(var0);
        }

        @Override
        protected long getContextLastUpdate() {
            return this.context.lastUpdateXZ;
        }
    }

    static abstract class i
    implements e {
        protected final g context;
        private long lastUpdate;
        @Nullable
        Boolean result;

        protected i(g var0) {
            this.context = var0;
            this.lastUpdate = this.getContextLastUpdate() - 1L;
        }

        @Override
        public boolean test() {
            long var0 = this.getContextLastUpdate();
            if (var0 == this.lastUpdate) {
                if (this.result == null) {
                    throw new IllegalStateException("Update triggered but the result is null");
                }
                return this.result;
            }
            this.lastUpdate = var0;
            this.result = this.compute();
            return this.result;
        }

        protected abstract long getContextLastUpdate();

        protected abstract boolean compute();
    }

    static interface e {
        public boolean test();
    }

    protected static final class g {
        private static final int HOW_FAR_BELOW_PRELIMINARY_SURFACE_LEVEL_TO_BUILD_SURFACE = 8;
        private static final int SURFACE_CELL_BITS = 4;
        private static final int SURFACE_CELL_SIZE = 16;
        private static final int SURFACE_CELL_MASK = 15;
        final SurfaceSystem system;
        final e temperature = new d(this);
        final e steep = new c(this);
        final e hole = new b(this);
        final e abovePreliminarySurface = new a();
        final IChunkAccess chunk;
        private final NoiseChunk noiseChunk;
        private final Function<BlockPosition, BiomeBase> biomeGetter;
        private final IRegistry<BiomeBase> biomes;
        final WorldGenerationContext context;
        private long lastPreliminarySurfaceCellOrigin = Long.MAX_VALUE;
        private final int[] preliminarySurfaceCache = new int[4];
        long lastUpdateXZ = -9223372036854775807L;
        int blockX;
        int blockZ;
        int surfaceDepth;
        private long lastSurfaceDepth2Update = this.lastUpdateXZ - 1L;
        private int surfaceSecondaryDepth;
        private long lastMinSurfaceLevelUpdate = this.lastUpdateXZ - 1L;
        private int minSurfaceLevel;
        long lastUpdateY = -9223372036854775807L;
        final BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
        Supplier<BiomeBase> biome;
        Supplier<ResourceKey<BiomeBase>> biomeKey;
        int blockY;
        int waterHeight;
        int stoneDepthBelow;
        int stoneDepthAbove;

        protected g(SurfaceSystem var0, IChunkAccess var1, NoiseChunk var2, Function<BlockPosition, BiomeBase> var3, IRegistry<BiomeBase> var4, WorldGenerationContext var5) {
            this.system = var0;
            this.chunk = var1;
            this.noiseChunk = var2;
            this.biomeGetter = var3;
            this.biomes = var4;
            this.context = var5;
        }

        protected void updateXZ(int var0, int var1) {
            ++this.lastUpdateXZ;
            ++this.lastUpdateY;
            this.blockX = var0;
            this.blockZ = var1;
            this.surfaceDepth = this.system.getSurfaceDepth(var0, var1);
        }

        protected void updateY(int var0, int var1, int var2, int var3, int var4, int var5) {
            ++this.lastUpdateY;
            this.biome = Suppliers.memoize(() -> this.biomeGetter.apply(this.pos.set(var3, var4, var5)));
            this.biomeKey = Suppliers.memoize(() -> this.biomes.getResourceKey(this.biome.get()).orElseThrow(() -> new IllegalStateException("Unregistered biome: " + this.biome)));
            this.blockY = var4;
            this.waterHeight = var2;
            this.stoneDepthBelow = var1;
            this.stoneDepthAbove = var0;
        }

        protected int getSurfaceSecondaryDepth() {
            if (this.lastSurfaceDepth2Update != this.lastUpdateXZ) {
                this.lastSurfaceDepth2Update = this.lastUpdateXZ;
                this.surfaceSecondaryDepth = this.system.getSurfaceSecondaryDepth(this.blockX, this.blockZ);
            }
            return this.surfaceSecondaryDepth;
        }

        private static int blockCoordToSurfaceCell(int var0) {
            return var0 >> 4;
        }

        private static int surfaceCellToBlockCoord(int var0) {
            return var0 << 4;
        }

        protected int getMinSurfaceLevel() {
            if (this.lastMinSurfaceLevelUpdate != this.lastUpdateXZ) {
                int var1;
                this.lastMinSurfaceLevelUpdate = this.lastUpdateXZ;
                int var0 = g.blockCoordToSurfaceCell(this.blockX);
                long var2 = ChunkCoordIntPair.asLong(var0, var1 = g.blockCoordToSurfaceCell(this.blockZ));
                if (this.lastPreliminarySurfaceCellOrigin != var2) {
                    this.lastPreliminarySurfaceCellOrigin = var2;
                    this.preliminarySurfaceCache[0] = this.noiseChunk.preliminarySurfaceLevel(g.surfaceCellToBlockCoord(var0), g.surfaceCellToBlockCoord(var1));
                    this.preliminarySurfaceCache[1] = this.noiseChunk.preliminarySurfaceLevel(g.surfaceCellToBlockCoord(var0 + 1), g.surfaceCellToBlockCoord(var1));
                    this.preliminarySurfaceCache[2] = this.noiseChunk.preliminarySurfaceLevel(g.surfaceCellToBlockCoord(var0), g.surfaceCellToBlockCoord(var1 + 1));
                    this.preliminarySurfaceCache[3] = this.noiseChunk.preliminarySurfaceLevel(g.surfaceCellToBlockCoord(var0 + 1), g.surfaceCellToBlockCoord(var1 + 1));
                }
                int var4 = MathHelper.floor(MathHelper.lerp2((float)(this.blockX & 0xF) / 16.0f, (float)(this.blockZ & 0xF) / 16.0f, this.preliminarySurfaceCache[0], this.preliminarySurfaceCache[1], this.preliminarySurfaceCache[2], this.preliminarySurfaceCache[3]));
                this.minSurfaceLevel = var4 + this.surfaceDepth - 8;
            }
            return this.minSurfaceLevel;
        }

        static class d
        extends k {
            d(g var0) {
                super(var0);
            }

            @Override
            protected boolean compute() {
                return this.context.biome.get().coldEnoughToSnow(this.context.pos.set(this.context.blockX, this.context.blockY, this.context.blockZ));
            }
        }

        static class c
        extends j {
            c(g var0) {
                super(var0);
            }

            @Override
            protected boolean compute() {
                int var10;
                int var0 = this.context.blockX & 0xF;
                int var1 = this.context.blockZ & 0xF;
                int var2 = Math.max(var1 - 1, 0);
                int var3 = Math.min(var1 + 1, 15);
                IChunkAccess var4 = this.context.chunk;
                int var5 = var4.getHeight(HeightMap.Type.WORLD_SURFACE_WG, var0, var2);
                int var6 = var4.getHeight(HeightMap.Type.WORLD_SURFACE_WG, var0, var3);
                if (var6 >= var5 + 4) {
                    return true;
                }
                int var7 = Math.max(var0 - 1, 0);
                int var8 = Math.min(var0 + 1, 15);
                int var9 = var4.getHeight(HeightMap.Type.WORLD_SURFACE_WG, var7, var1);
                return var9 >= (var10 = var4.getHeight(HeightMap.Type.WORLD_SURFACE_WG, var8, var1)) + 4;
            }
        }

        static final class b
        extends j {
            b(g var0) {
                super(var0);
            }

            @Override
            protected boolean compute() {
                return this.context.surfaceDepth <= 0;
            }
        }

        final class a
        implements e {
            a() {
            }

            @Override
            public boolean test() {
                return g.this.blockY >= g.this.getMinSurfaceLevel();
            }
        }
    }
}

