/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsStronghold;

public class StructureSettings {
    public static final Codec<StructureSettings> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)StructureSettingsStronghold.CODEC.optionalFieldOf("stronghold").forGetter(var0 -> Optional.ofNullable(var0.stronghold)), (App)Codec.simpleMap(IRegistry.STRUCTURE_FEATURE.byNameCodec(), StructureSettingsFeature.CODEC, IRegistry.STRUCTURE_FEATURE).fieldOf("structures").forGetter(var0 -> var0.structureConfig)).apply((Applicative)var02, StructureSettings::new));
    public static final ImmutableMap<StructureGenerator<?>, StructureSettingsFeature> DEFAULTS = ImmutableMap.builder().put(StructureGenerator.VILLAGE, (Object)new StructureSettingsFeature(34, 8, 10387312)).put(StructureGenerator.DESERT_PYRAMID, (Object)new StructureSettingsFeature(32, 8, 14357617)).put(StructureGenerator.IGLOO, (Object)new StructureSettingsFeature(32, 8, 14357618)).put(StructureGenerator.JUNGLE_TEMPLE, (Object)new StructureSettingsFeature(32, 8, 14357619)).put(StructureGenerator.SWAMP_HUT, (Object)new StructureSettingsFeature(32, 8, 14357620)).put(StructureGenerator.PILLAGER_OUTPOST, (Object)new StructureSettingsFeature(32, 8, 165745296)).put(StructureGenerator.STRONGHOLD, (Object)new StructureSettingsFeature(1, 0, 0)).put(StructureGenerator.OCEAN_MONUMENT, (Object)new StructureSettingsFeature(32, 5, 10387313)).put(StructureGenerator.END_CITY, (Object)new StructureSettingsFeature(20, 11, 10387313)).put(StructureGenerator.WOODLAND_MANSION, (Object)new StructureSettingsFeature(80, 20, 10387319)).put(StructureGenerator.BURIED_TREASURE, (Object)new StructureSettingsFeature(1, 0, 0)).put(StructureGenerator.MINESHAFT, (Object)new StructureSettingsFeature(1, 0, 0)).put(StructureGenerator.RUINED_PORTAL, (Object)new StructureSettingsFeature(40, 15, 34222645)).put(StructureGenerator.SHIPWRECK, (Object)new StructureSettingsFeature(24, 4, 165745295)).put(StructureGenerator.OCEAN_RUIN, (Object)new StructureSettingsFeature(20, 8, 14357621)).put(StructureGenerator.BASTION_REMNANT, (Object)new StructureSettingsFeature(27, 4, 30084232)).put(StructureGenerator.NETHER_BRIDGE, (Object)new StructureSettingsFeature(27, 4, 30084232)).put(StructureGenerator.NETHER_FOSSIL, (Object)new StructureSettingsFeature(2, 1, 14357921)).build();
    public static final StructureSettingsStronghold DEFAULT_STRONGHOLD;
    private final Map<StructureGenerator<?>, StructureSettingsFeature> structureConfig;
    private final ImmutableMap<StructureGenerator<?>, ImmutableMultimap<StructureFeature<?, ?>, ResourceKey<BiomeBase>>> configuredStructures;
    @Nullable
    private final StructureSettingsStronghold stronghold;

    private StructureSettings(Map<StructureGenerator<?>, StructureSettingsFeature> var02, @Nullable StructureSettingsStronghold var12) {
        this.stronghold = var12;
        this.structureConfig = var02;
        HashMap var22 = new HashMap();
        StructureFeatures.registerStructures((var1, var2) -> var22.computeIfAbsent(var1.feature, var0 -> ImmutableMultimap.builder()).put(var1, var2));
        this.configuredStructures = (ImmutableMap)var22.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> ((ImmutableMultimap.Builder)var0.getValue()).build()));
    }

    public StructureSettings(Optional<StructureSettingsStronghold> var0, Map<StructureGenerator<?>, StructureSettingsFeature> var1) {
        this(var1, var0.orElse(null));
    }

    public StructureSettings(boolean var0) {
        this(Maps.newHashMap(DEFAULTS), var0 ? DEFAULT_STRONGHOLD : null);
    }

    @VisibleForTesting
    public Map<StructureGenerator<?>, StructureSettingsFeature> structureConfig() {
        return this.structureConfig;
    }

    @Nullable
    public StructureSettingsFeature getConfig(StructureGenerator<?> var0) {
        return this.structureConfig.get(var0);
    }

    @Nullable
    public StructureSettingsStronghold stronghold() {
        return this.stronghold;
    }

    public ImmutableMultimap<StructureFeature<?, ?>, ResourceKey<BiomeBase>> structures(StructureGenerator<?> var0) {
        return (ImmutableMultimap)this.configuredStructures.getOrDefault(var0, (Object)ImmutableMultimap.of());
    }

    static {
        for (StructureGenerator structureGenerator : IRegistry.STRUCTURE_FEATURE) {
            if (DEFAULTS.containsKey((Object)structureGenerator)) continue;
            throw new IllegalStateException("Structure feature without default settings: " + IRegistry.STRUCTURE_FEATURE.getKey(structureGenerator));
        }
        DEFAULT_STRONGHOLD = new StructureSettingsStronghold(32, 3, 128);
    }
}

