/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneratorSettings {
    public static final Codec<GeneratorSettings> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(GeneratorSettings::seed), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(GeneratorSettings::generateFeatures), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(GeneratorSettings::generateBonusChest), (App)RegistryMaterials.dataPackCodec(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.stable(), WorldDimension.CODEC).xmap(WorldDimension::sortMap, Function.identity()).fieldOf("dimensions").forGetter(GeneratorSettings::dimensions), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(var0 -> var0.legacyCustomOptions)).apply((Applicative)var02, var02.stable(GeneratorSettings::new))).comapFlatMap(GeneratorSettings::guardExperimental, Function.identity());
    private static final Logger LOGGER = LogManager.getLogger();
    private final long seed;
    private final boolean generateFeatures;
    private final boolean generateBonusChest;
    private final RegistryMaterials<WorldDimension> dimensions;
    private final Optional<String> legacyCustomOptions;

    private DataResult<GeneratorSettings> guardExperimental() {
        WorldDimension var0 = this.dimensions.get(WorldDimension.OVERWORLD);
        if (var0 == null) {
            return DataResult.error((String)"Overworld settings missing");
        }
        if (this.stable()) {
            return DataResult.success((Object)this, (Lifecycle)Lifecycle.stable());
        }
        return DataResult.success((Object)this);
    }

    private boolean stable() {
        return WorldDimension.stable(this.seed, this.dimensions);
    }

    public GeneratorSettings(long var0, boolean var2, boolean var3, RegistryMaterials<WorldDimension> var4) {
        this(var0, var2, var3, var4, Optional.empty());
        WorldDimension var5 = var4.get(WorldDimension.OVERWORLD);
        if (var5 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    private GeneratorSettings(long var0, boolean var2, boolean var3, RegistryMaterials<WorldDimension> var4, Optional<String> var5) {
        this.seed = var0;
        this.generateFeatures = var2;
        this.generateBonusChest = var3;
        this.dimensions = var4;
        this.legacyCustomOptions = var5;
    }

    public static GeneratorSettings demoSettings(IRegistryCustom var0) {
        int var1 = "North Carolina".hashCode();
        return new GeneratorSettings(var1, true, true, GeneratorSettings.withOverworld(var0.registryOrThrow(IRegistry.DIMENSION_TYPE_REGISTRY), DimensionManager.defaultDimensions(var0, var1), (ChunkGenerator)GeneratorSettings.makeDefaultOverworld(var0, var1)));
    }

    public static GeneratorSettings makeDefault(IRegistryCustom var0) {
        long var1 = new Random().nextLong();
        return new GeneratorSettings(var1, true, false, GeneratorSettings.withOverworld(var0.registryOrThrow(IRegistry.DIMENSION_TYPE_REGISTRY), DimensionManager.defaultDimensions(var0, var1), (ChunkGenerator)GeneratorSettings.makeDefaultOverworld(var0, var1)));
    }

    public static ChunkGeneratorAbstract makeDefaultOverworld(IRegistryCustom var0, long var1) {
        return GeneratorSettings.makeDefaultOverworld(var0, var1, true);
    }

    public static ChunkGeneratorAbstract makeDefaultOverworld(IRegistryCustom var0, long var1, boolean var3) {
        return GeneratorSettings.makeOverworld(var0, var1, GeneratorSettingBase.OVERWORLD, var3);
    }

    public static ChunkGeneratorAbstract makeOverworld(IRegistryCustom var0, long var1, ResourceKey<GeneratorSettingBase> var3) {
        return GeneratorSettings.makeOverworld(var0, var1, var3, true);
    }

    public static ChunkGeneratorAbstract makeOverworld(IRegistryCustom var0, long var1, ResourceKey<GeneratorSettingBase> var3, boolean var4) {
        return new ChunkGeneratorAbstract(var0.registryOrThrow(IRegistry.NOISE_REGISTRY), (WorldChunkManager)WorldChunkManagerMultiNoise.a.OVERWORLD.biomeSource(var0.registryOrThrow(IRegistry.BIOME_REGISTRY), var4), var1, () -> var0.registryOrThrow(IRegistry.NOISE_GENERATOR_SETTINGS_REGISTRY).getOrThrow(var3));
    }

    public long seed() {
        return this.seed;
    }

    public boolean generateFeatures() {
        return this.generateFeatures;
    }

    public boolean generateBonusChest() {
        return this.generateBonusChest;
    }

    public static RegistryMaterials<WorldDimension> withOverworld(IRegistry<DimensionManager> var0, RegistryMaterials<WorldDimension> var1, ChunkGenerator var2) {
        WorldDimension var3 = var1.get(WorldDimension.OVERWORLD);
        Supplier<DimensionManager> var4 = () -> var3 == null ? var0.getOrThrow(DimensionManager.OVERWORLD_LOCATION) : var3.type();
        return GeneratorSettings.withOverworld(var1, var4, var2);
    }

    public static RegistryMaterials<WorldDimension> withOverworld(RegistryMaterials<WorldDimension> var0, Supplier<DimensionManager> var1, ChunkGenerator var2) {
        RegistryMaterials<WorldDimension> var3 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental());
        var3.register(WorldDimension.OVERWORLD, new WorldDimension(var1, var2), Lifecycle.stable());
        for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> var5 : var0.entrySet()) {
            ResourceKey<WorldDimension> var6 = var5.getKey();
            if (var6 == WorldDimension.OVERWORLD) continue;
            var3.register(var6, var5.getValue(), var0.lifecycle(var5.getValue()));
        }
        return var3;
    }

    public RegistryMaterials<WorldDimension> dimensions() {
        return this.dimensions;
    }

    public ChunkGenerator overworld() {
        WorldDimension var0 = this.dimensions.get(WorldDimension.OVERWORLD);
        if (var0 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return var0.generator();
    }

    public ImmutableSet<ResourceKey<World>> levels() {
        return (ImmutableSet)this.dimensions().entrySet().stream().map(Map.Entry::getKey).map(GeneratorSettings::levelStemToLevel).collect(ImmutableSet.toImmutableSet());
    }

    public static ResourceKey<World> levelStemToLevel(ResourceKey<WorldDimension> var0) {
        return ResourceKey.create(IRegistry.DIMENSION_REGISTRY, var0.location());
    }

    public static ResourceKey<WorldDimension> levelToLevelStem(ResourceKey<World> var0) {
        return ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, var0.location());
    }

    public boolean isDebug() {
        return this.overworld() instanceof ChunkProviderDebug;
    }

    public boolean isFlatWorld() {
        return this.overworld() instanceof ChunkProviderFlat;
    }

    public boolean isOldCustomizedWorld() {
        return this.legacyCustomOptions.isPresent();
    }

    public GeneratorSettings withBonusChest() {
        return new GeneratorSettings(this.seed, this.generateFeatures, true, this.dimensions, this.legacyCustomOptions);
    }

    public GeneratorSettings withFeaturesToggled() {
        return new GeneratorSettings(this.seed, !this.generateFeatures, this.generateBonusChest, this.dimensions);
    }

    public GeneratorSettings withBonusChestToggled() {
        return new GeneratorSettings(this.seed, this.generateFeatures, !this.generateBonusChest, this.dimensions);
    }

    public static GeneratorSettings create(IRegistryCustom var02, Properties var1) {
        String var2 = (String)MoreObjects.firstNonNull((Object)((String)var1.get("generator-settings")), (Object)"");
        var1.put("generator-settings", var2);
        String var3 = (String)MoreObjects.firstNonNull((Object)((String)var1.get("level-seed")), (Object)"");
        var1.put("level-seed", var3);
        String var4 = (String)var1.get("generate-structures");
        boolean var5 = var4 == null || Boolean.parseBoolean(var4);
        var1.put("generate-structures", Objects.toString(var5));
        String var6 = (String)var1.get("level-type");
        String var7 = Optional.ofNullable(var6).map(var0 -> var0.toLowerCase(Locale.ROOT)).orElse("default");
        var1.put("level-type", var7);
        long var8 = new Random().nextLong();
        if (!var3.isEmpty()) {
            try {
                long var10 = Long.parseLong(var3);
                if (var10 != 0L) {
                    var8 = var10;
                }
            }
            catch (NumberFormatException var10) {
                var8 = var3.hashCode();
            }
        }
        IRegistry<DimensionManager> var10 = var02.registryOrThrow(IRegistry.DIMENSION_TYPE_REGISTRY);
        IRegistry<BiomeBase> var11 = var02.registryOrThrow(IRegistry.BIOME_REGISTRY);
        RegistryMaterials<WorldDimension> var12 = DimensionManager.defaultDimensions(var02, var8);
        switch (var7) {
            case "flat": {
                JsonObject var15 = !var2.isEmpty() ? ChatDeserializer.parse(var2) : new JsonObject();
                Dynamic var16 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)var15);
                return new GeneratorSettings(var8, var5, false, GeneratorSettings.withOverworld(var10, var12, (ChunkGenerator)new ChunkProviderFlat(GeneratorSettingsFlat.CODEC.parse(var16).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(() -> GeneratorSettingsFlat.getDefault(var11)))));
            }
            case "debug_all_block_states": {
                return new GeneratorSettings(var8, var5, false, GeneratorSettings.withOverworld(var10, var12, (ChunkGenerator)new ChunkProviderDebug(var11)));
            }
            case "amplified": {
                return new GeneratorSettings(var8, var5, false, GeneratorSettings.withOverworld(var10, var12, (ChunkGenerator)GeneratorSettings.makeOverworld(var02, var8, GeneratorSettingBase.AMPLIFIED)));
            }
            case "largebiomes": {
                return new GeneratorSettings(var8, var5, false, GeneratorSettings.withOverworld(var10, var12, (ChunkGenerator)GeneratorSettings.makeOverworld(var02, var8, GeneratorSettingBase.LARGE_BIOMES)));
            }
        }
        return new GeneratorSettings(var8, var5, false, GeneratorSettings.withOverworld(var10, var12, (ChunkGenerator)GeneratorSettings.makeDefaultOverworld(var02, var8)));
    }

    public GeneratorSettings withSeed(boolean var0, OptionalLong var1) {
        RegistryMaterials<WorldDimension> var5;
        long var3 = var1.orElse(this.seed);
        if (var1.isPresent()) {
            var5 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental());
            long var6 = var1.getAsLong();
            for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> var9 : this.dimensions.entrySet()) {
                ResourceKey<WorldDimension> var10 = var9.getKey();
                var5.register(var10, new WorldDimension(var9.getValue().typeSupplier(), var9.getValue().generator().withSeed(var6)), this.dimensions.lifecycle(var9.getValue()));
            }
        } else {
            var5 = this.dimensions;
        }
        GeneratorSettings var2 = this.isDebug() ? new GeneratorSettings(var3, false, false, var5) : new GeneratorSettings(var3, this.generateFeatures(), this.generateBonusChest() && !var0, var5);
        return var2;
    }
}

