/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeaturePillagerOutpost;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSwampHut;
import net.minecraft.world.level.levelgen.feature.WorldGenMonument;
import net.minecraft.world.level.levelgen.feature.WorldGenNether;
import net.minecraft.world.level.levelgen.material.MaterialRuleList;
import net.minecraft.world.level.levelgen.material.WorldGenMaterialRule;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public final class ChunkGeneratorAbstract
extends ChunkGenerator {
    public static final Codec<ChunkGeneratorAbstract> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)RegistryLookupCodec.create(IRegistry.NOISE_REGISTRY).forGetter(var0 -> var0.noises), (App)WorldChunkManager.CODEC.fieldOf("biome_source").forGetter(var0 -> var0.biomeSource), (App)Codec.LONG.fieldOf("seed").stable().forGetter(var0 -> var0.seed), (App)GeneratorSettingBase.CODEC.fieldOf("settings").forGetter(var0 -> var0.settings)).apply((Applicative)var02, var02.stable(ChunkGeneratorAbstract::new)));
    private static final IBlockData AIR = Blocks.AIR.defaultBlockState();
    private static final IBlockData[] EMPTY_COLUMN = new IBlockData[0];
    protected final IBlockData defaultBlock;
    public final IRegistry<NoiseGeneratorNormal.a> noises;
    private final long seed;
    public final Supplier<GeneratorSettingBase> settings;
    private final NoiseSampler sampler;
    private final SurfaceSystem surfaceSystem;
    private final WorldGenMaterialRule materialRule;
    private final Aquifer.a globalFluidPicker;

    public ChunkGeneratorAbstract(IRegistry<NoiseGeneratorNormal.a> var0, WorldChunkManager var1, long var2, Supplier<GeneratorSettingBase> var4) {
        this(var0, var1, var1, var2, var4);
    }

    private ChunkGeneratorAbstract(IRegistry<NoiseGeneratorNormal.a> var0, WorldChunkManager var1, WorldChunkManager var2, long var3, Supplier<GeneratorSettingBase> var52) {
        super(var1, var2, var52.get().structureSettings(), var3);
        this.noises = var0;
        this.seed = var3;
        this.settings = var52;
        GeneratorSettingBase var62 = this.settings.get();
        this.defaultBlock = var62.getDefaultBlock();
        NoiseSettings var7 = var62.noiseSettings();
        this.sampler = new NoiseSampler(var7, var62.isNoiseCavesEnabled(), var3, var0, var62.getRandomSource());
        ImmutableList.Builder var8 = ImmutableList.builder();
        var8.add(NoiseChunk::updateNoiseAndGenerateBaseState);
        var8.add(NoiseChunk::oreVeinify);
        this.materialRule = new MaterialRuleList((List<WorldGenMaterialRule>)var8.build());
        Aquifer.b var9 = new Aquifer.b(-54, Blocks.LAVA.defaultBlockState());
        int var10 = var62.seaLevel();
        Aquifer.b var11 = new Aquifer.b(var10, var62.getDefaultFluid());
        Aquifer.b var12 = new Aquifer.b(var7.minY() - 1, Blocks.AIR.defaultBlockState());
        this.globalFluidPicker = (var4, var5, var6) -> {
            if (var5 < Math.min(-54, var10)) {
                return var9;
            }
            return var11;
        };
        this.surfaceSystem = new SurfaceSystem(var0, this.defaultBlock, var10, var3, var62.getRandomSource());
    }

    @Override
    public CompletableFuture<IChunkAccess> createBiomes(IRegistry<BiomeBase> var0, Executor var1, Blender var2, StructureManager var3, IChunkAccess var4) {
        return CompletableFuture.supplyAsync(SystemUtils.wrapThreadWithTaskName("init_biomes", () -> {
            this.doCreateBiomes(var0, var2, var3, var4);
            return var4;
        }), SystemUtils.backgroundExecutor());
    }

    private void doCreateBiomes(IRegistry<BiomeBase> var0, Blender var12, StructureManager var22, IChunkAccess var32) {
        NoiseChunk var4 = var32.getOrCreateNoiseChunk(this.sampler, () -> new Beardifier(var22, var32), this.settings.get(), this.globalFluidPicker, var12);
        BiomeResolver var5 = BelowZeroRetrogen.getBiomeResolver(var12.getBiomeResolver(this.runtimeBiomeSource), var0, var32);
        var32.fillBiomesFromNoise(var5, (var1, var2, var3) -> this.sampler.target(var1, var2, var3, var4.noiseData(var1, var3)));
    }

    @Override
    public Climate.Sampler climateSampler() {
        return this.sampler;
    }

    @Override
    protected Codec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    @Override
    public ChunkGenerator withSeed(long var0) {
        return new ChunkGeneratorAbstract(this.noises, this.biomeSource.withSeed(var0), var0, this.settings);
    }

    public boolean stable(long var0, ResourceKey<GeneratorSettingBase> var2) {
        return this.seed == var0 && this.settings.get().stable(var2);
    }

    @Override
    public int getBaseHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3) {
        NoiseSettings var4 = this.settings.get().noiseSettings();
        int var5 = Math.max(var4.minY(), var3.getMinBuildHeight());
        int var6 = Math.min(var4.minY() + var4.height(), var3.getMaxBuildHeight());
        int var7 = MathHelper.intFloorDiv(var5, var4.getCellHeight());
        int var8 = MathHelper.intFloorDiv(var6 - var5, var4.getCellHeight());
        if (var8 <= 0) {
            return var3.getMinBuildHeight();
        }
        return this.iterateNoiseColumn(var0, var1, null, var2.isOpaque(), var7, var8).orElse(var3.getMinBuildHeight());
    }

    @Override
    public BlockColumn getBaseColumn(int var0, int var1, LevelHeightAccessor var2) {
        NoiseSettings var3 = this.settings.get().noiseSettings();
        int var4 = Math.max(var3.minY(), var2.getMinBuildHeight());
        int var5 = Math.min(var3.minY() + var3.height(), var2.getMaxBuildHeight());
        int var6 = MathHelper.intFloorDiv(var4, var3.getCellHeight());
        int var7 = MathHelper.intFloorDiv(var5 - var4, var3.getCellHeight());
        if (var7 <= 0) {
            return new BlockColumn(var4, EMPTY_COLUMN);
        }
        IBlockData[] var8 = new IBlockData[var7 * var3.getCellHeight()];
        this.iterateNoiseColumn(var0, var1, var8, null, var6, var7);
        return new BlockColumn(var4, var8);
    }

    private OptionalInt iterateNoiseColumn(int var0, int var1, @Nullable IBlockData[] var2, @Nullable Predicate<IBlockData> var3, int var4, int var5) {
        NoiseSettings var6 = this.settings.get().noiseSettings();
        int var7 = var6.getCellWidth();
        int var8 = var6.getCellHeight();
        int var9 = Math.floorDiv(var0, var7);
        int var10 = Math.floorDiv(var1, var7);
        int var11 = Math.floorMod(var0, var7);
        int var12 = Math.floorMod(var1, var7);
        int var13 = var9 * var7;
        int var14 = var10 * var7;
        double var15 = (double)var11 / (double)var7;
        double var17 = (double)var12 / (double)var7;
        NoiseChunk var19 = NoiseChunk.forColumn(var13, var14, var4, var5, this.sampler, this.settings.get(), this.globalFluidPicker);
        var19.initializeForFirstCellX();
        var19.advanceCellX(0);
        for (int var20 = var5 - 1; var20 >= 0; --var20) {
            var19.selectCellYZ(var20, 0);
            for (int var21 = var8 - 1; var21 >= 0; --var21) {
                IBlockData var26;
                int var22 = (var4 + var20) * var8 + var21;
                double var23 = (double)var21 / (double)var8;
                var19.updateForY(var23);
                var19.updateForX(var15);
                var19.updateForZ(var17);
                IBlockData var25 = this.materialRule.apply(var19, var0, var22, var1);
                IBlockData iBlockData = var26 = var25 == null ? this.defaultBlock : var25;
                if (var2 != null) {
                    int var27 = var20 * var8 + var21;
                    var2[var27] = var26;
                }
                if (var3 == null || !var3.test(var26)) continue;
                return OptionalInt.of(var22 + 1);
            }
        }
        return OptionalInt.empty();
    }

    @Override
    public void buildSurface(RegionLimitedWorldAccess var0, StructureManager var1, IChunkAccess var2) {
        if (SharedConstants.debugVoidTerrain(var2.getPos())) {
            return;
        }
        WorldGenerationContext var3 = new WorldGenerationContext(this, var0);
        GeneratorSettingBase var4 = this.settings.get();
        NoiseChunk var5 = var2.getOrCreateNoiseChunk(this.sampler, () -> new Beardifier(var1, var2), var4, this.globalFluidPicker, Blender.of(var0));
        this.surfaceSystem.buildSurface(var0.getBiomeManager(), var0.registryAccess().registryOrThrow(IRegistry.BIOME_REGISTRY), var4.useLegacyRandomSource(), var3, var2, var5, var4.surfaceRule());
    }

    @Override
    public void applyCarvers(RegionLimitedWorldAccess var02, long var12, BiomeManager var3, StructureManager var4, IChunkAccess var5, WorldGenStage.Features var6) {
        BiomeManager var7 = var3.withDifferentSource((var0, var1, var2) -> this.biomeSource.getNoiseBiome(var0, var1, var2, this.climateSampler()));
        SeededRandom var8 = new SeededRandom(new LegacyRandomSource(RandomSupport.seedUniquifier()));
        int var9 = 8;
        ChunkCoordIntPair var10 = var5.getPos();
        NoiseChunk var11 = var5.getOrCreateNoiseChunk(this.sampler, () -> new Beardifier(var4, var5), this.settings.get(), this.globalFluidPicker, Blender.of(var02));
        Aquifer var122 = var11.aquifer();
        CarvingContext var13 = new CarvingContext(this, var02.registryAccess(), var5.getHeightAccessorForGeneration(), var11);
        CarvingMask var14 = ((ProtoChunk)var5).getOrCreateCarvingMask(var6);
        for (int var15 = -8; var15 <= 8; ++var15) {
            for (int var16 = -8; var16 <= 8; ++var16) {
                ChunkCoordIntPair var17 = new ChunkCoordIntPair(var10.x + var15, var10.z + var16);
                IChunkAccess var18 = var02.getChunk(var17.x, var17.z);
                BiomeSettingsGeneration var19 = var18.carverBiome(() -> this.biomeSource.getNoiseBiome(QuartPos.fromBlock(var17.getMinBlockX()), 0, QuartPos.fromBlock(var17.getMinBlockZ()), this.climateSampler())).getGenerationSettings();
                List<Supplier<WorldGenCarverWrapper<?>>> var20 = var19.getCarvers(var6);
                ListIterator<Supplier<WorldGenCarverWrapper<?>>> var21 = var20.listIterator();
                while (var21.hasNext()) {
                    int var22 = var21.nextIndex();
                    WorldGenCarverWrapper<?> var23 = var21.next().get();
                    var8.setLargeFeatureSeed(var12 + (long)var22, var17.x, var17.z);
                    if (!var23.isStartChunk(var8)) continue;
                    var23.carve(var13, var5, var7::getBiome, var8, var122, var17, var14);
                }
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> fillFromNoise(Executor var0, Blender var12, StructureManager var22, IChunkAccess var3) {
        NoiseSettings var4 = this.settings.get().noiseSettings();
        LevelHeightAccessor var5 = var3.getHeightAccessorForGeneration();
        int var6 = Math.max(var4.minY(), var5.getMinBuildHeight());
        int var7 = Math.min(var4.minY() + var4.height(), var5.getMaxBuildHeight());
        int var8 = MathHelper.intFloorDiv(var6, var4.getCellHeight());
        int var9 = MathHelper.intFloorDiv(var7 - var6, var4.getCellHeight());
        if (var9 <= 0) {
            return CompletableFuture.completedFuture(var3);
        }
        int var10 = var3.getSectionIndex(var9 * var4.getCellHeight() - 1 + var6);
        int var11 = var3.getSectionIndex(var6);
        HashSet var122 = Sets.newHashSet();
        for (int var13 = var10; var13 >= var11; --var13) {
            ChunkSection var14 = var3.getSection(var13);
            var14.acquire();
            var122.add(var14);
        }
        return CompletableFuture.supplyAsync(SystemUtils.wrapThreadWithTaskName("wgen_fill_noise", () -> this.doFill(var12, var22, var3, var8, var9)), SystemUtils.backgroundExecutor()).whenCompleteAsync((var1, var2) -> {
            for (ChunkSection var4 : var122) {
                var4.release();
            }
        }, var0);
    }

    private IChunkAccess doFill(Blender var0, StructureManager var1, IChunkAccess var2, int var3, int var4) {
        GeneratorSettingBase var5 = this.settings.get();
        NoiseChunk var6 = var2.getOrCreateNoiseChunk(this.sampler, () -> new Beardifier(var1, var2), var5, this.globalFluidPicker, var0);
        HeightMap var7 = var2.getOrCreateHeightmapUnprimed(HeightMap.Type.OCEAN_FLOOR_WG);
        HeightMap var8 = var2.getOrCreateHeightmapUnprimed(HeightMap.Type.WORLD_SURFACE_WG);
        ChunkCoordIntPair var9 = var2.getPos();
        int var10 = var9.getMinBlockX();
        int var11 = var9.getMinBlockZ();
        Aquifer var12 = var6.aquifer();
        var6.initializeForFirstCellX();
        BlockPosition.MutableBlockPosition var13 = new BlockPosition.MutableBlockPosition();
        NoiseSettings var14 = var5.noiseSettings();
        int var15 = var14.getCellWidth();
        int var16 = var14.getCellHeight();
        int var17 = 16 / var15;
        int var18 = 16 / var15;
        for (int var19 = 0; var19 < var17; ++var19) {
            var6.advanceCellX(var19);
            for (int var20 = 0; var20 < var18; ++var20) {
                ChunkSection var21 = var2.getSection(var2.getSectionsCount() - 1);
                for (int var22 = var4 - 1; var22 >= 0; --var22) {
                    var6.selectCellYZ(var22, var20);
                    for (int var23 = var16 - 1; var23 >= 0; --var23) {
                        int var24 = (var3 + var22) * var16 + var23;
                        int var25 = var24 & 0xF;
                        int var26 = var2.getSectionIndex(var24);
                        if (var2.getSectionIndex(var21.bottomBlockY()) != var26) {
                            var21 = var2.getSection(var26);
                        }
                        double var27 = (double)var23 / (double)var16;
                        var6.updateForY(var27);
                        for (int var29 = 0; var29 < var15; ++var29) {
                            int var30 = var10 + var19 * var15 + var29;
                            int var31 = var30 & 0xF;
                            double var32 = (double)var29 / (double)var15;
                            var6.updateForX(var32);
                            for (int var34 = 0; var34 < var15; ++var34) {
                                int var35 = var11 + var20 * var15 + var34;
                                int var36 = var35 & 0xF;
                                double var37 = (double)var34 / (double)var15;
                                var6.updateForZ(var37);
                                IBlockData var39 = this.materialRule.apply(var6, var30, var24, var35);
                                if (var39 == null) {
                                    var39 = this.defaultBlock;
                                }
                                if ((var39 = this.debugPreliminarySurfaceLevel(var6, var30, var24, var35, var39)) == AIR || SharedConstants.debugVoidTerrain(var2.getPos())) continue;
                                if (var39.getLightEmission() != 0 && var2 instanceof ProtoChunk) {
                                    var13.set(var30, var24, var35);
                                    ((ProtoChunk)var2).addLight(var13);
                                }
                                var21.setBlockState(var31, var25, var36, var39, false);
                                var7.update(var31, var24, var36, var39);
                                var8.update(var31, var24, var36, var39);
                                if (!var12.shouldScheduleFluidUpdate() || var39.getFluidState().isEmpty()) continue;
                                var13.set(var30, var24, var35);
                                var2.markPosForPostprocessing(var13);
                            }
                        }
                    }
                }
            }
            var6.swapSlices();
        }
        return var2;
    }

    private IBlockData debugPreliminarySurfaceLevel(NoiseChunk var0, int var1, int var2, int var3, IBlockData var4) {
        return var4;
    }

    @Override
    public int getGenDepth() {
        return this.settings.get().noiseSettings().height();
    }

    @Override
    public int getSeaLevel() {
        return this.settings.get().seaLevel();
    }

    @Override
    public int getMinY() {
        return this.settings.get().noiseSettings().minY();
    }

    @Override
    public WeightedRandomList<BiomeSettingsMobs.c> getMobsAt(BiomeBase var0, StructureManager var1, EnumCreatureType var2, BlockPosition var3) {
        if (!var1.hasAnyStructureAt(var3)) {
            return super.getMobsAt(var0, var1, var2, var3);
        }
        if (var1.getStructureWithPieceAt(var3, StructureGenerator.SWAMP_HUT).isValid()) {
            if (var2 == EnumCreatureType.MONSTER) {
                return WorldGenFeatureSwampHut.SWAMPHUT_ENEMIES;
            }
            if (var2 == EnumCreatureType.CREATURE) {
                return WorldGenFeatureSwampHut.SWAMPHUT_ANIMALS;
            }
        }
        if (var2 == EnumCreatureType.MONSTER) {
            if (var1.getStructureAt(var3, StructureGenerator.PILLAGER_OUTPOST).isValid()) {
                return WorldGenFeaturePillagerOutpost.OUTPOST_ENEMIES;
            }
            if (var1.getStructureAt(var3, StructureGenerator.OCEAN_MONUMENT).isValid()) {
                return WorldGenMonument.MONUMENT_ENEMIES;
            }
            if (var1.getStructureWithPieceAt(var3, StructureGenerator.NETHER_BRIDGE).isValid()) {
                return WorldGenNether.FORTRESS_ENEMIES;
            }
        }
        if ((var2 == EnumCreatureType.UNDERGROUND_WATER_CREATURE || var2 == EnumCreatureType.AXOLOTLS) && var1.getStructureAt(var3, StructureGenerator.OCEAN_MONUMENT).isValid()) {
            return BiomeSettingsMobs.EMPTY_MOB_LIST;
        }
        return super.getMobsAt(var0, var1, var2, var3);
    }

    @Override
    public void spawnOriginalMobs(RegionLimitedWorldAccess var0) {
        if (this.settings.get().disableMobGeneration()) {
            return;
        }
        ChunkCoordIntPair var1 = var0.getCenter();
        BiomeBase var2 = var0.getBiome(var1.getWorldPosition().atY(var0.getMaxBuildHeight() - 1));
        SeededRandom var3 = new SeededRandom(new LegacyRandomSource(RandomSupport.seedUniquifier()));
        var3.setDecorationSeed(var0.getSeed(), var1.getMinBlockX(), var1.getMinBlockZ());
        SpawnerCreature.spawnMobsForChunkGeneration(var0, var2, var1, var3);
    }

    @Deprecated
    public Optional<IBlockData> topMaterial(CarvingContext var0, Function<BlockPosition, BiomeBase> var1, IChunkAccess var2, NoiseChunk var3, BlockPosition var4, boolean var5) {
        return this.surfaceSystem.topMaterial(this.settings.get().surfaceRule(), var0, var1, var2, var3, var4, var5);
    }
}

