/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.BitSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;

public final class BelowZeroRetrogen {
    private static final BitSet EMPTY = new BitSet(0);
    private static final Codec<BitSet> BITSET_CODEC = Codec.LONG_STREAM.xmap(var0 -> BitSet.valueOf(var0.toArray()), var0 -> LongStream.of(var0.toLongArray()));
    private static final Codec<ChunkStatus> NON_EMPTY_CHUNK_STATUS = IRegistry.CHUNK_STATUS.byNameCodec().comapFlatMap(var0 -> var0 == ChunkStatus.EMPTY ? DataResult.error((String)"target_status cannot be empty") : DataResult.success((Object)var0), Function.identity());
    public static final Codec<BelowZeroRetrogen> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)NON_EMPTY_CHUNK_STATUS.fieldOf("target_status").forGetter(BelowZeroRetrogen::targetStatus), (App)BITSET_CODEC.optionalFieldOf("missing_bedrock").forGetter(var0 -> var0.missingBedrock.isEmpty() ? Optional.empty() : Optional.of(var0.missingBedrock))).apply((Applicative)var02, BelowZeroRetrogen::new));
    private static final Set<ResourceKey<BiomeBase>> RETAINED_RETROGEN_BIOMES = Set.of(Biomes.LUSH_CAVES, Biomes.DRIPSTONE_CAVES);
    public static final LevelHeightAccessor UPGRADE_HEIGHT_ACCESSOR = new LevelHeightAccessor(){

        @Override
        public int getHeight() {
            return 64;
        }

        @Override
        public int getMinBuildHeight() {
            return -64;
        }
    };
    private final ChunkStatus targetStatus;
    private final BitSet missingBedrock;

    private BelowZeroRetrogen(ChunkStatus var0, Optional<BitSet> var1) {
        this.targetStatus = var0;
        this.missingBedrock = var1.orElse(EMPTY);
    }

    @Nullable
    public static BelowZeroRetrogen read(NBTTagCompound var0) {
        ChunkStatus var1 = ChunkStatus.byName(var0.getString("target_status"));
        if (var1 == ChunkStatus.EMPTY) {
            return null;
        }
        return new BelowZeroRetrogen(var1, Optional.of(BitSet.valueOf(var0.getLongArray("missing_bedrock"))));
    }

    public static void replaceOldBedrock(ProtoChunk var0) {
        int var12 = 4;
        BlockPosition.betweenClosed(0, 0, 0, 15, 4, 15).forEach(var1 -> {
            if (var0.getBlockState((BlockPosition)var1).is(Blocks.BEDROCK)) {
                var0.setBlockState((BlockPosition)var1, Blocks.DEEPSLATE.defaultBlockState(), false);
            }
        });
    }

    public void applyBedrockMask(ProtoChunk var0) {
        LevelHeightAccessor var12 = var0.getHeightAccessorForGeneration();
        int var2 = var12.getMinBuildHeight();
        int var3 = var12.getMaxBuildHeight() - 1;
        for (int var4 = 0; var4 < 16; ++var4) {
            for (int var5 = 0; var5 < 16; ++var5) {
                if (!this.hasBedrockHole(var4, var5)) continue;
                BlockPosition.betweenClosed(var4, var2, var5, var4, var3, var5).forEach(var1 -> var0.setBlockState((BlockPosition)var1, Blocks.AIR.defaultBlockState(), false));
            }
        }
    }

    public ChunkStatus targetStatus() {
        return this.targetStatus;
    }

    public boolean hasBedrockHoles() {
        return !this.missingBedrock.isEmpty();
    }

    public boolean hasBedrockHole(int var0, int var1) {
        return this.missingBedrock.get((var1 & 0xF) * 16 + (var0 & 0xF));
    }

    public static BiomeResolver getBiomeResolver(BiomeResolver var0, IRegistry<BiomeBase> var1, IChunkAccess var2) {
        if (!var2.isUpgrading()) {
            return var0;
        }
        Set var32 = RETAINED_RETROGEN_BIOMES.stream().map(var1::get).collect(Collectors.toSet());
        return (var3, var4, var5, var6) -> {
            BiomeBase var7 = var0.getNoiseBiome(var3, var4, var5, var6);
            if (var32.contains(var7)) {
                return var7;
            }
            return var2.getNoiseBiome(var3, 0, var5);
        };
    }
}

