/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.SystemUtils;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;

public class Beardifier
implements NoiseChunk.c {
    public static final int BEARD_KERNEL_RADIUS = 12;
    private static final int BEARD_KERNEL_SIZE = 24;
    private static final float[] BEARD_KERNEL = SystemUtils.make(new float[13824], var0 -> {
        for (int var1 = 0; var1 < 24; ++var1) {
            for (int var2 = 0; var2 < 24; ++var2) {
                for (int var3 = 0; var3 < 24; ++var3) {
                    var0[var1 * 24 * 24 + var2 * 24 + var3] = (float)Beardifier.computeBeardContribution(var2 - 12, var3 - 12, var1 - 12);
                }
            }
        }
    });
    private final ObjectList<StructurePiece> rigids;
    private final ObjectList<WorldGenFeatureDefinedStructureJigsawJunction> junctions;
    private final ObjectListIterator<StructurePiece> pieceIterator;
    private final ObjectListIterator<WorldGenFeatureDefinedStructureJigsawJunction> junctionIterator;

    protected Beardifier(StructureManager var0, IChunkAccess var1) {
        ChunkCoordIntPair var2 = var1.getPos();
        int var32 = var2.getMinBlockX();
        int var4 = var2.getMinBlockZ();
        this.junctions = new ObjectArrayList(32);
        this.rigids = new ObjectArrayList(10);
        for (StructureGenerator<?> var6 : StructureGenerator.NOISE_AFFECTING_FEATURES) {
            var0.startsForFeature(SectionPosition.bottomOf(var1), var6).forEach(var3 -> {
                for (StructurePiece var5 : var3.getPieces()) {
                    if (!var5.isCloseToChunk(var2, 12)) continue;
                    if (var5 instanceof WorldGenFeaturePillagerOutpostPoolPiece) {
                        WorldGenFeaturePillagerOutpostPoolPiece var6 = (WorldGenFeaturePillagerOutpostPoolPiece)var5;
                        WorldGenFeatureDefinedStructurePoolTemplate.Matching var7 = var6.getElement().getProjection();
                        if (var7 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID) {
                            this.rigids.add((Object)var6);
                        }
                        for (WorldGenFeatureDefinedStructureJigsawJunction var9 : var6.getJunctions()) {
                            int var10 = var9.getSourceX();
                            int var11 = var9.getSourceZ();
                            if (var10 <= var32 - 12 || var11 <= var4 - 12 || var10 >= var32 + 15 + 12 || var11 >= var4 + 15 + 12) continue;
                            this.junctions.add((Object)var9);
                        }
                        continue;
                    }
                    this.rigids.add((Object)var5);
                }
            });
        }
        this.pieceIterator = this.rigids.iterator();
        this.junctionIterator = this.junctions.iterator();
    }

    @Override
    public double calculateNoise(int var0, int var1, int var2) {
        int var8;
        int var7;
        Object var5;
        double var3 = 0.0;
        while (this.pieceIterator.hasNext()) {
            var5 = (StructurePiece)this.pieceIterator.next();
            StructureBoundingBox var6 = ((StructurePiece)var5).getBoundingBox();
            var7 = Math.max(0, Math.max(var6.minX() - var0, var0 - var6.maxX()));
            var8 = var1 - (var6.minY() + (var5 instanceof WorldGenFeaturePillagerOutpostPoolPiece ? ((WorldGenFeaturePillagerOutpostPoolPiece)var5).getGroundLevelDelta() : 0));
            int var9 = Math.max(0, Math.max(var6.minZ() - var2, var2 - var6.maxZ()));
            NoiseEffect var10 = ((StructurePiece)var5).getNoiseEffect();
            if (var10 == NoiseEffect.BURY) {
                var3 += Beardifier.getBuryContribution(var7, var8, var9);
                continue;
            }
            if (var10 != NoiseEffect.BEARD) continue;
            var3 += Beardifier.getBeardContribution(var7, var8, var9) * 0.8;
        }
        this.pieceIterator.back(this.rigids.size());
        while (this.junctionIterator.hasNext()) {
            var5 = (WorldGenFeatureDefinedStructureJigsawJunction)this.junctionIterator.next();
            int var6 = var0 - ((WorldGenFeatureDefinedStructureJigsawJunction)var5).getSourceX();
            var7 = var1 - ((WorldGenFeatureDefinedStructureJigsawJunction)var5).getSourceGroundY();
            var8 = var2 - ((WorldGenFeatureDefinedStructureJigsawJunction)var5).getSourceZ();
            var3 += Beardifier.getBeardContribution(var6, var7, var8) * 0.4;
        }
        this.junctionIterator.back(this.junctions.size());
        return var3;
    }

    private static double getBuryContribution(int var0, int var1, int var2) {
        double var3 = MathHelper.length(var0, (double)var1 / 2.0, var2);
        return MathHelper.clampedMap(var3, 0.0, 6.0, 1.0, 0.0);
    }

    private static double getBeardContribution(int var0, int var1, int var2) {
        int var3 = var0 + 12;
        int var4 = var1 + 12;
        int var5 = var2 + 12;
        if (var3 < 0 || var3 >= 24) {
            return 0.0;
        }
        if (var4 < 0 || var4 >= 24) {
            return 0.0;
        }
        if (var5 < 0 || var5 >= 24) {
            return 0.0;
        }
        return BEARD_KERNEL[var5 * 24 * 24 + var3 * 24 + var4];
    }

    private static double computeBeardContribution(int var0, int var1, int var2) {
        double var3 = var0 * var0 + var2 * var2;
        double var5 = (double)var1 + 0.5;
        double var7 = var5 * var5;
        double var9 = Math.pow(Math.E, -(var7 / 16.0 + var3 / 16.0));
        double var11 = -var5 * MathHelper.fastInvSqrt(var7 / 2.0 + var3 / 2.0) / 2.0;
        return var11 * var9;
    }
}

