/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;

public class VibrationPath {
    public static final Codec<VibrationPath> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BlockPosition.CODEC.fieldOf("origin").forGetter(var0 -> var0.origin), (App)PositionSource.CODEC.fieldOf("destination").forGetter(var0 -> var0.destination), (App)Codec.INT.fieldOf("arrival_in_ticks").forGetter(var0 -> var0.arrivalInTicks)).apply((Applicative)var02, VibrationPath::new));
    private final BlockPosition origin;
    private final PositionSource destination;
    private final int arrivalInTicks;

    public VibrationPath(BlockPosition var0, PositionSource var1, int var2) {
        this.origin = var0;
        this.destination = var1;
        this.arrivalInTicks = var2;
    }

    public int getArrivalInTicks() {
        return this.arrivalInTicks;
    }

    public BlockPosition getOrigin() {
        return this.origin;
    }

    public PositionSource getDestination() {
        return this.destination;
    }

    public static VibrationPath read(PacketDataSerializer var0) {
        BlockPosition var1 = var0.readBlockPos();
        PositionSource var2 = PositionSourceType.fromNetwork(var0);
        int var3 = var0.readVarInt();
        return new VibrationPath(var1, var2, var3);
    }

    public static void write(PacketDataSerializer var0, VibrationPath var1) {
        var0.writeBlockPos(var1.origin);
        PositionSourceType.toNetwork(var1.destination, var0);
        var0.writeVarInt(var1.arrivalInTicks);
    }
}

