/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.gameevent.GameEventListener;

public class EuclideanGameEventDispatcher
implements GameEventDispatcher {
    private final List<GameEventListener> listeners = Lists.newArrayList();
    private final World level;

    public EuclideanGameEventDispatcher(World var0) {
        this.level = var0;
    }

    @Override
    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    @Override
    public void register(GameEventListener var0) {
        this.listeners.add(var0);
        PacketDebug.sendGameEventListenerInfo(this.level, var0);
    }

    @Override
    public void unregister(GameEventListener var0) {
        this.listeners.remove(var0);
    }

    @Override
    public void post(GameEvent var0, @Nullable Entity var1, BlockPosition var2) {
        boolean var3 = false;
        for (GameEventListener var5 : this.listeners) {
            if (!this.postToListener(this.level, var0, var1, var2, var5)) continue;
            var3 = true;
        }
        if (var3) {
            PacketDebug.sendGameEventInfo(this.level, var0, var2);
        }
    }

    private boolean postToListener(World var0, GameEvent var1, @Nullable Entity var2, BlockPosition var3, GameEventListener var4) {
        int var8;
        Optional<BlockPosition> var5 = var4.getListenerSource().getPosition(var0);
        if (!var5.isPresent()) {
            return false;
        }
        double var6 = var5.get().distSqr(var3, false);
        return var6 <= (double)(var8 = var4.getListenerRadius() * var4.getListenerRadius()) && var4.handleGameEvent(var0, var1, var2, var3);
    }
}

