/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEndSpikeConfiguration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class EnumDragonRespawn
extends Enum<EnumDragonRespawn> {
    public static final /* enum */ EnumDragonRespawn START = new EnumDragonRespawn(){

        @Override
        public void tick(WorldServer var0, EnderDragonBattle var1, List<EntityEnderCrystal> var2, int var3, BlockPosition var4) {
            BlockPosition var5 = new BlockPosition(0, 128, 0);
            for (EntityEnderCrystal var7 : var2) {
                var7.setBeamTarget(var5);
            }
            var1.setRespawnStage(PREPARING_TO_SUMMON_PILLARS);
        }
    };
    public static final /* enum */ EnumDragonRespawn PREPARING_TO_SUMMON_PILLARS = new EnumDragonRespawn(){

        @Override
        public void tick(WorldServer var0, EnderDragonBattle var1, List<EntityEnderCrystal> var2, int var3, BlockPosition var4) {
            if (var3 < 100) {
                if (var3 == 0 || var3 == 50 || var3 == 51 || var3 == 52 || var3 >= 95) {
                    var0.levelEvent(3001, new BlockPosition(0, 128, 0), 0);
                }
            } else {
                var1.setRespawnStage(SUMMONING_PILLARS);
            }
        }
    };
    public static final /* enum */ EnumDragonRespawn SUMMONING_PILLARS = new EnumDragonRespawn(){

        @Override
        public void tick(WorldServer var0, EnderDragonBattle var1, List<EntityEnderCrystal> var2, int var3, BlockPosition var4) {
            boolean var7;
            int var5 = 40;
            boolean var6 = var3 % 40 == 0;
            boolean bl = var7 = var3 % 40 == 39;
            if (var6 || var7) {
                int var9 = var3 / 40;
                List<WorldGenEnder.Spike> var8 = WorldGenEnder.getSpikesForLevel(var0);
                if (var9 < var8.size()) {
                    WorldGenEnder.Spike var10 = var8.get(var9);
                    if (var6) {
                        for (EntityEnderCrystal var12 : var2) {
                            var12.setBeamTarget(new BlockPosition(var10.getCenterX(), var10.getHeight() + 1, var10.getCenterZ()));
                        }
                    } else {
                        int var11 = 10;
                        for (BlockPosition var13 : BlockPosition.betweenClosed(new BlockPosition(var10.getCenterX() - 10, var10.getHeight() - 10, var10.getCenterZ() - 10), new BlockPosition(var10.getCenterX() + 10, var10.getHeight() + 10, var10.getCenterZ() + 10))) {
                            var0.removeBlock(var13, false);
                        }
                        var0.explode(null, (float)var10.getCenterX() + 0.5f, var10.getHeight(), (float)var10.getCenterZ() + 0.5f, 5.0f, Explosion.Effect.DESTROY);
                        WorldGenFeatureEndSpikeConfiguration var12 = new WorldGenFeatureEndSpikeConfiguration(true, (List<WorldGenEnder.Spike>)ImmutableList.of((Object)var10), new BlockPosition(0, 128, 0));
                        WorldGenerator.END_SPIKE.configured(var12).place(var0, var0.getChunkSource().getGenerator(), new Random(), new BlockPosition(var10.getCenterX(), 45, var10.getCenterZ()));
                    }
                } else if (var6) {
                    var1.setRespawnStage(SUMMONING_DRAGON);
                }
            }
        }
    };
    public static final /* enum */ EnumDragonRespawn SUMMONING_DRAGON = new EnumDragonRespawn(){

        @Override
        public void tick(WorldServer var0, EnderDragonBattle var1, List<EntityEnderCrystal> var2, int var3, BlockPosition var4) {
            if (var3 >= 100) {
                var1.setRespawnStage(END);
                var1.resetSpikeCrystals();
                for (EntityEnderCrystal var6 : var2) {
                    var6.setBeamTarget(null);
                    var0.explode(var6, var6.getX(), var6.getY(), var6.getZ(), 6.0f, Explosion.Effect.NONE);
                    var6.discard();
                }
            } else if (var3 >= 80) {
                var0.levelEvent(3001, new BlockPosition(0, 128, 0), 0);
            } else if (var3 == 0) {
                for (EntityEnderCrystal var6 : var2) {
                    var6.setBeamTarget(new BlockPosition(0, 128, 0));
                }
            } else if (var3 < 5) {
                var0.levelEvent(3001, new BlockPosition(0, 128, 0), 0);
            }
        }
    };
    public static final /* enum */ EnumDragonRespawn END = new EnumDragonRespawn(){

        @Override
        public void tick(WorldServer var0, EnderDragonBattle var1, List<EntityEnderCrystal> var2, int var3, BlockPosition var4) {
        }
    };
    private static final /* synthetic */ EnumDragonRespawn[] f;

    public static EnumDragonRespawn[] values() {
        return (EnumDragonRespawn[])f.clone();
    }

    public static EnumDragonRespawn valueOf(String var0) {
        return Enum.valueOf(EnumDragonRespawn.class, var0);
    }

    public abstract void tick(WorldServer var1, EnderDragonBattle var2, List<EntityEnderCrystal> var3, int var4, BlockPosition var5);

    private static /* synthetic */ EnumDragonRespawn[] a() {
        return new EnumDragonRespawn[]{START, PREPARING_TO_SUMMON_PILLARS, SUMMONING_PILLARS, SUMMONING_DRAGON, END};
    }

    static {
        f = EnumDragonRespawn.a();
    }
}

