/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class DimensionManager {
    public static final int BITS_FOR_Y = BlockPosition.PACKED_Y_LENGTH;
    public static final int MIN_HEIGHT = 16;
    public static final int Y_SIZE = (1 << BITS_FOR_Y) - 32;
    public static final int MAX_Y = (Y_SIZE >> 1) - 1;
    public static final int MIN_Y = MAX_Y - Y_SIZE + 1;
    public static final int WAY_ABOVE_MAX_Y = MAX_Y << 4;
    public static final int WAY_BELOW_MIN_Y = MIN_Y << 4;
    public static final MinecraftKey OVERWORLD_EFFECTS = new MinecraftKey("overworld");
    public static final MinecraftKey NETHER_EFFECTS = new MinecraftKey("the_nether");
    public static final MinecraftKey END_EFFECTS = new MinecraftKey("the_end");
    public static final Codec<DimensionManager> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.LONG.optionalFieldOf("fixed_time").xmap(var0 -> var0.map(OptionalLong::of).orElseGet(OptionalLong::empty), var0 -> var0.isPresent() ? Optional.of(var0.getAsLong()) : Optional.empty()).forGetter(var0 -> var0.fixedTime), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionManager::hasSkyLight), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionManager::hasCeiling), (App)Codec.BOOL.fieldOf("ultrawarm").forGetter(DimensionManager::ultraWarm), (App)Codec.BOOL.fieldOf("natural").forGetter(DimensionManager::natural), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionManager::coordinateScale), (App)Codec.BOOL.fieldOf("piglin_safe").forGetter(DimensionManager::piglinSafe), (App)Codec.BOOL.fieldOf("bed_works").forGetter(DimensionManager::bedWorks), (App)Codec.BOOL.fieldOf("respawn_anchor_works").forGetter(DimensionManager::respawnAnchorWorks), (App)Codec.BOOL.fieldOf("has_raids").forGetter(DimensionManager::hasRaids), (App)Codec.intRange((int)MIN_Y, (int)MAX_Y).fieldOf("min_y").forGetter(DimensionManager::minY), (App)Codec.intRange((int)16, (int)Y_SIZE).fieldOf("height").forGetter(DimensionManager::height), (App)Codec.intRange((int)0, (int)Y_SIZE).fieldOf("logical_height").forGetter(DimensionManager::logicalHeight), (App)MinecraftKey.CODEC.fieldOf("infiniburn").forGetter(var0 -> var0.infiniburn), (App)MinecraftKey.CODEC.fieldOf("effects").orElse((Object)OVERWORLD_EFFECTS).forGetter(var0 -> var0.effectsLocation), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(var0 -> Float.valueOf(var0.ambientLight))).apply((Applicative)var02, DimensionManager::new)).comapFlatMap(DimensionManager::guardY, Function.identity());
    private static final int MOON_PHASES = 8;
    public static final float[] MOON_BRIGHTNESS_PER_PHASE = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final ResourceKey<DimensionManager> OVERWORLD_LOCATION = ResourceKey.create(IRegistry.DIMENSION_TYPE_REGISTRY, new MinecraftKey("overworld"));
    public static final ResourceKey<DimensionManager> NETHER_LOCATION = ResourceKey.create(IRegistry.DIMENSION_TYPE_REGISTRY, new MinecraftKey("the_nether"));
    public static final ResourceKey<DimensionManager> END_LOCATION = ResourceKey.create(IRegistry.DIMENSION_TYPE_REGISTRY, new MinecraftKey("the_end"));
    protected static final DimensionManager DEFAULT_OVERWORLD = DimensionManager.create(OptionalLong.empty(), true, false, false, true, 1.0, false, false, true, false, true, -64, 384, 384, TagsBlock.INFINIBURN_OVERWORLD.getName(), OVERWORLD_EFFECTS, 0.0f);
    protected static final DimensionManager DEFAULT_NETHER = DimensionManager.create(OptionalLong.of(18000L), false, true, true, false, 8.0, false, true, false, true, false, 0, 256, 128, TagsBlock.INFINIBURN_NETHER.getName(), NETHER_EFFECTS, 0.1f);
    protected static final DimensionManager DEFAULT_END = DimensionManager.create(OptionalLong.of(6000L), false, false, false, false, 1.0, true, false, false, false, true, 0, 256, 256, TagsBlock.INFINIBURN_END.getName(), END_EFFECTS, 0.0f);
    public static final ResourceKey<DimensionManager> OVERWORLD_CAVES_LOCATION = ResourceKey.create(IRegistry.DIMENSION_TYPE_REGISTRY, new MinecraftKey("overworld_caves"));
    protected static final DimensionManager DEFAULT_OVERWORLD_CAVES = DimensionManager.create(OptionalLong.empty(), true, true, false, true, 1.0, false, false, true, false, true, -64, 384, 384, TagsBlock.INFINIBURN_OVERWORLD.getName(), OVERWORLD_EFFECTS, 0.0f);
    public static final Codec<Supplier<DimensionManager>> CODEC = RegistryFileCodec.create(IRegistry.DIMENSION_TYPE_REGISTRY, DIRECT_CODEC);
    private final OptionalLong fixedTime;
    private final boolean hasSkylight;
    private final boolean hasCeiling;
    private final boolean ultraWarm;
    private final boolean natural;
    private final double coordinateScale;
    private final boolean createDragonFight;
    private final boolean piglinSafe;
    private final boolean bedWorks;
    private final boolean respawnAnchorWorks;
    private final boolean hasRaids;
    private final int minY;
    private final int height;
    private final int logicalHeight;
    private final MinecraftKey infiniburn;
    private final MinecraftKey effectsLocation;
    private final float ambientLight;
    private final transient float[] brightnessRamp;

    private static DataResult<DimensionManager> guardY(DimensionManager var0) {
        if (var0.height() < 16) {
            return DataResult.error((String)"height has to be at least 16");
        }
        if (var0.minY() + var0.height() > MAX_Y + 1) {
            return DataResult.error((String)("min_y + height cannot be higher than: " + (MAX_Y + 1)));
        }
        if (var0.logicalHeight() > var0.height()) {
            return DataResult.error((String)"logical_height cannot be higher than height");
        }
        if (var0.height() % 16 != 0) {
            return DataResult.error((String)"height has to be multiple of 16");
        }
        if (var0.minY() % 16 != 0) {
            return DataResult.error((String)"min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)var0);
    }

    private DimensionManager(OptionalLong var0, boolean var1, boolean var2, boolean var3, boolean var4, double var5, boolean var7, boolean var8, boolean var9, boolean var10, int var11, int var12, int var13, MinecraftKey var14, MinecraftKey var15, float var16) {
        this(var0, var1, var2, var3, var4, var5, false, var7, var8, var9, var10, var11, var12, var13, var14, var15, var16);
    }

    public static DimensionManager create(OptionalLong var02, boolean var1, boolean var2, boolean var3, boolean var4, double var5, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, int var12, int var13, int var14, MinecraftKey var15, MinecraftKey var16, float var17) {
        DimensionManager var18 = new DimensionManager(var02, var1, var2, var3, var4, var5, var7, var8, var9, var10, var11, var12, var13, var14, var15, var16, var17);
        DimensionManager.guardY(var18).error().ifPresent(var0 -> {
            throw new IllegalStateException(var0.message());
        });
        return var18;
    }

    @Deprecated
    private DimensionManager(OptionalLong var0, boolean var1, boolean var2, boolean var3, boolean var4, double var5, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, int var12, int var13, int var14, MinecraftKey var15, MinecraftKey var16, float var17) {
        this.fixedTime = var0;
        this.hasSkylight = var1;
        this.hasCeiling = var2;
        this.ultraWarm = var3;
        this.natural = var4;
        this.coordinateScale = var5;
        this.createDragonFight = var7;
        this.piglinSafe = var8;
        this.bedWorks = var9;
        this.respawnAnchorWorks = var10;
        this.hasRaids = var11;
        this.minY = var12;
        this.height = var13;
        this.logicalHeight = var14;
        this.infiniburn = var15;
        this.effectsLocation = var16;
        this.ambientLight = var17;
        this.brightnessRamp = DimensionManager.fillBrightnessRamp(var17);
    }

    private static float[] fillBrightnessRamp(float var0) {
        float[] var1 = new float[16];
        for (int var2 = 0; var2 <= 15; ++var2) {
            float var3 = (float)var2 / 15.0f;
            float var4 = var3 / (4.0f - 3.0f * var3);
            var1[var2] = MathHelper.lerp(var0, var4, 1.0f);
        }
        return var1;
    }

    @Deprecated
    public static DataResult<ResourceKey<World>> parseLegacy(Dynamic<?> var0) {
        Optional var1 = var0.asNumber().result();
        if (var1.isPresent()) {
            int var2 = ((Number)var1.get()).intValue();
            if (var2 == -1) {
                return DataResult.success(World.NETHER);
            }
            if (var2 == 0) {
                return DataResult.success(World.OVERWORLD);
            }
            if (var2 == 1) {
                return DataResult.success(World.END);
            }
        }
        return World.RESOURCE_KEY_CODEC.parse(var0);
    }

    public static IRegistryCustom registerBuiltin(IRegistryCustom var0) {
        IRegistryWritable<DimensionManager> var1 = var0.ownedRegistryOrThrow(IRegistry.DIMENSION_TYPE_REGISTRY);
        var1.register(OVERWORLD_LOCATION, DEFAULT_OVERWORLD, Lifecycle.stable());
        var1.register(OVERWORLD_CAVES_LOCATION, DEFAULT_OVERWORLD_CAVES, Lifecycle.stable());
        var1.register(NETHER_LOCATION, DEFAULT_NETHER, Lifecycle.stable());
        var1.register(END_LOCATION, DEFAULT_END, Lifecycle.stable());
        return var0;
    }

    public static RegistryMaterials<WorldDimension> defaultDimensions(IRegistryCustom var0, long var1) {
        return DimensionManager.defaultDimensions(var0, var1, true);
    }

    public static RegistryMaterials<WorldDimension> defaultDimensions(IRegistryCustom var0, long var1, boolean var3) {
        RegistryMaterials<WorldDimension> var4 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental());
        IRegistry<DimensionManager> var5 = var0.registryOrThrow(IRegistry.DIMENSION_TYPE_REGISTRY);
        IRegistry<BiomeBase> var6 = var0.registryOrThrow(IRegistry.BIOME_REGISTRY);
        IRegistry<GeneratorSettingBase> var7 = var0.registryOrThrow(IRegistry.NOISE_GENERATOR_SETTINGS_REGISTRY);
        IRegistry<NoiseGeneratorNormal.a> var8 = var0.registryOrThrow(IRegistry.NOISE_REGISTRY);
        var4.register(WorldDimension.NETHER, new WorldDimension(() -> var5.getOrThrow(NETHER_LOCATION), new ChunkGeneratorAbstract(var8, (WorldChunkManager)WorldChunkManagerMultiNoise.a.NETHER.biomeSource(var6, var3), var1, () -> var7.getOrThrow(GeneratorSettingBase.NETHER))), Lifecycle.stable());
        var4.register(WorldDimension.END, new WorldDimension(() -> var5.getOrThrow(END_LOCATION), new ChunkGeneratorAbstract(var8, (WorldChunkManager)new WorldChunkManagerTheEnd(var6, var1), var1, () -> var7.getOrThrow(GeneratorSettingBase.END))), Lifecycle.stable());
        return var4;
    }

    public static double getTeleportationScale(DimensionManager var0, DimensionManager var1) {
        double var2 = var0.coordinateScale();
        double var4 = var1.coordinateScale();
        return var2 / var4;
    }

    @Deprecated
    public String getFileSuffix() {
        if (this.equalTo(DEFAULT_END)) {
            return "_end";
        }
        return "";
    }

    public static Path getStorageFolder(ResourceKey<World> var0, Path var1) {
        if (var0 == World.OVERWORLD) {
            return var1;
        }
        if (var0 == World.END) {
            return var1.resolve("DIM1");
        }
        if (var0 == World.NETHER) {
            return var1.resolve("DIM-1");
        }
        return var1.resolve("dimensions").resolve(var0.location().getNamespace()).resolve(var0.location().getPath());
    }

    public boolean hasSkyLight() {
        return this.hasSkylight;
    }

    public boolean hasCeiling() {
        return this.hasCeiling;
    }

    public boolean ultraWarm() {
        return this.ultraWarm;
    }

    public boolean natural() {
        return this.natural;
    }

    public double coordinateScale() {
        return this.coordinateScale;
    }

    public boolean piglinSafe() {
        return this.piglinSafe;
    }

    public boolean bedWorks() {
        return this.bedWorks;
    }

    public boolean respawnAnchorWorks() {
        return this.respawnAnchorWorks;
    }

    public boolean hasRaids() {
        return this.hasRaids;
    }

    public int minY() {
        return this.minY;
    }

    public int height() {
        return this.height;
    }

    public int logicalHeight() {
        return this.logicalHeight;
    }

    public boolean createDragonFight() {
        return this.createDragonFight;
    }

    public boolean hasFixedTime() {
        return this.fixedTime.isPresent();
    }

    public float timeOfDay(long var0) {
        double var2 = MathHelper.frac((double)this.fixedTime.orElse(var0) / 24000.0 - 0.25);
        double var4 = 0.5 - Math.cos(var2 * Math.PI) / 2.0;
        return (float)(var2 * 2.0 + var4) / 3.0f;
    }

    public int moonPhase(long var0) {
        return (int)(var0 / 24000L % 8L + 8L) % 8;
    }

    public float brightness(int var0) {
        return this.brightnessRamp[var0];
    }

    public Tag<Block> infiniburn() {
        Tag<Block> var0 = TagsBlock.getAllTags().getTag(this.infiniburn);
        return var0 != null ? var0 : TagsBlock.INFINIBURN_OVERWORLD;
    }

    public MinecraftKey effectsLocation() {
        return this.effectsLocation;
    }

    public boolean equalTo(DimensionManager var0) {
        if (this == var0) {
            return true;
        }
        return this.hasSkylight == var0.hasSkylight && this.hasCeiling == var0.hasCeiling && this.ultraWarm == var0.ultraWarm && this.natural == var0.natural && this.coordinateScale == var0.coordinateScale && this.createDragonFight == var0.createDragonFight && this.piglinSafe == var0.piglinSafe && this.bedWorks == var0.bedWorks && this.respawnAnchorWorks == var0.respawnAnchorWorks && this.hasRaids == var0.hasRaids && this.minY == var0.minY && this.height == var0.height && this.logicalHeight == var0.logicalHeight && Float.compare(var0.ambientLight, this.ambientLight) == 0 && this.fixedTime.equals(var0.fixedTime) && this.infiniburn.equals(var0.infiniburn) && this.effectsLocation.equals(var0.effectsLocation);
    }
}

