/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsStronghold;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;

public abstract class ChunkGenerator
implements BiomeManager.Provider {
    public static final Codec<ChunkGenerator> CODEC;
    protected final WorldChunkManager biomeSource;
    protected final WorldChunkManager runtimeBiomeSource;
    private final StructureSettings settings;
    public final long strongholdSeed;
    private final List<ChunkCoordIntPair> strongholdPositions = Lists.newArrayList();

    public ChunkGenerator(WorldChunkManager var0, StructureSettings var1) {
        this(var0, var0, var1, 0L);
    }

    public ChunkGenerator(WorldChunkManager var0, WorldChunkManager var1, StructureSettings var2, long var3) {
        this.biomeSource = var0;
        this.runtimeBiomeSource = var1;
        this.settings = var2;
        this.strongholdSeed = var3;
    }

    private void generateStrongholds() {
        if (!this.strongholdPositions.isEmpty()) {
            return;
        }
        StructureSettingsStronghold var0 = this.settings.stronghold();
        if (var0 == null || var0.count() == 0) {
            return;
        }
        ArrayList var1 = Lists.newArrayList();
        for (BiomeBase var3 : this.biomeSource.possibleBiomes()) {
            if (!ChunkGenerator.validStrongholdBiome(var3)) continue;
            var1.add(var3);
        }
        int var2 = var0.distance();
        int var3 = var0.count();
        int var4 = var0.spread();
        Random var5 = new Random();
        var5.setSeed(this.strongholdSeed);
        double var6 = var5.nextDouble() * Math.PI * 2.0;
        int var8 = 0;
        int var9 = 0;
        for (int var10 = 0; var10 < var3; ++var10) {
            double var11 = (double)(4 * var2 + var2 * var9 * 6) + (var5.nextDouble() - 0.5) * ((double)var2 * 2.5);
            int var13 = (int)Math.round(Math.cos(var6) * var11);
            int var14 = (int)Math.round(Math.sin(var6) * var11);
            BlockPosition var15 = this.biomeSource.findBiomeHorizontal(SectionPosition.sectionToBlockCoord(var13, 8), 0, SectionPosition.sectionToBlockCoord(var14, 8), 112, var1::contains, var5, this.climateSampler());
            if (var15 != null) {
                var13 = SectionPosition.blockToSectionCoord(var15.getX());
                var14 = SectionPosition.blockToSectionCoord(var15.getZ());
            }
            this.strongholdPositions.add(new ChunkCoordIntPair(var13, var14));
            var6 += Math.PI * 2 / (double)var4;
            if (++var8 != var4) continue;
            var8 = 0;
            var4 += 2 * var4 / (++var9 + 1);
            var4 = Math.min(var4, var3 - var10);
            var6 += var5.nextDouble() * Math.PI * 2.0;
        }
    }

    private static boolean validStrongholdBiome(BiomeBase var0) {
        BiomeBase.Geography var1 = var0.getBiomeCategory();
        return var1 != BiomeBase.Geography.OCEAN && var1 != BiomeBase.Geography.RIVER && var1 != BiomeBase.Geography.BEACH && var1 != BiomeBase.Geography.SWAMP && var1 != BiomeBase.Geography.NETHER && var1 != BiomeBase.Geography.THEEND;
    }

    protected abstract Codec<? extends ChunkGenerator> codec();

    public Optional<ResourceKey<Codec<? extends ChunkGenerator>>> getTypeNameForDataFixer() {
        return IRegistry.CHUNK_GENERATOR.getResourceKey(this.codec());
    }

    public abstract ChunkGenerator withSeed(long var1);

    public CompletableFuture<IChunkAccess> createBiomes(IRegistry<BiomeBase> var0, Executor var1, Blender var2, StructureManager var3, IChunkAccess var4) {
        return CompletableFuture.supplyAsync(SystemUtils.wrapThreadWithTaskName("init_biomes", () -> {
            var4.fillBiomesFromNoise(this.runtimeBiomeSource::getNoiseBiome, this.climateSampler());
            return var4;
        }), SystemUtils.backgroundExecutor());
    }

    public abstract Climate.Sampler climateSampler();

    @Override
    public BiomeBase getNoiseBiome(int var0, int var1, int var2) {
        return this.getBiomeSource().getNoiseBiome(var0, var1, var2, this.climateSampler());
    }

    public abstract void applyCarvers(RegionLimitedWorldAccess var1, long var2, BiomeManager var4, StructureManager var5, IChunkAccess var6, WorldGenStage.Features var7);

    @Nullable
    public BlockPosition findNearestMapFeature(WorldServer var0, StructureGenerator<?> var12, BlockPosition var2, int var3, boolean var4) {
        if (var12 == StructureGenerator.STRONGHOLD) {
            this.generateStrongholds();
            BlockPosition var5 = null;
            double var6 = Double.MAX_VALUE;
            BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
            for (ChunkCoordIntPair var10 : this.strongholdPositions) {
                var8.set(SectionPosition.sectionToBlockCoord(var10.x, 8), 32, SectionPosition.sectionToBlockCoord(var10.z, 8));
                double var11 = var8.distSqr(var2);
                if (var5 == null) {
                    var5 = new BlockPosition(var8);
                    var6 = var11;
                    continue;
                }
                if (!(var11 < var6)) continue;
                var5 = new BlockPosition(var8);
                var6 = var11;
            }
            return var5;
        }
        StructureSettingsFeature var5 = this.settings.getConfig(var12);
        ImmutableMultimap<StructureFeature<?, ?>, ResourceKey<BiomeBase>> var6 = this.settings.structures(var12);
        if (var5 == null || var6.isEmpty()) {
            return null;
        }
        IRegistry<BiomeBase> var7 = var0.registryAccess().registryOrThrow(IRegistry.BIOME_REGISTRY);
        Set var8 = this.runtimeBiomeSource.possibleBiomes().stream().flatMap(var1 -> var7.getResourceKey((BiomeBase)var1).stream()).collect(Collectors.toSet());
        if (var6.values().stream().noneMatch(var8::contains)) {
            return null;
        }
        return var12.getNearestGeneratedFeature(var0, var0.structureFeatureManager(), var2, var3, var4, var0.getSeed(), var5);
    }

    public void applyBiomeDecoration(GeneratorAccessSeed var02, IChunkAccess var1, StructureManager var2) {
        ChunkCoordIntPair var3 = var1.getPos();
        if (SharedConstants.debugVoidTerrain(var3)) {
            return;
        }
        SectionPosition var4 = SectionPosition.of(var3, var02.getMinSection());
        BlockPosition var52 = var4.origin();
        Map<Integer, List<StructureGenerator>> var6 = IRegistry.STRUCTURE_FEATURE.stream().collect(Collectors.groupingBy(var0 -> var0.step().ordinal()));
        List<WorldChunkManager.b> var7 = this.biomeSource.featuresPerStep();
        SeededRandom var8 = new SeededRandom(new XoroshiroRandomSource(RandomSupport.seedUniquifier()));
        long var9 = var8.setDecorationSeed(var02.getSeed(), var52.getX(), var52.getZ());
        ObjectArraySet var11 = new ObjectArraySet();
        if (this instanceof ChunkProviderFlat) {
            var11.addAll(this.biomeSource.possibleBiomes());
        } else {
            ChunkCoordIntPair.rangeClosed(var4.chunk(), 1).forEach(arg_0 -> ChunkGenerator.a(var02, (Set)var11, arg_0));
            var11.retainAll(this.biomeSource.possibleBiomes());
        }
        int var12 = var7.size();
        try {
            IRegistry<PlacedFeature> var13 = var02.registryAccess().registryOrThrow(IRegistry.PLACED_FEATURE_REGISTRY);
            IRegistry<StructureGenerator<?>> var14 = var02.registryAccess().registryOrThrow(IRegistry.STRUCTURE_FEATURE_REGISTRY);
            int var15 = Math.max(WorldGenStage.Decoration.values().length, var12);
            for (int var16 = 0; var16 < var15; ++var16) {
                List<List<Supplier<PlacedFeature>>> var21;
                Object var202;
                IntArraySet var18;
                int var17 = 0;
                if (var2.shouldGenerateFeatures()) {
                    var18 = var6.getOrDefault(var16, Collections.emptyList());
                    for (Object var202 : var18) {
                        var8.setFeatureSeed(var9, var17, var16);
                        var21 = () -> ChunkGenerator.a(var14, (StructureGenerator)var202);
                        try {
                            var02.setCurrentlyGenerating((Supplier<String>)((Object)var21));
                            var2.startsForFeature(var4, (StructureGenerator<?>)var202).forEach(var5 -> var5.placeInChunk(var02, var2, this, var8, ChunkGenerator.getWritableArea(var1), var3));
                        }
                        catch (Exception var22) {
                            CrashReport var23 = CrashReport.forThrowable(var22, "Feature placement");
                            var23.addCategory("Feature").setDetail("Description", ((Supplier)((Object)var21))::get);
                            throw new ReportedException(var23);
                        }
                        ++var17;
                    }
                }
                if (var16 >= var12) continue;
                var18 = new IntArraySet();
                for (Object var202 : var11) {
                    var21 = ((BiomeBase)var202).getGenerationSettings().features();
                    if (var16 >= var21.size()) continue;
                    List var22 = (List)var21.get(var16);
                    WorldChunkManager.b var23 = var7.get(var16);
                    var22.stream().map(Supplier::get).forEach(arg_0 -> ChunkGenerator.a((IntSet)var18, var23, arg_0));
                }
                int var19 = var18.size();
                var202 = var18.toIntArray();
                Arrays.sort((int[])var202);
                var21 = var7.get(var16);
                for (int var22 = 0; var22 < var19; ++var22) {
                    Object var23 = var202[var22];
                    PlacedFeature var24 = ((WorldChunkManager.b)((Object)var21)).features().get((int)var23);
                    Supplier<String> var25 = () -> var13.getResourceKey(var24).map(Object::toString).orElseGet(var24::toString);
                    var8.setFeatureSeed(var9, (int)var23, var16);
                    try {
                        var02.setCurrentlyGenerating(var25);
                        var24.placeWithBiomeCheck(var02, this, var8, var52);
                        continue;
                    }
                    catch (Exception var26) {
                        CrashReport var27 = CrashReport.forThrowable(var26, "Feature placement");
                        var27.addCategory("Feature").setDetail("Description", var25::get);
                        throw new ReportedException(var27);
                    }
                }
            }
            var02.setCurrentlyGenerating(null);
        }
        catch (Exception var13) {
            CrashReport var14 = CrashReport.forThrowable(var13, "Biome decoration");
            var14.addCategory("Generation").setDetail("CenterX", var3.x).setDetail("CenterZ", var3.z).setDetail("Seed", var9);
            throw new ReportedException(var14);
        }
    }

    private static StructureBoundingBox getWritableArea(IChunkAccess var0) {
        ChunkCoordIntPair var1 = var0.getPos();
        int var2 = var1.getMinBlockX();
        int var3 = var1.getMinBlockZ();
        LevelHeightAccessor var4 = var0.getHeightAccessorForGeneration();
        int var5 = var4.getMinBuildHeight() + 1;
        int var6 = var4.getMaxBuildHeight() - 1;
        return new StructureBoundingBox(var2, var5, var3, var2 + 15, var6, var3 + 15);
    }

    public abstract void buildSurface(RegionLimitedWorldAccess var1, StructureManager var2, IChunkAccess var3);

    public abstract void spawnOriginalMobs(RegionLimitedWorldAccess var1);

    public StructureSettings getSettings() {
        return this.settings;
    }

    public int getSpawnHeight(LevelHeightAccessor var0) {
        return 64;
    }

    public WorldChunkManager getBiomeSource() {
        return this.runtimeBiomeSource;
    }

    public abstract int getGenDepth();

    public WeightedRandomList<BiomeSettingsMobs.c> getMobsAt(BiomeBase var0, StructureManager var1, EnumCreatureType var2, BlockPosition var3) {
        return var0.getMobSettings().getMobs(var2);
    }

    public void createStructures(IRegistryCustom var0, StructureManager var1, IChunkAccess var2, DefinedStructureManager var3, long var4) {
        Object var9;
        ChunkCoordIntPair var6 = var2.getPos();
        SectionPosition var7 = SectionPosition.bottomOf(var2);
        StructureSettingsFeature var8 = this.settings.getConfig(StructureGenerator.STRONGHOLD);
        if (!(var8 == null || (var9 = var1.getStartForFeature(var7, StructureGenerator.STRONGHOLD, var2)) != null && ((StructureStart)var9).isValid())) {
            StructureStart<?> var10 = StructureFeatures.STRONGHOLD.generate(var0, this, this.biomeSource, var3, var4, var6, ChunkGenerator.fetchReferences(var1, var2, var7, StructureGenerator.STRONGHOLD), var8, var2, ChunkGenerator::validStrongholdBiome);
            var1.setStartForFeature(var7, StructureGenerator.STRONGHOLD, var10, var2);
        }
        var9 = var0.registryOrThrow(IRegistry.BIOME_REGISTRY);
        block0: for (StructureGenerator structureGenerator : IRegistry.STRUCTURE_FEATURE) {
            StructureStart<?> var13;
            StructureSettingsFeature var12;
            if (structureGenerator == StructureGenerator.STRONGHOLD || (var12 = this.settings.getConfig(structureGenerator)) == null || (var13 = var1.getStartForFeature(var7, structureGenerator, var2)) != null && var13.isValid()) continue;
            int var14 = ChunkGenerator.fetchReferences(var1, var2, var7, structureGenerator);
            for (Map.Entry var16 : this.settings.structures(structureGenerator).asMap().entrySet()) {
                StructureStart<?> var17 = ((StructureFeature)var16.getKey()).generate(var0, this, this.biomeSource, var3, var4, var6, var14, var12, var2, arg_0 -> this.a((IRegistry)var9, var16, arg_0));
                if (!var17.isValid()) continue;
                var1.setStartForFeature(var7, structureGenerator, var17, var2);
                continue block0;
            }
            var1.setStartForFeature(var7, structureGenerator, StructureStart.INVALID_START, var2);
        }
    }

    private static int fetchReferences(StructureManager var0, IChunkAccess var1, SectionPosition var2, StructureGenerator<?> var3) {
        StructureStart<?> var4 = var0.getStartForFeature(var2, var3, var1);
        return var4 != null ? var4.getReferences() : 0;
    }

    protected boolean validBiome(IRegistry<BiomeBase> var0, Predicate<ResourceKey<BiomeBase>> var1, BiomeBase var2) {
        return var0.getResourceKey(var2).filter(var1).isPresent();
    }

    public void createReferences(GeneratorAccessSeed var0, StructureManager var1, IChunkAccess var2) {
        int var3 = 8;
        ChunkCoordIntPair var4 = var2.getPos();
        int var5 = var4.x;
        int var6 = var4.z;
        int var7 = var4.getMinBlockX();
        int var8 = var4.getMinBlockZ();
        SectionPosition var9 = SectionPosition.bottomOf(var2);
        for (int var10 = var5 - 8; var10 <= var5 + 8; ++var10) {
            for (int var11 = var6 - 8; var11 <= var6 + 8; ++var11) {
                long var12 = ChunkCoordIntPair.asLong(var10, var11);
                for (StructureStart<?> var15 : var0.getChunk(var10, var11).getAllStarts().values()) {
                    try {
                        if (!var15.isValid() || !var15.getBoundingBox().intersects(var7, var8, var7 + 15, var8 + 15)) continue;
                        var1.addReferenceForFeature(var9, var15.getFeature(), var12, var2);
                        PacketDebug.sendStructurePacket(var0, var15);
                    }
                    catch (Exception var16) {
                        CrashReport var17 = CrashReport.forThrowable(var16, "Generating structure reference");
                        CrashReportSystemDetails var18 = var17.addCategory("Structure");
                        var18.setDetail("Id", () -> IRegistry.STRUCTURE_FEATURE.getKey(var15.getFeature()).toString());
                        var18.setDetail("Name", () -> var15.getFeature().getFeatureName());
                        var18.setDetail("Class", () -> var15.getFeature().getClass().getCanonicalName());
                        throw new ReportedException(var17);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<IChunkAccess> fillFromNoise(Executor var1, Blender var2, StructureManager var3, IChunkAccess var4);

    public abstract int getSeaLevel();

    public abstract int getMinY();

    public abstract int getBaseHeight(int var1, int var2, HeightMap.Type var3, LevelHeightAccessor var4);

    public abstract BlockColumn getBaseColumn(int var1, int var2, LevelHeightAccessor var3);

    public int getFirstFreeHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3) {
        return this.getBaseHeight(var0, var1, var2, var3);
    }

    public int getFirstOccupiedHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3) {
        return this.getBaseHeight(var0, var1, var2, var3) - 1;
    }

    public boolean hasStronghold(ChunkCoordIntPair var0) {
        this.generateStrongholds();
        return this.strongholdPositions.contains(var0);
    }

    private /* synthetic */ boolean a(IRegistry var0, Map.Entry var1, BiomeBase var2) {
        return this.validBiome(var0, ((Collection)var1.getValue())::contains, var2);
    }

    private static /* synthetic */ void a(IntSet var0, WorldChunkManager.b var1, PlacedFeature var2) {
        var0.add(var1.indexMapping().applyAsInt(var2));
    }

    private static /* synthetic */ String a(IRegistry var0, StructureGenerator var1) {
        return var0.getResourceKey(var1).map(Object::toString).orElseGet(var1::toString);
    }

    private static /* synthetic */ void a(GeneratorAccessSeed var0, Set var1, ChunkCoordIntPair var2) {
        IChunkAccess var3 = var0.getChunk(var2.x, var2.z);
        for (ChunkSection var7 : var3.getSections()) {
            var7.getBiomes().getAll(var1::add);
        }
    }

    static {
        IRegistry.register(IRegistry.CHUNK_GENERATOR, "noise", ChunkGeneratorAbstract.CODEC);
        IRegistry.register(IRegistry.CHUNK_GENERATOR, "flat", ChunkProviderFlat.CODEC);
        IRegistry.register(IRegistry.CHUNK_GENERATOR, "debug", ChunkProviderDebug.CODEC);
        CODEC = IRegistry.CHUNK_GENERATOR.byNameCodec().dispatchStable(ChunkGenerator::codec, Function.identity());
    }
}

