/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.players.UserCache;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntitySkull
extends TileEntity {
    public static final String TAG_SKULL_OWNER = "SkullOwner";
    @Nullable
    private static UserCache profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;
    @Nullable
    public GameProfile owner;
    private int mouthTickCount;
    private boolean isMovingMouth;

    public TileEntitySkull(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SKULL, var0, var1);
    }

    public static void setup(UserCache var0, MinecraftSessionService var1, Executor var2) {
        profileCache = var0;
        sessionService = var1;
        mainThreadExecutor = var2;
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (this.owner != null) {
            NBTTagCompound var1 = new NBTTagCompound();
            GameProfileSerializer.writeGameProfile(var1, this.owner);
            var0.put(TAG_SKULL_OWNER, var1);
        }
    }

    @Override
    public void load(NBTTagCompound var0) {
        String var1;
        super.load(var0);
        if (var0.contains(TAG_SKULL_OWNER, 10)) {
            this.setOwner(GameProfileSerializer.readGameProfile(var0.getCompound(TAG_SKULL_OWNER)));
        } else if (var0.contains("ExtraType", 8) && !UtilColor.isNullOrEmpty(var1 = var0.getString("ExtraType"))) {
            this.setOwner(new GameProfile(null, var1));
        }
    }

    public static void dragonHeadAnimation(World var0, BlockPosition var1, IBlockData var2, TileEntitySkull var3) {
        if (var0.hasNeighborSignal(var1)) {
            var3.isMovingMouth = true;
            ++var3.mouthTickCount;
        } else {
            var3.isMovingMouth = false;
        }
    }

    public float getMouthAnimation(float var0) {
        if (this.isMovingMouth) {
            return (float)this.mouthTickCount + var0;
        }
        return this.mouthTickCount;
    }

    @Nullable
    public GameProfile getOwnerProfile() {
        return this.owner;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile var0) {
        TileEntitySkull tileEntitySkull = this;
        synchronized (tileEntitySkull) {
            this.owner = var0;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        TileEntitySkull.updateGameprofile(this.owner, var0 -> {
            this.owner = var0;
            this.setChanged();
        });
    }

    public static void updateGameprofile(@Nullable GameProfile var0, Consumer<GameProfile> var1) {
        if (var0 == null || UtilColor.isNullOrEmpty(var0.getName()) || var0.isComplete() && var0.getProperties().containsKey((Object)"textures") || profileCache == null || sessionService == null) {
            var1.accept(var0);
            return;
        }
        profileCache.getAsync(var0.getName(), var2 -> SystemUtils.backgroundExecutor().execute(() -> SystemUtils.ifElse(var2, var1 -> {
            GameProfile var0 = (Property)Iterables.getFirst((Iterable)var1.getProperties().get((Object)"textures"), null);
            if (var0 == null) {
                var1 = sessionService.fillProfileProperties(var1, true);
            }
            GameProfile var3 = var1;
            mainThreadExecutor.execute(() -> {
                profileCache.add(var3);
                var1.accept(var3);
            });
        }, () -> mainThreadExecutor.execute(() -> var1.accept(var0)))));
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

