/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TileEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TileEntityTypes<?> type;
    @Nullable
    protected World level;
    protected final BlockPosition worldPosition;
    protected boolean remove;
    private IBlockData blockState;

    public TileEntity(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        this.type = var0;
        this.worldPosition = var1.immutable();
        this.blockState = var2;
    }

    public static BlockPosition getPosFromTag(NBTTagCompound var0) {
        return new BlockPosition(var0.getInt("x"), var0.getInt("y"), var0.getInt("z"));
    }

    @Nullable
    public World getLevel() {
        return this.level;
    }

    public void setLevel(World var0) {
        this.level = var0;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    public void load(NBTTagCompound var0) {
    }

    protected void saveAdditional(NBTTagCompound var0) {
    }

    public final NBTTagCompound saveWithFullMetadata() {
        NBTTagCompound var0 = this.saveWithoutMetadata();
        this.saveMetadata(var0);
        return var0;
    }

    public final NBTTagCompound saveWithId() {
        NBTTagCompound var0 = this.saveWithoutMetadata();
        this.saveId(var0);
        return var0;
    }

    public final NBTTagCompound saveWithoutMetadata() {
        NBTTagCompound var0 = new NBTTagCompound();
        this.saveAdditional(var0);
        return var0;
    }

    private void saveId(NBTTagCompound var0) {
        MinecraftKey var1 = TileEntityTypes.getKey(this.getType());
        if (var1 == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        var0.putString("id", var1.toString());
    }

    public static void addEntityType(NBTTagCompound var0, TileEntityTypes<?> var1) {
        var0.putString("id", TileEntityTypes.getKey(var1).toString());
    }

    public void saveToItem(ItemStack var0) {
        ItemBlock.setBlockEntityData(var0, this.getType(), this.saveWithoutMetadata());
    }

    private void saveMetadata(NBTTagCompound var0) {
        this.saveId(var0);
        var0.putInt("x", this.worldPosition.getX());
        var0.putInt("y", this.worldPosition.getY());
        var0.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static TileEntity loadStatic(BlockPosition var0, IBlockData var1, NBTTagCompound var22) {
        String var32 = var22.getString("id");
        MinecraftKey var4 = MinecraftKey.tryParse(var32);
        if (var4 == null) {
            LOGGER.error("Block entity has invalid type: {}", (Object)var32);
            return null;
        }
        return IRegistry.BLOCK_ENTITY_TYPE.getOptional(var4).map(var3 -> {
            try {
                return var3.create(var0, var1);
            }
            catch (Throwable var4) {
                LOGGER.error("Failed to create block entity {}", (Object)var32, (Object)var4);
                return null;
            }
        }).map(var2 -> {
            try {
                var2.load(var22);
                return var2;
            }
            catch (Throwable var3) {
                LOGGER.error("Failed to load data for block entity {}", (Object)var32, (Object)var3);
                return null;
            }
        }).orElseGet(() -> {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)var32);
            return null;
        });
    }

    public void setChanged() {
        if (this.level != null) {
            TileEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(World var0, BlockPosition var1, IBlockData var2) {
        var0.blockEntityChanged(var1);
        if (!var2.isAir()) {
            var0.updateNeighbourForOutputSignal(var1, var2.getBlock());
        }
    }

    public BlockPosition getBlockPos() {
        return this.worldPosition;
    }

    public IBlockData getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> getUpdatePacket() {
        return null;
    }

    public NBTTagCompound getUpdateTag() {
        return new NBTTagCompound();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public boolean triggerEvent(int var0, int var1) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportSystemDetails var0) {
        var0.setDetail("Name", () -> IRegistry.BLOCK_ENTITY_TYPE.getKey(this.getType()) + " // " + this.getClass().getCanonicalName());
        if (this.level == null) {
            return;
        }
        CrashReportSystemDetails.populateBlockDetails(var0, this.level, this.worldPosition, this.getBlockState());
        CrashReportSystemDetails.populateBlockDetails(var0, this.level, this.worldPosition, this.level.getBlockState(this.worldPosition));
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    public TileEntityTypes<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(IBlockData var0) {
        this.blockState = var0;
    }
}

