/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.math.PointGroupO;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.block.EnumBlockRotation;

public final class EnumBlockMirror
extends Enum<EnumBlockMirror> {
    public static final /* enum */ EnumBlockMirror NONE = new EnumBlockMirror(new ChatMessage("mirror.none"), PointGroupO.IDENTITY);
    public static final /* enum */ EnumBlockMirror LEFT_RIGHT = new EnumBlockMirror(new ChatMessage("mirror.left_right"), PointGroupO.INVERT_Z);
    public static final /* enum */ EnumBlockMirror FRONT_BACK = new EnumBlockMirror(new ChatMessage("mirror.front_back"), PointGroupO.INVERT_X);
    private final IChatBaseComponent symbol;
    private final PointGroupO rotation;
    private static final /* synthetic */ EnumBlockMirror[] f;

    public static EnumBlockMirror[] values() {
        return (EnumBlockMirror[])f.clone();
    }

    public static EnumBlockMirror valueOf(String var0) {
        return Enum.valueOf(EnumBlockMirror.class, var0);
    }

    private EnumBlockMirror(IChatBaseComponent var2, PointGroupO var3) {
        this.symbol = var2;
        this.rotation = var3;
    }

    public int mirror(int var0, int var1) {
        int var2 = var1 / 2;
        int var3 = var0 > var2 ? var0 - var1 : var0;
        switch (this) {
            case FRONT_BACK: {
                return (var1 - var3) % var1;
            }
            case LEFT_RIGHT: {
                return (var2 - var3 + var1) % var1;
            }
        }
        return var0;
    }

    public EnumBlockRotation getRotation(EnumDirection var0) {
        EnumDirection.EnumAxis var1 = var0.getAxis();
        return this == LEFT_RIGHT && var1 == EnumDirection.EnumAxis.Z || this == FRONT_BACK && var1 == EnumDirection.EnumAxis.X ? EnumBlockRotation.CLOCKWISE_180 : EnumBlockRotation.NONE;
    }

    public EnumDirection mirror(EnumDirection var0) {
        if (this == FRONT_BACK && var0.getAxis() == EnumDirection.EnumAxis.X) {
            return var0.getOpposite();
        }
        if (this == LEFT_RIGHT && var0.getAxis() == EnumDirection.EnumAxis.Z) {
            return var0.getOpposite();
        }
        return var0;
    }

    public PointGroupO rotation() {
        return this.rotation;
    }

    public IChatBaseComponent symbol() {
        return this.symbol;
    }

    private static /* synthetic */ EnumBlockMirror[] c() {
        return new EnumBlockMirror[]{NONE, LEFT_RIGHT, FRONT_BACK};
    }

    static {
        f = EnumBlockMirror.c();
    }
}

