/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockTripwire
extends Block {
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean ATTACHED = BlockProperties.ATTACHED;
    public static final BlockStateBoolean DISARMED = BlockProperties.DISARMED;
    public static final BlockStateBoolean NORTH = BlockSprawling.NORTH;
    public static final BlockStateBoolean EAST = BlockSprawling.EAST;
    public static final BlockStateBoolean SOUTH = BlockSprawling.SOUTH;
    public static final BlockStateBoolean WEST = BlockSprawling.WEST;
    private static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockTall.PROPERTY_BY_DIRECTION;
    protected static final VoxelShape AABB = Block.box(0.0, 1.0, 0.0, 16.0, 2.5, 16.0);
    protected static final VoxelShape NOT_ATTACHED_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final int RECHECK_PERIOD = 10;
    private final BlockTripwireHook hook;

    public BlockTripwire(BlockTripwireHook var0, BlockBase.Info var1) {
        super(var1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWERED, false)).setValue(ATTACHED, false)).setValue(DISARMED, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.hook = var0;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return var0.getValue(ATTACHED) != false ? AABB : NOT_ATTACHED_AABB;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(NORTH, this.shouldConnectTo(var1.getBlockState(var2.north()), EnumDirection.NORTH))).setValue(EAST, this.shouldConnectTo(var1.getBlockState(var2.east()), EnumDirection.EAST))).setValue(SOUTH, this.shouldConnectTo(var1.getBlockState(var2.south()), EnumDirection.SOUTH))).setValue(WEST, this.shouldConnectTo(var1.getBlockState(var2.west()), EnumDirection.WEST));
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1.getAxis().isHorizontal()) {
            return (IBlockData)var0.setValue(PROPERTY_BY_DIRECTION.get(var1), this.shouldConnectTo(var2, var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.updateSource(var1, var2, var0);
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var4 || var0.is(var3.getBlock())) {
            return;
        }
        this.updateSource(var1, var2, (IBlockData)var0.setValue(POWERED, true));
    }

    @Override
    public void playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        if (!var0.isClientSide && !var3.getMainHandItem().isEmpty() && var3.getMainHandItem().is(Items.SHEARS)) {
            var0.setBlock(var1, (IBlockData)var2.setValue(DISARMED, true), 4);
            var0.gameEvent((Entity)var3, GameEvent.SHEAR, var1);
        }
        super.playerWillDestroy(var0, var1, var2, var3);
    }

    private void updateSource(World var0, BlockPosition var1, IBlockData var2) {
        block0: for (EnumDirection var6 : new EnumDirection[]{EnumDirection.SOUTH, EnumDirection.WEST}) {
            for (int var7 = 1; var7 < 42; ++var7) {
                BlockPosition var8 = var1.relative(var6, var7);
                IBlockData var9 = var0.getBlockState(var8);
                if (var9.is(this.hook)) {
                    if (var9.getValue(BlockTripwireHook.FACING) != var6.getOpposite()) continue block0;
                    this.hook.calculateState(var0, var8, var9, false, true, var7, var2);
                    continue block0;
                }
                if (!var9.is(this)) continue block0;
            }
        }
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var1.isClientSide) {
            return;
        }
        if (var0.getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(var1, var2);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        if (!var1.getBlockState(var2).getValue(POWERED).booleanValue()) {
            return;
        }
        this.checkPressed(var1, var2);
    }

    private void checkPressed(World var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        boolean var3 = var2.getValue(POWERED);
        boolean var4 = false;
        List<Entity> var5 = var0.getEntities(null, var2.getShape(var0, var1).bounds().move(var1));
        if (!var5.isEmpty()) {
            for (Entity var7 : var5) {
                if (var7.isIgnoringBlockTriggers()) continue;
                var4 = true;
                break;
            }
        }
        if (var4 != var3) {
            var2 = (IBlockData)var2.setValue(POWERED, var4);
            var0.setBlock(var1, var2, 3);
            this.updateSource(var0, var1, var2);
        }
        if (var4) {
            var0.scheduleTick(new BlockPosition(var1), this, 10);
        }
    }

    public boolean shouldConnectTo(IBlockData var0, EnumDirection var1) {
        if (var0.is(this.hook)) {
            return var0.getValue(BlockTripwireHook.FACING) == var1.getOpposite();
        }
        return var0.is(this);
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            }
        }
        return var0;
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH);
    }
}

