/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockSprawling
extends Block {
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();
    public static final BlockStateBoolean NORTH = BlockProperties.NORTH;
    public static final BlockStateBoolean EAST = BlockProperties.EAST;
    public static final BlockStateBoolean SOUTH = BlockProperties.SOUTH;
    public static final BlockStateBoolean WEST = BlockProperties.WEST;
    public static final BlockStateBoolean UP = BlockProperties.UP;
    public static final BlockStateBoolean DOWN = BlockProperties.DOWN;
    public static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)SystemUtils.make(Maps.newEnumMap(EnumDirection.class), var0 -> {
        var0.put(EnumDirection.NORTH, NORTH);
        var0.put(EnumDirection.EAST, EAST);
        var0.put(EnumDirection.SOUTH, SOUTH);
        var0.put(EnumDirection.WEST, WEST);
        var0.put(EnumDirection.UP, UP);
        var0.put(EnumDirection.DOWN, DOWN);
    }));
    protected final VoxelShape[] shapeByIndex;

    protected BlockSprawling(float var0, BlockBase.Info var1) {
        super(var1);
        this.shapeByIndex = this.makeShapes(var0);
    }

    private VoxelShape[] makeShapes(float var0) {
        float var1 = 0.5f - var0;
        float var2 = 0.5f + var0;
        VoxelShape var3 = Block.box(var1 * 16.0f, var1 * 16.0f, var1 * 16.0f, var2 * 16.0f, var2 * 16.0f, var2 * 16.0f);
        VoxelShape[] var4 = new VoxelShape[DIRECTIONS.length];
        for (int var5 = 0; var5 < DIRECTIONS.length; ++var5) {
            EnumDirection var6 = DIRECTIONS[var5];
            var4[var5] = VoxelShapes.box(0.5 + Math.min((double)(-var0), (double)var6.getStepX() * 0.5), 0.5 + Math.min((double)(-var0), (double)var6.getStepY() * 0.5), 0.5 + Math.min((double)(-var0), (double)var6.getStepZ() * 0.5), 0.5 + Math.max((double)var0, (double)var6.getStepX() * 0.5), 0.5 + Math.max((double)var0, (double)var6.getStepY() * 0.5), 0.5 + Math.max((double)var0, (double)var6.getStepZ() * 0.5));
        }
        VoxelShape[] var5 = new VoxelShape[64];
        for (int var6 = 0; var6 < 64; ++var6) {
            VoxelShape var7 = var3;
            for (int var8 = 0; var8 < DIRECTIONS.length; ++var8) {
                if ((var6 & 1 << var8) == 0) continue;
                var7 = VoxelShapes.or(var7, var4[var8]);
            }
            var5[var6] = var7;
        }
        return var5;
    }

    @Override
    public boolean propagatesSkylightDown(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return false;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapeByIndex[this.getAABBIndex(var0)];
    }

    protected int getAABBIndex(IBlockData var0) {
        int var1 = 0;
        for (int var2 = 0; var2 < DIRECTIONS.length; ++var2) {
            if (!((Boolean)var0.getValue(PROPERTY_BY_DIRECTION.get(DIRECTIONS[var2]))).booleanValue()) continue;
            var1 |= 1 << var2;
        }
        return var1;
    }
}

