/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;

public class BlockSponge
extends Block {
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;

    protected BlockSponge(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.tryAbsorbWater(var1, var2);
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        this.tryAbsorbWater(var1, var2);
        super.neighborChanged(var0, var1, var2, var3, var4, var5);
    }

    protected void tryAbsorbWater(World var0, BlockPosition var1) {
        if (this.removeWaterBreadthFirstSearch(var0, var1)) {
            var0.setBlock(var1, Blocks.WET_SPONGE.defaultBlockState(), 2);
            var0.levelEvent(2001, var1, Block.getId(Blocks.WATER.defaultBlockState()));
        }
    }

    private boolean removeWaterBreadthFirstSearch(World var0, BlockPosition var1) {
        LinkedList var2 = Lists.newLinkedList();
        var2.add(new Tuple<BlockPosition, Integer>(var1, 0));
        int var3 = 0;
        while (!var2.isEmpty()) {
            Tuple var4 = (Tuple)var2.poll();
            BlockPosition var5 = (BlockPosition)var4.getA();
            int var6 = (Integer)var4.getB();
            for (EnumDirection var10 : EnumDirection.values()) {
                BlockPosition var11 = var5.relative(var10);
                IBlockData var12 = var0.getBlockState(var11);
                Fluid var13 = var0.getFluidState(var11);
                Material var14 = var12.getMaterial();
                if (!var13.is(TagsFluid.WATER)) continue;
                if (var12.getBlock() instanceof IFluidSource && !((IFluidSource)((Object)var12.getBlock())).pickupBlock(var0, var11, var12).isEmpty()) {
                    ++var3;
                    if (var6 >= 6) continue;
                    var2.add(new Tuple<BlockPosition, Integer>(var11, var6 + 1));
                    continue;
                }
                if (var12.getBlock() instanceof BlockFluids) {
                    var0.setBlock(var11, Blocks.AIR.defaultBlockState(), 3);
                    ++var3;
                    if (var6 >= 6) continue;
                    var2.add(new Tuple<BlockPosition, Integer>(var11, var6 + 1));
                    continue;
                }
                if (var14 != Material.WATER_PLANT && var14 != Material.REPLACEABLE_WATER_PLANT) continue;
                TileEntity var15 = var12.hasBlockEntity() ? var0.getBlockEntity(var11) : null;
                BlockSponge.dropResources(var12, var0, var11, var15);
                var0.setBlock(var11, Blocks.AIR.defaultBlockState(), 3);
                ++var3;
                if (var6 >= 6) continue;
                var2.add(new Tuple<BlockPosition, Integer>(var11, var6 + 1));
            }
            if (var3 <= 64) continue;
            break;
        }
        return var3 > 0;
    }
}

