/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;

public class BlockObserver
extends BlockDirectional {
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;

    public BlockObserver(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.SOUTH)).setValue(POWERED, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, POWERED);
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        if (var0.getValue(POWERED).booleanValue()) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, false), 2);
        } else {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, true), 2);
            var1.scheduleTick(var2, this, 2);
        }
        this.updateNeighborsInFront(var1, var2, var0);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(FACING) == var1 && !var0.getValue(POWERED).booleanValue()) {
            this.startSignal(var3, var4);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    private void startSignal(GeneratorAccess var0, BlockPosition var1) {
        if (!var0.isClientSide() && !var0.getBlockTicks().hasScheduledTick(var1, this)) {
            var0.scheduleTick(var1, this, 2);
        }
    }

    protected void updateNeighborsInFront(World var0, BlockPosition var1, IBlockData var2) {
        EnumDirection var3 = var2.getValue(FACING);
        BlockPosition var4 = var1.relative(var3.getOpposite());
        var0.neighborChanged(var4, this, var1);
        var0.updateNeighborsAtExceptFromFacing(var4, this, var3);
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    public int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getSignal(var1, var2, var3);
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(POWERED).booleanValue() && var0.getValue(FACING) == var3) {
            return 15;
        }
        return 0;
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        if (!var1.isClientSide() && var0.getValue(POWERED).booleanValue() && !var1.getBlockTicks().hasScheduledTick(var2, this)) {
            IBlockData var5 = (IBlockData)var0.setValue(POWERED, false);
            var1.setBlock(var2, var5, 18);
            this.updateNeighborsInFront(var1, var2, var5);
        }
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        if (!var1.isClientSide && var0.getValue(POWERED).booleanValue() && var1.getBlockTicks().hasScheduledTick(var2, this)) {
            this.updateNeighborsInFront(var1, var2, (IBlockData)var0.setValue(POWERED, false));
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getNearestLookingDirection().getOpposite().getOpposite());
    }
}

