/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBubbleColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockMagma
extends Block {
    private static final int BUBBLE_COLUMN_CHECK_DELAY = 20;

    public BlockMagma(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public void stepOn(World var0, BlockPosition var1, IBlockData var2, Entity var3) {
        if (!var3.fireImmune() && var3 instanceof EntityLiving && !EnchantmentManager.hasFrostWalker((EntityLiving)var3)) {
            var3.hurt(DamageSource.HOT_FLOOR, 1.0f);
        }
        super.stepOn(var0, var1, var2, var3);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        BlockBubbleColumn.updateColumn(var1, var2.above(), var0);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.UP && var2.is(Blocks.WATER)) {
            var3.scheduleTick(var4, this, 20);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        BlockPosition var4 = var2.above();
        if (var1.getFluidState(var2).is(TagsFluid.WATER)) {
            var1.playSound(null, var2, SoundEffects.FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 2.6f + (var1.random.nextFloat() - var1.random.nextFloat()) * 0.8f);
            var1.sendParticles(Particles.LARGE_SMOKE, (double)var4.getX() + 0.5, (double)var4.getY() + 0.25, (double)var4.getZ() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
        }
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        var1.scheduleTick(var2, this, 20);
    }
}

