/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;

public class BlockEndGateway
extends BlockTileEntity {
    protected BlockEndGateway(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityEndGateway(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockEndGateway.createTickerHelper(var2, TileEntityTypes.END_GATEWAY, var0.isClientSide ? TileEntityEndGateway::beamAnimationTick : TileEntityEndGateway::teleportTick);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, Random var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (!(var4 instanceof TileEntityEndGateway)) {
            return;
        }
        int var5 = ((TileEntityEndGateway)var4).getParticleAmount();
        for (int var6 = 0; var6 < var5; ++var6) {
            double var7 = (double)var2.getX() + var3.nextDouble();
            double var9 = (double)var2.getY() + var3.nextDouble();
            double var11 = (double)var2.getZ() + var3.nextDouble();
            double var13 = (var3.nextDouble() - 0.5) * 0.5;
            double var15 = (var3.nextDouble() - 0.5) * 0.5;
            double var17 = (var3.nextDouble() - 0.5) * 0.5;
            int var19 = var3.nextInt(2) * 2 - 1;
            if (var3.nextBoolean()) {
                var11 = (double)var2.getZ() + 0.5 + 0.25 * (double)var19;
                var17 = var3.nextFloat() * 2.0f * (float)var19;
            } else {
                var7 = (double)var2.getX() + 0.5 + 0.25 * (double)var19;
                var13 = var3.nextFloat() * 2.0f * (float)var19;
            }
            var1.addParticle(Particles.PORTAL, var7, var9, var11, var13, var15, var17);
        }
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, FluidType var1) {
        return false;
    }
}

