/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;

public class WorldChunkManagerHell
extends WorldChunkManager
implements BiomeManager.Provider {
    public static final Codec<WorldChunkManagerHell> CODEC = BiomeBase.CODEC.fieldOf("biome").xmap(WorldChunkManagerHell::new, var0 -> var0.biome).stable().codec();
    private final Supplier<BiomeBase> biome;

    public WorldChunkManagerHell(BiomeBase var0) {
        this(() -> var0);
    }

    public WorldChunkManagerHell(Supplier<BiomeBase> var0) {
        super((List<BiomeBase>)ImmutableList.of((Object)var0.get()));
        this.biome = var0;
    }

    @Override
    protected Codec<? extends WorldChunkManager> codec() {
        return CODEC;
    }

    @Override
    public WorldChunkManager withSeed(long var0) {
        return this;
    }

    @Override
    public BiomeBase getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        return this.biome.get();
    }

    @Override
    public BiomeBase getNoiseBiome(int var0, int var1, int var2) {
        return this.biome.get();
    }

    @Override
    @Nullable
    public BlockPosition findBiomeHorizontal(int var0, int var1, int var2, int var3, int var4, Predicate<BiomeBase> var5, Random var6, boolean var7, Climate.Sampler var8) {
        if (var5.test(this.biome.get())) {
            if (var7) {
                return new BlockPosition(var0, var1, var2);
            }
            return new BlockPosition(var0 - var3 + var6.nextInt(var3 * 2 + 1), var1, var2 - var3 + var6.nextInt(var3 * 2 + 1));
        }
        return null;
    }

    @Override
    public Set<BiomeBase> getBiomesWithin(int var0, int var1, int var2, int var3, Climate.Sampler var4) {
        return Sets.newHashSet((Object[])new BiomeBase[]{this.biome.get()});
    }
}

