/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;

public final class TerrainShaper {
    private static final Codec<CubicSpline<b>> SPLINE_CODEC = CubicSpline.codec(a.WIDE_CODEC);
    public static final Codec<TerrainShaper> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)SPLINE_CODEC.fieldOf("offset").forGetter(TerrainShaper::offsetSampler), (App)SPLINE_CODEC.fieldOf("factor").forGetter(TerrainShaper::factorSampler), (App)SPLINE_CODEC.fieldOf("jaggedness").forGetter(var0 -> var0.jaggednessSampler)).apply((Applicative)var02, TerrainShaper::new));
    private static final float GLOBAL_OFFSET = -0.50375f;
    private static final ToFloatFunction<Float> NO_TRANSFORM = var0 -> var0.floatValue();
    private final CubicSpline<b> offsetSampler;
    private final CubicSpline<b> factorSampler;
    private final CubicSpline<b> jaggednessSampler;

    public TerrainShaper(CubicSpline<b> var0, CubicSpline<b> var1, CubicSpline<b> var2) {
        this.offsetSampler = var0;
        this.factorSampler = var1;
        this.jaggednessSampler = var2;
    }

    private static float getAmplifiedOffset(float var0) {
        return var0 < 0.0f ? var0 : var0 * 2.0f;
    }

    private static float getAmplifiedFactor(float var0) {
        return 1.25f - 6.25f / (var0 + 5.0f);
    }

    private static float getAmplifiedJaggedness(float var0) {
        return var0 * 2.0f;
    }

    public static TerrainShaper overworld(boolean var0) {
        ToFloatFunction<Float> var1 = var0 ? TerrainShaper::getAmplifiedOffset : NO_TRANSFORM;
        ToFloatFunction<Float> var2 = var0 ? TerrainShaper::getAmplifiedFactor : NO_TRANSFORM;
        ToFloatFunction<Float> var3 = var0 ? TerrainShaper::getAmplifiedJaggedness : NO_TRANSFORM;
        CubicSpline<b> var4 = TerrainShaper.buildErosionOffsetSpline(-0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, var1);
        CubicSpline<b> var5 = TerrainShaper.buildErosionOffsetSpline(-0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, var1);
        CubicSpline<b> var6 = TerrainShaper.buildErosionOffsetSpline(-0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, var1);
        CubicSpline<b> var7 = TerrainShaper.buildErosionOffsetSpline(-0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, var1);
        float var8 = -0.51f;
        float var9 = -0.4f;
        float var10 = 0.1f;
        float var11 = -0.15f;
        CubicSpline<b> var12 = CubicSpline.builder(a.CONTINENTS, var1).addPoint(-1.1f, 0.044f, 0.0f).addPoint(-1.02f, -0.2222f, 0.0f).addPoint(-0.51f, -0.2222f, 0.0f).addPoint(-0.44f, -0.12f, 0.0f).addPoint(-0.18f, -0.12f, 0.0f).addPoint(-0.16f, var4, 0.0f).addPoint(-0.15f, var4, 0.0f).addPoint(-0.1f, var5, 0.0f).addPoint(0.25f, var6, 0.0f).addPoint(1.0f, var7, 0.0f).build();
        CubicSpline<b> var13 = CubicSpline.builder(a.CONTINENTS, NO_TRANSFORM).addPoint(-0.19f, 3.95f, 0.0f).addPoint(-0.15f, TerrainShaper.getErosionFactor(6.25f, true, NO_TRANSFORM), 0.0f).addPoint(-0.1f, TerrainShaper.getErosionFactor(5.47f, true, var2), 0.0f).addPoint(0.03f, TerrainShaper.getErosionFactor(5.08f, true, var2), 0.0f).addPoint(0.06f, TerrainShaper.getErosionFactor(4.69f, false, var2), 0.0f).build();
        float var14 = 0.65f;
        CubicSpline<b> var15 = CubicSpline.builder(a.CONTINENTS, var3).addPoint(-0.11f, 0.0f, 0.0f).addPoint(0.03f, TerrainShaper.buildErosionJaggednessSpline(1.0f, 0.5f, 0.0f, 0.0f, var3), 0.0f).addPoint(0.65f, TerrainShaper.buildErosionJaggednessSpline(1.0f, 1.0f, 1.0f, 0.0f, var3), 0.0f).build();
        return new TerrainShaper(var12, var13, var15);
    }

    private static CubicSpline<b> buildErosionJaggednessSpline(float var0, float var1, float var2, float var3, ToFloatFunction<Float> var4) {
        float var5 = -0.5775f;
        CubicSpline<b> var6 = TerrainShaper.buildRidgeJaggednessSpline(var0, var2, var4);
        CubicSpline<b> var7 = TerrainShaper.buildRidgeJaggednessSpline(var1, var3, var4);
        return CubicSpline.builder(a.EROSION, var4).addPoint(-1.0f, var6, 0.0f).addPoint(-0.78f, var7, 0.0f).addPoint(-0.5775f, var7, 0.0f).addPoint(-0.375f, 0.0f, 0.0f).build();
    }

    private static CubicSpline<b> buildRidgeJaggednessSpline(float var0, float var1, ToFloatFunction<Float> var2) {
        float var3 = TerrainShaper.peaksAndValleys(0.4f);
        float var4 = TerrainShaper.peaksAndValleys(0.56666666f);
        float var5 = (var3 + var4) / 2.0f;
        CubicSpline.b<b> var6 = CubicSpline.builder(a.RIDGES, var2);
        var6.addPoint(var3, 0.0f, 0.0f);
        if (var1 > 0.0f) {
            var6.addPoint(var5, TerrainShaper.buildWeirdnessJaggednessSpline(var1, var2), 0.0f);
        } else {
            var6.addPoint(var5, 0.0f, 0.0f);
        }
        if (var0 > 0.0f) {
            var6.addPoint(1.0f, TerrainShaper.buildWeirdnessJaggednessSpline(var0, var2), 0.0f);
        } else {
            var6.addPoint(1.0f, 0.0f, 0.0f);
        }
        return var6.build();
    }

    private static CubicSpline<b> buildWeirdnessJaggednessSpline(float var0, ToFloatFunction<Float> var1) {
        float var2 = 0.63f * var0;
        float var3 = 0.3f * var0;
        return CubicSpline.builder(a.WEIRDNESS, var1).addPoint(-0.01f, var2, 0.0f).addPoint(0.01f, var3, 0.0f).build();
    }

    private static CubicSpline<b> getErosionFactor(float var0, boolean var1, ToFloatFunction<Float> var2) {
        CubicSpline<b> var3 = CubicSpline.builder(a.WEIRDNESS, var2).addPoint(-0.2f, 6.3f, 0.0f).addPoint(0.2f, var0, 0.0f).build();
        CubicSpline.b<b> var4 = CubicSpline.builder(a.EROSION, var2).addPoint(-0.6f, var3, 0.0f).addPoint(-0.5f, CubicSpline.builder(a.WEIRDNESS, var2).addPoint(-0.05f, 6.3f, 0.0f).addPoint(0.05f, 2.67f, 0.0f).build(), 0.0f).addPoint(-0.35f, var3, 0.0f).addPoint(-0.25f, var3, 0.0f).addPoint(-0.1f, CubicSpline.builder(a.WEIRDNESS, var2).addPoint(-0.05f, 2.67f, 0.0f).addPoint(0.05f, 6.3f, 0.0f).build(), 0.0f).addPoint(0.03f, var3, 0.0f);
        if (var1) {
            CubicSpline<b> var5 = CubicSpline.builder(a.WEIRDNESS, var2).addPoint(0.0f, var0, 0.0f).addPoint(0.1f, 0.625f, 0.0f).build();
            CubicSpline<b> var6 = CubicSpline.builder(a.RIDGES, var2).addPoint(-0.9f, var0, 0.0f).addPoint(-0.69f, var5, 0.0f).build();
            var4.addPoint(0.35f, var0, 0.0f).addPoint(0.45f, var6, 0.0f).addPoint(0.55f, var6, 0.0f).addPoint(0.62f, var0, 0.0f);
        } else {
            CubicSpline<b> var5 = CubicSpline.builder(a.RIDGES, var2).addPoint(-0.7f, var3, 0.0f).addPoint(-0.15f, 1.37f, 0.0f).build();
            CubicSpline<b> var6 = CubicSpline.builder(a.RIDGES, var2).addPoint(0.45f, var3, 0.0f).addPoint(0.7f, 1.56f, 0.0f).build();
            var4.addPoint(0.05f, var6, 0.0f).addPoint(0.4f, var6, 0.0f).addPoint(0.45f, var5, 0.0f).addPoint(0.55f, var5, 0.0f).addPoint(0.58f, var0, 0.0f);
        }
        return var4.build();
    }

    private static float calculateSlope(float var0, float var1, float var2, float var3) {
        return (var1 - var0) / (var3 - var2);
    }

    private static CubicSpline<b> buildMountainRidgeSplineWithPoints(float var0, boolean var1, ToFloatFunction<Float> var2) {
        CubicSpline.b<b> var3 = CubicSpline.builder(a.RIDGES, var2);
        float var4 = -0.7f;
        float var5 = -1.0f;
        float var6 = TerrainShaper.mountainContinentalness(-1.0f, var0, -0.7f);
        float var7 = 1.0f;
        float var8 = TerrainShaper.mountainContinentalness(1.0f, var0, -0.7f);
        float var9 = TerrainShaper.calculateMountainRidgeZeroContinentalnessPoint(var0);
        float var10 = -0.65f;
        if (-0.65f < var9 && var9 < 1.0f) {
            float var11 = TerrainShaper.mountainContinentalness(-0.65f, var0, -0.7f);
            float var12 = -0.75f;
            float var13 = TerrainShaper.mountainContinentalness(-0.75f, var0, -0.7f);
            float var14 = TerrainShaper.calculateSlope(var6, var13, -1.0f, -0.75f);
            var3.addPoint(-1.0f, var6, var14);
            var3.addPoint(-0.75f, var13, 0.0f);
            var3.addPoint(-0.65f, var11, 0.0f);
            float var15 = TerrainShaper.mountainContinentalness(var9, var0, -0.7f);
            float var16 = TerrainShaper.calculateSlope(var15, var8, var9, 1.0f);
            float var17 = 0.01f;
            var3.addPoint(var9 - 0.01f, var15, 0.0f);
            var3.addPoint(var9, var15, var16);
            var3.addPoint(1.0f, var8, var16);
        } else {
            float var11 = TerrainShaper.calculateSlope(var6, var8, -1.0f, 1.0f);
            if (var1) {
                var3.addPoint(-1.0f, Math.max(0.2f, var6), 0.0f);
                var3.addPoint(0.0f, MathHelper.lerp(0.5f, var6, var8), var11);
            } else {
                var3.addPoint(-1.0f, var6, var11);
            }
            var3.addPoint(1.0f, var8, var11);
        }
        return var3.build();
    }

    private static float mountainContinentalness(float var0, float var1, float var2) {
        float var3 = 1.17f;
        float var4 = 0.46082947f;
        float var5 = 1.0f - (1.0f - var1) * 0.5f;
        float var6 = 0.5f * (1.0f - var1);
        float var7 = (var0 + 1.17f) * 0.46082947f;
        float var8 = var7 * var5 - var6;
        if (var0 < var2) {
            return Math.max(var8, -0.2222f);
        }
        return Math.max(var8, 0.0f);
    }

    private static float calculateMountainRidgeZeroContinentalnessPoint(float var0) {
        float var1 = 1.17f;
        float var2 = 0.46082947f;
        float var3 = 1.0f - (1.0f - var0) * 0.5f;
        float var4 = 0.5f * (1.0f - var0);
        return var4 / (0.46082947f * var3) - 1.17f;
    }

    private static CubicSpline<b> buildErosionOffsetSpline(float var0, float var1, float var2, float var3, float var4, float var5, boolean var6, boolean var7, ToFloatFunction<Float> var8) {
        float var9 = 0.6f;
        float var10 = 0.5f;
        float var11 = 0.5f;
        CubicSpline<b> var12 = TerrainShaper.buildMountainRidgeSplineWithPoints(MathHelper.lerp(var3, 0.6f, 1.5f), var7, var8);
        CubicSpline<b> var13 = TerrainShaper.buildMountainRidgeSplineWithPoints(MathHelper.lerp(var3, 0.6f, 1.0f), var7, var8);
        CubicSpline<b> var14 = TerrainShaper.buildMountainRidgeSplineWithPoints(var3, var7, var8);
        CubicSpline<b> var15 = TerrainShaper.ridgeSpline(var0 - 0.15f, 0.5f * var3, MathHelper.lerp(0.5f, 0.5f, 0.5f) * var3, 0.5f * var3, 0.6f * var3, 0.5f, var8);
        CubicSpline<b> var16 = TerrainShaper.ridgeSpline(var0, var4 * var3, var1 * var3, 0.5f * var3, 0.6f * var3, 0.5f, var8);
        CubicSpline<b> var17 = TerrainShaper.ridgeSpline(var0, var4, var4, var1, var2, 0.5f, var8);
        CubicSpline<b> var18 = TerrainShaper.ridgeSpline(var0, var4, var4, var1, var2, 0.5f, var8);
        CubicSpline<b> var19 = CubicSpline.builder(a.RIDGES, var8).addPoint(-1.0f, var0, 0.0f).addPoint(-0.4f, var17, 0.0f).addPoint(0.0f, var2 + 0.07f, 0.0f).build();
        CubicSpline<b> var20 = TerrainShaper.ridgeSpline(-0.02f, var5, var5, var1, var2, 0.0f, var8);
        CubicSpline.b<b> var21 = CubicSpline.builder(a.EROSION, var8).addPoint(-0.85f, var12, 0.0f).addPoint(-0.7f, var13, 0.0f).addPoint(-0.4f, var14, 0.0f).addPoint(-0.35f, var15, 0.0f).addPoint(-0.1f, var16, 0.0f).addPoint(0.2f, var17, 0.0f);
        if (var6) {
            var21.addPoint(0.4f, var18, 0.0f).addPoint(0.45f, var19, 0.0f).addPoint(0.55f, var19, 0.0f).addPoint(0.58f, var18, 0.0f);
        }
        var21.addPoint(0.7f, var20, 0.0f);
        return var21.build();
    }

    private static CubicSpline<b> ridgeSpline(float var0, float var1, float var2, float var3, float var4, float var5, ToFloatFunction<Float> var6) {
        float var7 = Math.max(0.5f * (var1 - var0), var5);
        float var8 = 5.0f * (var2 - var1);
        return CubicSpline.builder(a.RIDGES, var6).addPoint(-1.0f, var0, var7).addPoint(-0.4f, var1, Math.min(var7, var8)).addPoint(0.0f, var2, var8).addPoint(0.4f, var3, 2.0f * (var3 - var2)).addPoint(1.0f, var4, 0.7f * (var4 - var3)).build();
    }

    public void addDebugBiomesToVisualizeSplinePoints(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0) {
        Float var7;
        int n2;
        Climate.b var1 = Climate.b.span(-1.0f, 1.0f);
        var0.accept((Pair<Climate.d, ResourceKey<BiomeBase>>)Pair.of((Object)Climate.parameters(var1, var1, var1, var1, Climate.b.point(0.0f), var1, 0.01f), Biomes.PLAINS));
        CubicSpline.d var2 = (CubicSpline.d)TerrainShaper.buildErosionOffsetSpline(-0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, NO_TRANSFORM);
        ResourceKey<BiomeBase> var3 = Biomes.DESERT;
        float[] fArray = var2.locations();
        int n3 = fArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            var7 = Float.valueOf(fArray[n2]);
            var0.accept((Pair<Climate.d, ResourceKey<BiomeBase>>)Pair.of((Object)Climate.parameters(var1, var1, var1, Climate.b.point(var7.floatValue()), Climate.b.point(0.0f), var1, 0.0f), var3));
            var3 = var3 == Biomes.DESERT ? Biomes.BADLANDS : Biomes.DESERT;
        }
        fArray = ((CubicSpline.d)this.offsetSampler).locations();
        n3 = fArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            var7 = Float.valueOf(fArray[n2]);
            var0.accept((Pair<Climate.d, ResourceKey<BiomeBase>>)Pair.of((Object)Climate.parameters(var1, var1, Climate.b.point(var7.floatValue()), var1, Climate.b.point(0.0f), var1, 0.0f), Biomes.SNOWY_TAIGA));
        }
    }

    @VisibleForDebug
    public CubicSpline<b> offsetSampler() {
        return this.offsetSampler;
    }

    @VisibleForDebug
    public CubicSpline<b> factorSampler() {
        return this.factorSampler;
    }

    @VisibleForDebug
    public CubicSpline<b> jaggednessSampler() {
        return this.jaggednessSampler;
    }

    public float offset(b var0) {
        return this.offsetSampler.apply(var0) + -0.50375f;
    }

    public float factor(b var0) {
        return this.factorSampler.apply(var0);
    }

    public float jaggedness(b var0) {
        return this.jaggednessSampler.apply(var0);
    }

    public b makePoint(float var0, float var1, float var2) {
        return new b(var0, var1, TerrainShaper.peaksAndValleys(var2), var2);
    }

    public static float peaksAndValleys(float var0) {
        return -(Math.abs(Math.abs(var0) - 0.6666667f) - 0.33333334f) * 3.0f;
    }

    @VisibleForTesting
    protected static final class a
    extends Enum<a>
    implements INamable,
    ToFloatFunction<b> {
        public static final /* enum */ a CONTINENTS = new a(b::continents, "continents");
        public static final /* enum */ a EROSION = new a(b::erosion, "erosion");
        public static final /* enum */ a WEIRDNESS = new a(b::weirdness, "weirdness");
        @Deprecated
        public static final /* enum */ a RIDGES = new a(b::ridges, "ridges");
        private static final Map<String, a> BY_NAME;
        private static final Codec<a> CODEC;
        static final Codec<ToFloatFunction<b>> WIDE_CODEC;
        private final ToFloatFunction<b> reference;
        private final String name;
        private static final /* synthetic */ a[] j;

        public static a[] values() {
            return (a[])j.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(ToFloatFunction var2, String var3) {
            this.reference = var2;
            this.name = var3;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public float apply(b var0) {
            return this.reference.apply(var0);
        }

        @Override
        public /* synthetic */ float apply(Object object) {
            return this.apply((b)object);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{CONTINENTS, EROSION, WEIRDNESS, RIDGES};
        }

        static {
            j = a.a();
            BY_NAME = Arrays.stream(a.values()).collect(Collectors.toMap(a::getSerializedName, var0 -> var0));
            CODEC = INamable.fromEnum(a::values, BY_NAME::get);
            WIDE_CODEC = CODEC.flatComapMap(var0 -> var0, var0 -> {
                DataResult dataResult;
                if (var0 instanceof a) {
                    a var1 = (a)var0;
                    dataResult = DataResult.success((Object)var1);
                } else {
                    dataResult = DataResult.error((String)("Not a coordinate resolver: " + var0));
                }
                return dataResult;
            });
        }
    }

    public record b(float continents, float erosion, float ridges, float weirdness) {
    }
}

