/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TerrainShaper;

public final class OverworldBiomeBuilder {
    private static final float VALLEY_SIZE = 0.05f;
    private static final float LOW_START = 0.26666668f;
    public static final float HIGH_START = 0.4f;
    private static final float HIGH_END = 0.93333334f;
    private static final float PEAK_SIZE = 0.1f;
    public static final float PEAK_START = 0.56666666f;
    private static final float PEAK_END = 0.7666667f;
    public static final float NEAR_INLAND_START = -0.11f;
    public static final float MID_INLAND_START = 0.03f;
    public static final float FAR_INLAND_START = 0.3f;
    public static final float EROSION_INDEX_1_START = -0.78f;
    public static final float EROSION_INDEX_2_START = -0.375f;
    private final Climate.b FULL_RANGE = Climate.b.span(-1.0f, 1.0f);
    private final Climate.b[] temperatures = new Climate.b[]{Climate.b.span(-1.0f, -0.45f), Climate.b.span(-0.45f, -0.15f), Climate.b.span(-0.15f, 0.2f), Climate.b.span(0.2f, 0.55f), Climate.b.span(0.55f, 1.0f)};
    private final Climate.b[] humidities = new Climate.b[]{Climate.b.span(-1.0f, -0.35f), Climate.b.span(-0.35f, -0.1f), Climate.b.span(-0.1f, 0.1f), Climate.b.span(0.1f, 0.3f), Climate.b.span(0.3f, 1.0f)};
    private final Climate.b[] erosions = new Climate.b[]{Climate.b.span(-1.0f, -0.78f), Climate.b.span(-0.78f, -0.375f), Climate.b.span(-0.375f, -0.2225f), Climate.b.span(-0.2225f, 0.05f), Climate.b.span(0.05f, 0.45f), Climate.b.span(0.45f, 0.55f), Climate.b.span(0.55f, 1.0f)};
    private final Climate.b FROZEN_RANGE = this.temperatures[0];
    private final Climate.b UNFROZEN_RANGE = Climate.b.span(this.temperatures[1], this.temperatures[4]);
    private final Climate.b mushroomFieldsContinentalness = Climate.b.span(-1.2f, -1.05f);
    private final Climate.b deepOceanContinentalness = Climate.b.span(-1.05f, -0.455f);
    private final Climate.b oceanContinentalness = Climate.b.span(-0.455f, -0.19f);
    private final Climate.b coastContinentalness = Climate.b.span(-0.19f, -0.11f);
    private final Climate.b inlandContinentalness = Climate.b.span(-0.11f, 0.55f);
    private final Climate.b nearInlandContinentalness = Climate.b.span(-0.11f, 0.03f);
    private final Climate.b midInlandContinentalness = Climate.b.span(0.03f, 0.3f);
    private final Climate.b farInlandContinentalness = Climate.b.span(0.3f, 1.0f);
    private final ResourceKey<BiomeBase>[][] OCEANS = new ResourceKey[][]{{Biomes.DEEP_FROZEN_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.DEEP_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.WARM_OCEAN}, {Biomes.FROZEN_OCEAN, Biomes.COLD_OCEAN, Biomes.OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.WARM_OCEAN}};
    private final ResourceKey<BiomeBase>[][] MIDDLE_BIOMES = new ResourceKey[][]{{Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_TAIGA, Biomes.TAIGA}, {Biomes.PLAINS, Biomes.PLAINS, Biomes.FOREST, Biomes.TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA}, {Biomes.FLOWER_FOREST, Biomes.PLAINS, Biomes.FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST}, {Biomes.SAVANNA, Biomes.SAVANNA, Biomes.FOREST, Biomes.JUNGLE, Biomes.JUNGLE}, {Biomes.DESERT, Biomes.DESERT, Biomes.DESERT, Biomes.DESERT, Biomes.DESERT}};
    private final ResourceKey<BiomeBase>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, Biomes.SNOWY_TAIGA, null, null}, {null, null, null, null, Biomes.OLD_GROWTH_PINE_TAIGA}, {Biomes.SUNFLOWER_PLAINS, null, null, Biomes.OLD_GROWTH_BIRCH_FOREST, null}, {null, null, Biomes.PLAINS, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}, {null, null, null, null, null}};
    private final ResourceKey<BiomeBase>[][] PLATEAU_BIOMES = new ResourceKey[][]{{Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_TAIGA, Biomes.SNOWY_TAIGA}, {Biomes.MEADOW, Biomes.MEADOW, Biomes.FOREST, Biomes.TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA}, {Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.DARK_FOREST}, {Biomes.SAVANNA_PLATEAU, Biomes.SAVANNA_PLATEAU, Biomes.FOREST, Biomes.FOREST, Biomes.JUNGLE}, {Biomes.BADLANDS, Biomes.BADLANDS, Biomes.BADLANDS, Biomes.WOODED_BADLANDS, Biomes.WOODED_BADLANDS}};
    private final ResourceKey<BiomeBase>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, null, null, null}, {null, null, Biomes.MEADOW, Biomes.MEADOW, Biomes.OLD_GROWTH_PINE_TAIGA}, {null, null, Biomes.FOREST, Biomes.BIRCH_FOREST, null}, {null, null, null, null, null}, {Biomes.ERODED_BADLANDS, Biomes.ERODED_BADLANDS, null, null, null}};
    private final ResourceKey<BiomeBase>[][] EXTREME_HILLS = new ResourceKey[][]{{Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {null, null, null, null, null}, {null, null, null, null, null}};

    public List<Climate.d> spawnTarget() {
        Climate.b var0 = Climate.b.point(0.0f);
        float var1 = 0.16f;
        return List.of(new Climate.d(this.FULL_RANGE, this.FULL_RANGE, Climate.b.span(this.inlandContinentalness, this.FULL_RANGE), this.FULL_RANGE, var0, Climate.b.span(-1.0f, -0.16f), 0L), new Climate.d(this.FULL_RANGE, this.FULL_RANGE, Climate.b.span(this.inlandContinentalness, this.FULL_RANGE), this.FULL_RANGE, var0, Climate.b.span(0.16f, 1.0f), 0L));
    }

    protected void addBiomes(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0) {
        if (SharedConstants.debugGenerateSquareTerrainWithoutNoise) {
            TerrainProvider.overworld(false).addDebugBiomesToVisualizeSplinePoints(var0);
            return;
        }
        this.addOffCoastBiomes(var0);
        this.addInlandBiomes(var0);
        this.addUndergroundBiomes(var0);
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0) {
        this.addSurfaceBiome(var0, this.FULL_RANGE, this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, Biomes.MUSHROOM_FIELDS);
        for (int var1 = 0; var1 < this.temperatures.length; ++var1) {
            Climate.b var2 = this.temperatures[var1];
            this.addSurfaceBiome(var0, var2, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[0][var1]);
            this.addSurfaceBiome(var0, var2, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[1][var1]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0) {
        this.addMidSlice(var0, Climate.b.span(-1.0f, -0.93333334f));
        this.addHighSlice(var0, Climate.b.span(-0.93333334f, -0.7666667f));
        this.addPeaks(var0, Climate.b.span(-0.7666667f, -0.56666666f));
        this.addHighSlice(var0, Climate.b.span(-0.56666666f, -0.4f));
        this.addMidSlice(var0, Climate.b.span(-0.4f, -0.26666668f));
        this.addLowSlice(var0, Climate.b.span(-0.26666668f, -0.05f));
        this.addValleys(var0, Climate.b.span(-0.05f, 0.05f));
        this.addLowSlice(var0, Climate.b.span(0.05f, 0.26666668f));
        this.addMidSlice(var0, Climate.b.span(0.26666668f, 0.4f));
        this.addHighSlice(var0, Climate.b.span(0.4f, 0.56666666f));
        this.addPeaks(var0, Climate.b.span(0.56666666f, 0.7666667f));
        this.addHighSlice(var0, Climate.b.span(0.7666667f, 0.93333334f));
        this.addMidSlice(var0, Climate.b.span(0.93333334f, 1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0, Climate.b var1) {
        for (int var2 = 0; var2 < this.temperatures.length; ++var2) {
            Climate.b var3 = this.temperatures[var2];
            for (int var4 = 0; var4 < this.humidities.length; ++var4) {
                Climate.b var5 = this.humidities[var4];
                ResourceKey<BiomeBase> var6 = this.pickMiddleBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var7 = this.pickMiddleBiomeOrBadlandsIfHot(var2, var4, var1);
                ResourceKey<BiomeBase> var8 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(var2, var4, var1);
                ResourceKey<BiomeBase> var9 = this.pickPlateauBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var10 = this.pickExtremeHillsBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var11 = this.maybePickShatteredBiome(var2, var4, var1, var10);
                ResourceKey<BiomeBase> var12 = this.pickPeakBiome(var2, var4, var1);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.farInlandContinentalness), this.erosions[0], var1, 0.0f, var12);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.nearInlandContinentalness), this.erosions[1], var1, 0.0f, var8);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[1], var1, 0.0f, var12);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.nearInlandContinentalness), Climate.b.span(this.erosions[2], this.erosions[3]), var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[2], var1, 0.0f, var9);
                this.addSurfaceBiome(var0, var3, var5, this.midInlandContinentalness, this.erosions[3], var1, 0.0f, var7);
                this.addSurfaceBiome(var0, var3, var5, this.farInlandContinentalness, this.erosions[3], var1, 0.0f, var9);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.farInlandContinentalness), this.erosions[4], var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.nearInlandContinentalness), this.erosions[5], var1, 0.0f, var11);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[5], var1, 0.0f, var10);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.farInlandContinentalness), this.erosions[6], var1, 0.0f, var6);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0, Climate.b var1) {
        for (int var2 = 0; var2 < this.temperatures.length; ++var2) {
            Climate.b var3 = this.temperatures[var2];
            for (int var4 = 0; var4 < this.humidities.length; ++var4) {
                Climate.b var5 = this.humidities[var4];
                ResourceKey<BiomeBase> var6 = this.pickMiddleBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var7 = this.pickMiddleBiomeOrBadlandsIfHot(var2, var4, var1);
                ResourceKey<BiomeBase> var8 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(var2, var4, var1);
                ResourceKey<BiomeBase> var9 = this.pickPlateauBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var10 = this.pickExtremeHillsBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var11 = this.maybePickShatteredBiome(var2, var4, var1, var6);
                ResourceKey<BiomeBase> var12 = this.pickSlopeBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var13 = this.pickPeakBiome(var2, var4, var1);
                this.addSurfaceBiome(var0, var3, var5, this.coastContinentalness, Climate.b.span(this.erosions[0], this.erosions[1]), var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, this.nearInlandContinentalness, this.erosions[0], var1, 0.0f, var12);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[0], var1, 0.0f, var13);
                this.addSurfaceBiome(var0, var3, var5, this.nearInlandContinentalness, this.erosions[1], var1, 0.0f, var8);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[1], var1, 0.0f, var12);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.nearInlandContinentalness), Climate.b.span(this.erosions[2], this.erosions[3]), var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[2], var1, 0.0f, var9);
                this.addSurfaceBiome(var0, var3, var5, this.midInlandContinentalness, this.erosions[3], var1, 0.0f, var7);
                this.addSurfaceBiome(var0, var3, var5, this.farInlandContinentalness, this.erosions[3], var1, 0.0f, var9);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.farInlandContinentalness), this.erosions[4], var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.nearInlandContinentalness), this.erosions[5], var1, 0.0f, var11);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[5], var1, 0.0f, var10);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.farInlandContinentalness), this.erosions[6], var1, 0.0f, var6);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0, Climate.b var1) {
        this.addSurfaceBiome(var0, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.b.span(this.erosions[0], this.erosions[2]), var1, 0.0f, Biomes.STONY_SHORE);
        this.addSurfaceBiome(var0, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.b.span(this.nearInlandContinentalness, this.farInlandContinentalness), this.erosions[6], var1, 0.0f, Biomes.SWAMP);
        for (int var2 = 0; var2 < this.temperatures.length; ++var2) {
            Climate.b var3 = this.temperatures[var2];
            for (int var4 = 0; var4 < this.humidities.length; ++var4) {
                Climate.b var5 = this.humidities[var4];
                ResourceKey<BiomeBase> var6 = this.pickMiddleBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var7 = this.pickMiddleBiomeOrBadlandsIfHot(var2, var4, var1);
                ResourceKey<BiomeBase> var8 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(var2, var4, var1);
                ResourceKey<BiomeBase> var9 = this.pickExtremeHillsBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var10 = this.pickPlateauBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var11 = this.pickBeachBiome(var2, var4);
                ResourceKey<BiomeBase> var12 = this.maybePickShatteredBiome(var2, var4, var1, var6);
                ResourceKey<BiomeBase> var13 = this.pickShatteredCoastBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var14 = this.pickSlopeBiome(var2, var4, var1);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.nearInlandContinentalness, this.farInlandContinentalness), this.erosions[0], var1, 0.0f, var14);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.nearInlandContinentalness, this.midInlandContinentalness), this.erosions[1], var1, 0.0f, var8);
                this.addSurfaceBiome(var0, var3, var5, this.farInlandContinentalness, this.erosions[1], var1, 0.0f, var2 == 0 ? var14 : var10);
                this.addSurfaceBiome(var0, var3, var5, this.nearInlandContinentalness, this.erosions[2], var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, this.midInlandContinentalness, this.erosions[2], var1, 0.0f, var7);
                this.addSurfaceBiome(var0, var3, var5, this.farInlandContinentalness, this.erosions[2], var1, 0.0f, var10);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.nearInlandContinentalness), this.erosions[3], var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[3], var1, 0.0f, var7);
                if (var1.max() < 0L) {
                    this.addSurfaceBiome(var0, var3, var5, this.coastContinentalness, this.erosions[4], var1, 0.0f, var11);
                    this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.nearInlandContinentalness, this.farInlandContinentalness), this.erosions[4], var1, 0.0f, var6);
                } else {
                    this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.coastContinentalness, this.farInlandContinentalness), this.erosions[4], var1, 0.0f, var6);
                }
                this.addSurfaceBiome(var0, var3, var5, this.coastContinentalness, this.erosions[5], var1, 0.0f, var13);
                this.addSurfaceBiome(var0, var3, var5, this.nearInlandContinentalness, this.erosions[5], var1, 0.0f, var12);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[5], var1, 0.0f, var9);
                if (var1.max() < 0L) {
                    this.addSurfaceBiome(var0, var3, var5, this.coastContinentalness, this.erosions[6], var1, 0.0f, var11);
                } else {
                    this.addSurfaceBiome(var0, var3, var5, this.coastContinentalness, this.erosions[6], var1, 0.0f, var6);
                }
                if (var2 != 0) continue;
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.nearInlandContinentalness, this.farInlandContinentalness), this.erosions[6], var1, 0.0f, var6);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0, Climate.b var1) {
        this.addSurfaceBiome(var0, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.b.span(this.erosions[0], this.erosions[2]), var1, 0.0f, Biomes.STONY_SHORE);
        this.addSurfaceBiome(var0, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.b.span(this.nearInlandContinentalness, this.farInlandContinentalness), this.erosions[6], var1, 0.0f, Biomes.SWAMP);
        for (int var2 = 0; var2 < this.temperatures.length; ++var2) {
            Climate.b var3 = this.temperatures[var2];
            for (int var4 = 0; var4 < this.humidities.length; ++var4) {
                Climate.b var5 = this.humidities[var4];
                ResourceKey<BiomeBase> var6 = this.pickMiddleBiome(var2, var4, var1);
                ResourceKey<BiomeBase> var7 = this.pickMiddleBiomeOrBadlandsIfHot(var2, var4, var1);
                ResourceKey<BiomeBase> var8 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(var2, var4, var1);
                ResourceKey<BiomeBase> var9 = this.pickBeachBiome(var2, var4);
                ResourceKey<BiomeBase> var10 = this.maybePickShatteredBiome(var2, var4, var1, var6);
                ResourceKey<BiomeBase> var11 = this.pickShatteredCoastBiome(var2, var4, var1);
                this.addSurfaceBiome(var0, var3, var5, this.nearInlandContinentalness, Climate.b.span(this.erosions[0], this.erosions[1]), var1, 0.0f, var7);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), Climate.b.span(this.erosions[0], this.erosions[1]), var1, 0.0f, var8);
                this.addSurfaceBiome(var0, var3, var5, this.nearInlandContinentalness, Climate.b.span(this.erosions[2], this.erosions[3]), var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), Climate.b.span(this.erosions[2], this.erosions[3]), var1, 0.0f, var7);
                this.addSurfaceBiome(var0, var3, var5, this.coastContinentalness, Climate.b.span(this.erosions[3], this.erosions[4]), var1, 0.0f, var9);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.nearInlandContinentalness, this.farInlandContinentalness), this.erosions[4], var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, this.coastContinentalness, this.erosions[5], var1, 0.0f, var11);
                this.addSurfaceBiome(var0, var3, var5, this.nearInlandContinentalness, this.erosions[5], var1, 0.0f, var10);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), this.erosions[5], var1, 0.0f, var6);
                this.addSurfaceBiome(var0, var3, var5, this.coastContinentalness, this.erosions[6], var1, 0.0f, var9);
                if (var2 != 0) continue;
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.nearInlandContinentalness, this.farInlandContinentalness), this.erosions[6], var1, 0.0f, var6);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0, Climate.b var1) {
        this.addSurfaceBiome(var0, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.b.span(this.erosions[0], this.erosions[1]), var1, 0.0f, var1.max() < 0L ? Biomes.STONY_SHORE : Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(var0, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.b.span(this.erosions[0], this.erosions[1]), var1, 0.0f, var1.max() < 0L ? Biomes.STONY_SHORE : Biomes.RIVER);
        this.addSurfaceBiome(var0, this.FROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.b.span(this.erosions[0], this.erosions[1]), var1, 0.0f, Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(var0, this.UNFROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.b.span(this.erosions[0], this.erosions[1]), var1, 0.0f, Biomes.RIVER);
        this.addSurfaceBiome(var0, this.FROZEN_RANGE, this.FULL_RANGE, Climate.b.span(this.coastContinentalness, this.farInlandContinentalness), Climate.b.span(this.erosions[2], this.erosions[5]), var1, 0.0f, Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(var0, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.b.span(this.coastContinentalness, this.farInlandContinentalness), Climate.b.span(this.erosions[2], this.erosions[5]), var1, 0.0f, Biomes.RIVER);
        this.addSurfaceBiome(var0, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], var1, 0.0f, Biomes.FROZEN_RIVER);
        this.addSurfaceBiome(var0, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], var1, 0.0f, Biomes.RIVER);
        this.addSurfaceBiome(var0, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.b.span(this.inlandContinentalness, this.farInlandContinentalness), this.erosions[6], var1, 0.0f, Biomes.SWAMP);
        this.addSurfaceBiome(var0, this.FROZEN_RANGE, this.FULL_RANGE, Climate.b.span(this.inlandContinentalness, this.farInlandContinentalness), this.erosions[6], var1, 0.0f, Biomes.FROZEN_RIVER);
        for (int var2 = 0; var2 < this.temperatures.length; ++var2) {
            Climate.b var3 = this.temperatures[var2];
            for (int var4 = 0; var4 < this.humidities.length; ++var4) {
                Climate.b var5 = this.humidities[var4];
                ResourceKey<BiomeBase> var6 = this.pickMiddleBiomeOrBadlandsIfHot(var2, var4, var1);
                this.addSurfaceBiome(var0, var3, var5, Climate.b.span(this.midInlandContinentalness, this.farInlandContinentalness), Climate.b.span(this.erosions[0], this.erosions[1]), var1, 0.0f, var6);
            }
        }
    }

    private void addUndergroundBiomes(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0) {
        this.addUndergroundBiome(var0, this.FULL_RANGE, this.FULL_RANGE, Climate.b.span(0.8f, 1.0f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, Biomes.DRIPSTONE_CAVES);
        this.addUndergroundBiome(var0, this.FULL_RANGE, Climate.b.span(0.7f, 1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, 0.0f, Biomes.LUSH_CAVES);
    }

    private ResourceKey<BiomeBase> pickMiddleBiome(int var0, int var1, Climate.b var2) {
        if (var2.max() < 0L) {
            return this.MIDDLE_BIOMES[var0][var1];
        }
        ResourceKey<BiomeBase> var3 = this.MIDDLE_BIOMES_VARIANT[var0][var1];
        return var3 == null ? this.MIDDLE_BIOMES[var0][var1] : var3;
    }

    private ResourceKey<BiomeBase> pickMiddleBiomeOrBadlandsIfHot(int var0, int var1, Climate.b var2) {
        return var0 == 4 ? this.pickBadlandsBiome(var1, var2) : this.pickMiddleBiome(var0, var1, var2);
    }

    private ResourceKey<BiomeBase> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(int var0, int var1, Climate.b var2) {
        return var0 == 0 ? this.pickSlopeBiome(var0, var1, var2) : this.pickMiddleBiomeOrBadlandsIfHot(var0, var1, var2);
    }

    private ResourceKey<BiomeBase> maybePickShatteredBiome(int var0, int var1, Climate.b var2, ResourceKey<BiomeBase> var3) {
        if (var0 > 1 && var1 < 4 && var2.max() >= 0L) {
            return Biomes.WINDSWEPT_SAVANNA;
        }
        return var3;
    }

    private ResourceKey<BiomeBase> pickShatteredCoastBiome(int var0, int var1, Climate.b var2) {
        ResourceKey<BiomeBase> var3 = var2.max() >= 0L ? this.pickMiddleBiome(var0, var1, var2) : this.pickBeachBiome(var0, var1);
        return this.maybePickShatteredBiome(var0, var1, var2, var3);
    }

    private ResourceKey<BiomeBase> pickBeachBiome(int var0, int var1) {
        if (var0 == 0) {
            return Biomes.SNOWY_BEACH;
        }
        if (var0 == 4) {
            return Biomes.DESERT;
        }
        return Biomes.BEACH;
    }

    private ResourceKey<BiomeBase> pickBadlandsBiome(int var0, Climate.b var1) {
        if (var0 < 2) {
            return var1.max() < 0L ? Biomes.ERODED_BADLANDS : Biomes.BADLANDS;
        }
        if (var0 < 3) {
            return Biomes.BADLANDS;
        }
        return Biomes.WOODED_BADLANDS;
    }

    private ResourceKey<BiomeBase> pickPlateauBiome(int var0, int var1, Climate.b var2) {
        if (var2.max() < 0L) {
            return this.PLATEAU_BIOMES[var0][var1];
        }
        ResourceKey<BiomeBase> var3 = this.PLATEAU_BIOMES_VARIANT[var0][var1];
        return var3 == null ? this.PLATEAU_BIOMES[var0][var1] : var3;
    }

    private ResourceKey<BiomeBase> pickPeakBiome(int var0, int var1, Climate.b var2) {
        if (var0 <= 2) {
            return var2.max() < 0L ? Biomes.JAGGED_PEAKS : Biomes.FROZEN_PEAKS;
        }
        if (var0 == 3) {
            return Biomes.STONY_PEAKS;
        }
        return this.pickBadlandsBiome(var1, var2);
    }

    private ResourceKey<BiomeBase> pickSlopeBiome(int var0, int var1, Climate.b var2) {
        if (var0 >= 3) {
            return this.pickPlateauBiome(var0, var1, var2);
        }
        if (var1 <= 1) {
            return Biomes.SNOWY_SLOPES;
        }
        return Biomes.GROVE;
    }

    private ResourceKey<BiomeBase> pickExtremeHillsBiome(int var0, int var1, Climate.b var2) {
        ResourceKey<BiomeBase> var3 = this.EXTREME_HILLS[var0][var1];
        return var3 == null ? this.pickMiddleBiome(var0, var1, var2) : var3;
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0, Climate.b var1, Climate.b var2, Climate.b var3, Climate.b var4, Climate.b var5, float var6, ResourceKey<BiomeBase> var7) {
        var0.accept((Pair<Climate.d, ResourceKey<BiomeBase>>)Pair.of((Object)Climate.parameters(var1, var2, var3, var4, Climate.b.point(0.0f), var5, var6), var7));
        var0.accept((Pair<Climate.d, ResourceKey<BiomeBase>>)Pair.of((Object)Climate.parameters(var1, var2, var3, var4, Climate.b.point(1.0f), var5, var6), var7));
    }

    private void addUndergroundBiome(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> var0, Climate.b var1, Climate.b var2, Climate.b var3, Climate.b var4, Climate.b var5, float var6, ResourceKey<BiomeBase> var7) {
        var0.accept((Pair<Climate.d, ResourceKey<BiomeBase>>)Pair.of((Object)Climate.parameters(var1, var2, var3, var4, Climate.b.span(0.2f, 0.9f), var5, var6), var7));
    }

    public static String getDebugStringForPeaksAndValleys(double var0) {
        if (var0 < (double)TerrainShaper.peaksAndValleys(0.05f)) {
            return "Valley";
        }
        if (var0 < (double)TerrainShaper.peaksAndValleys(0.26666668f)) {
            return "Low";
        }
        if (var0 < (double)TerrainShaper.peaksAndValleys(0.4f)) {
            return "Mid";
        }
        if (var0 < (double)TerrainShaper.peaksAndValleys(0.56666666f)) {
            return "High";
        }
        return "Peak";
    }

    public String getDebugStringForContinentalness(double var0) {
        double var2 = Climate.quantizeCoord((float)var0);
        if (var2 < (double)this.mushroomFieldsContinentalness.max()) {
            return "Mushroom fields";
        }
        if (var2 < (double)this.deepOceanContinentalness.max()) {
            return "Deep ocean";
        }
        if (var2 < (double)this.oceanContinentalness.max()) {
            return "Ocean";
        }
        if (var2 < (double)this.coastContinentalness.max()) {
            return "Coast";
        }
        if (var2 < (double)this.nearInlandContinentalness.max()) {
            return "Near inland";
        }
        if (var2 < (double)this.midInlandContinentalness.max()) {
            return "Mid inland";
        }
        return "Far inland";
    }

    public String getDebugStringForErosion(double var0) {
        return OverworldBiomeBuilder.getDebugStringForNoiseValue(var0, this.erosions);
    }

    public String getDebugStringForTemperature(double var0) {
        return OverworldBiomeBuilder.getDebugStringForNoiseValue(var0, this.temperatures);
    }

    public String getDebugStringForHumidity(double var0) {
        return OverworldBiomeBuilder.getDebugStringForNoiseValue(var0, this.humidities);
    }

    private static String getDebugStringForNoiseValue(double var0, Climate.b[] var2) {
        double var3 = Climate.quantizeCoord((float)var0);
        for (int var5 = 0; var5 < var2.length; ++var5) {
            if (!(var3 < (double)var2[var5].max())) continue;
            return "" + var5;
        }
        return "?";
    }
}

