/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.ITagRegistry;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.scores.Scoreboard;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final Codec<ResourceKey<World>> RESOURCE_KEY_CODEC = MinecraftKey.CODEC.xmap(ResourceKey.elementKey(IRegistry.DIMENSION_REGISTRY), ResourceKey::location);
    public static final ResourceKey<World> OVERWORLD = ResourceKey.create(IRegistry.DIMENSION_REGISTRY, new MinecraftKey("overworld"));
    public static final ResourceKey<World> NETHER = ResourceKey.create(IRegistry.DIMENSION_REGISTRY, new MinecraftKey("the_nether"));
    public static final ResourceKey<World> END = ResourceKey.create(IRegistry.DIMENSION_REGISTRY, new MinecraftKey("the_end"));
    public static final int MAX_LEVEL_SIZE = 30000000;
    public static final int LONG_PARTICLE_CLIP_RANGE = 512;
    public static final int SHORT_PARTICLE_CLIP_RANGE = 32;
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();
    public static final int MAX_BRIGHTNESS = 15;
    public static final int TICKS_PER_DAY = 24000;
    public static final int MAX_ENTITY_SPAWN_Y = 20000000;
    public static final int MIN_ENTITY_SPAWN_Y = -20000000;
    protected final List<TickingBlockEntity> blockEntityTickers = Lists.newArrayList();
    private final List<TickingBlockEntity> pendingBlockEntityTickers = Lists.newArrayList();
    private boolean tickingBlockEntities;
    public final Thread thread;
    private final boolean isDebug;
    private int skyDarken;
    protected int randValue = new Random().nextInt();
    protected final int addend = 1013904223;
    protected float oRainLevel;
    public float rainLevel;
    protected float oThunderLevel;
    public float thunderLevel;
    public final Random random = new Random();
    private final DimensionManager dimensionType;
    public final WorldDataMutable levelData;
    private final Supplier<GameProfilerFiller> profiler;
    public final boolean isClientSide;
    private final WorldBorder worldBorder;
    private final BiomeManager biomeManager;
    private final ResourceKey<World> dimension;
    private long subTickCount;

    protected World(WorldDataMutable var0, ResourceKey<World> var1, final DimensionManager var2, Supplier<GameProfilerFiller> var3, boolean var4, boolean var5, long var6) {
        this.profiler = var3;
        this.levelData = var0;
        this.dimensionType = var2;
        this.dimension = var1;
        this.isClientSide = var4;
        this.worldBorder = var2.coordinateScale() != 1.0 ? new WorldBorder(){

            @Override
            public double getCenterX() {
                return super.getCenterX() / var2.coordinateScale();
            }

            @Override
            public double getCenterZ() {
                return super.getCenterZ() / var2.coordinateScale();
            }
        } : new WorldBorder();
        this.thread = Thread.currentThread();
        this.biomeManager = new BiomeManager(this, var6);
        this.isDebug = var5;
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public boolean isInWorldBounds(BlockPosition var0) {
        return !this.isOutsideBuildHeight(var0) && World.isInWorldBoundsHorizontal(var0);
    }

    public static boolean isInSpawnableBounds(BlockPosition var0) {
        return !World.isOutsideSpawnableHeight(var0.getY()) && World.isInWorldBoundsHorizontal(var0);
    }

    private static boolean isInWorldBoundsHorizontal(BlockPosition var0) {
        return var0.getX() >= -30000000 && var0.getZ() >= -30000000 && var0.getX() < 30000000 && var0.getZ() < 30000000;
    }

    private static boolean isOutsideSpawnableHeight(int var0) {
        return var0 < -20000000 || var0 >= 20000000;
    }

    public Chunk getChunkAt(BlockPosition var0) {
        return this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    @Override
    public Chunk getChunk(int var0, int var1) {
        return (Chunk)this.getChunk(var0, var1, ChunkStatus.FULL);
    }

    @Override
    @Nullable
    public IChunkAccess getChunk(int var0, int var1, ChunkStatus var2, boolean var3) {
        IChunkAccess var4 = this.getChunkSource().getChunk(var0, var1, var2, var3);
        if (var4 == null && var3) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return var4;
    }

    @Override
    public boolean setBlock(BlockPosition var0, IBlockData var1, int var2) {
        return this.setBlock(var0, var1, var2, 512);
    }

    @Override
    public boolean setBlock(BlockPosition var0, IBlockData var1, int var2, int var3) {
        if (this.isOutsideBuildHeight(var0)) {
            return false;
        }
        if (!this.isClientSide && this.isDebug()) {
            return false;
        }
        Chunk var4 = this.getChunkAt(var0);
        Block var5 = var1.getBlock();
        IBlockData var6 = var4.setBlockState(var0, var1, (var2 & 0x40) != 0);
        if (var6 != null) {
            IBlockData var7 = this.getBlockState(var0);
            if ((var2 & 0x80) == 0 && var7 != var6 && (var7.getLightBlock(this, var0) != var6.getLightBlock(this, var0) || var7.getLightEmission() != var6.getLightEmission() || var7.useShapeForLightOcclusion() || var6.useShapeForLightOcclusion())) {
                this.getProfiler().push("queueCheckLight");
                this.getChunkSource().getLightEngine().checkBlock(var0);
                this.getProfiler().pop();
            }
            if (var7 == var1) {
                if (var6 != var7) {
                    this.setBlocksDirty(var0, var6, var7);
                }
                if ((var2 & 2) != 0 && (!this.isClientSide || (var2 & 4) == 0) && (this.isClientSide || var4.getFullStatus() != null && var4.getFullStatus().isOrAfter(PlayerChunk.State.TICKING))) {
                    this.sendBlockUpdated(var0, var6, var1, var2);
                }
                if ((var2 & 1) != 0) {
                    this.blockUpdated(var0, var6.getBlock());
                    if (!this.isClientSide && var1.hasAnalogOutputSignal()) {
                        this.updateNeighbourForOutputSignal(var0, var5);
                    }
                }
                if ((var2 & 0x10) == 0 && var3 > 0) {
                    int var8 = var2 & 0xFFFFFFDE;
                    var6.updateIndirectNeighbourShapes(this, var0, var8, var3 - 1);
                    var1.updateNeighbourShapes(this, var0, var8, var3 - 1);
                    var1.updateIndirectNeighbourShapes(this, var0, var8, var3 - 1);
                }
                this.onBlockStateChange(var0, var6, var7);
            }
            return true;
        }
        return false;
    }

    public void onBlockStateChange(BlockPosition var0, IBlockData var1, IBlockData var2) {
    }

    @Override
    public boolean removeBlock(BlockPosition var0, boolean var1) {
        Fluid var2 = this.getFluidState(var0);
        return this.setBlock(var0, var2.createLegacyBlock(), 3 | (var1 ? 64 : 0));
    }

    @Override
    public boolean destroyBlock(BlockPosition var0, boolean var1, @Nullable Entity var2, int var3) {
        boolean var6;
        IBlockData var4 = this.getBlockState(var0);
        if (var4.isAir()) {
            return false;
        }
        Fluid var5 = this.getFluidState(var0);
        if (!(var4.getBlock() instanceof BlockFireAbstract)) {
            this.levelEvent(2001, var0, Block.getId(var4));
        }
        if (var1) {
            TileEntity var62 = var4.hasBlockEntity() ? this.getBlockEntity(var0) : null;
            Block.dropResources(var4, this, var0, var62, var2, ItemStack.EMPTY);
        }
        if (var6 = this.setBlock(var0, var5.createLegacyBlock(), 3, var3)) {
            this.gameEvent(var2, GameEvent.BLOCK_DESTROY, var0);
        }
        return var6;
    }

    public void addDestroyBlockEffect(BlockPosition var0, IBlockData var1) {
    }

    public boolean setBlockAndUpdate(BlockPosition var0, IBlockData var1) {
        return this.setBlock(var0, var1, 3);
    }

    public abstract void sendBlockUpdated(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void setBlocksDirty(BlockPosition var0, IBlockData var1, IBlockData var2) {
    }

    public void updateNeighborsAt(BlockPosition var0, Block var1) {
        this.neighborChanged(var0.west(), var1, var0);
        this.neighborChanged(var0.east(), var1, var0);
        this.neighborChanged(var0.below(), var1, var0);
        this.neighborChanged(var0.above(), var1, var0);
        this.neighborChanged(var0.north(), var1, var0);
        this.neighborChanged(var0.south(), var1, var0);
    }

    public void updateNeighborsAtExceptFromFacing(BlockPosition var0, Block var1, EnumDirection var2) {
        if (var2 != EnumDirection.WEST) {
            this.neighborChanged(var0.west(), var1, var0);
        }
        if (var2 != EnumDirection.EAST) {
            this.neighborChanged(var0.east(), var1, var0);
        }
        if (var2 != EnumDirection.DOWN) {
            this.neighborChanged(var0.below(), var1, var0);
        }
        if (var2 != EnumDirection.UP) {
            this.neighborChanged(var0.above(), var1, var0);
        }
        if (var2 != EnumDirection.NORTH) {
            this.neighborChanged(var0.north(), var1, var0);
        }
        if (var2 != EnumDirection.SOUTH) {
            this.neighborChanged(var0.south(), var1, var0);
        }
    }

    public void neighborChanged(BlockPosition var0, Block var1, BlockPosition var2) {
        if (this.isClientSide) {
            return;
        }
        IBlockData var3 = this.getBlockState(var0);
        try {
            var3.neighborChanged(this, var0, var1, var2, false);
        }
        catch (Throwable var4) {
            CrashReport var5 = CrashReport.forThrowable(var4, "Exception while updating neighbours");
            CrashReportSystemDetails var6 = var5.addCategory("Block being updated");
            var6.setDetail("Source block type", () -> {
                try {
                    return String.format("ID #%s (%s // %s)", IRegistry.BLOCK.getKey(var1), var1.getDescriptionId(), var1.getClass().getCanonicalName());
                }
                catch (Throwable var1) {
                    return "ID #" + IRegistry.BLOCK.getKey(var1);
                }
            });
            CrashReportSystemDetails.populateBlockDetails(var6, this, var0, var3);
            throw new ReportedException(var5);
        }
    }

    @Override
    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        int var3 = var1 < -30000000 || var2 < -30000000 || var1 >= 30000000 || var2 >= 30000000 ? this.getSeaLevel() + 1 : (this.hasChunk(SectionPosition.blockToSectionCoord(var1), SectionPosition.blockToSectionCoord(var2)) ? this.getChunk(SectionPosition.blockToSectionCoord(var1), SectionPosition.blockToSectionCoord(var2)).getHeight(var0, var1 & 0xF, var2 & 0xF) + 1 : this.getMinBuildHeight());
        return var3;
    }

    @Override
    public LightEngine getLightEngine() {
        return this.getChunkSource().getLightEngine();
    }

    @Override
    public IBlockData getBlockState(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        Chunk var1 = this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
        return var1.getBlockState(var0);
    }

    @Override
    public Fluid getFluidState(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        Chunk var1 = this.getChunkAt(var0);
        return var1.getFluidState(var0);
    }

    public boolean isDay() {
        return !this.dimensionType().hasFixedTime() && this.skyDarken < 4;
    }

    public boolean isNight() {
        return !this.dimensionType().hasFixedTime() && !this.isDay();
    }

    @Override
    public void playSound(@Nullable EntityHuman var0, BlockPosition var1, SoundEffect var2, SoundCategory var3, float var4, float var5) {
        this.playSound(var0, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, var2, var3, var4, var5);
    }

    public abstract void playSound(@Nullable EntityHuman var1, double var2, double var4, double var6, SoundEffect var8, SoundCategory var9, float var10, float var11);

    public abstract void playSound(@Nullable EntityHuman var1, Entity var2, SoundEffect var3, SoundCategory var4, float var5, float var6);

    public void playLocalSound(double var0, double var2, double var4, SoundEffect var6, SoundCategory var7, float var8, float var9, boolean var10) {
    }

    @Override
    public void addParticle(ParticleParam var0, double var1, double var3, double var5, double var7, double var9, double var11) {
    }

    public void addParticle(ParticleParam var0, boolean var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public void addAlwaysVisibleParticle(ParticleParam var0, double var1, double var3, double var5, double var7, double var9, double var11) {
    }

    public void addAlwaysVisibleParticle(ParticleParam var0, boolean var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public float getSunAngle(float var0) {
        float var1 = this.getTimeOfDay(var0);
        return var1 * ((float)Math.PI * 2);
    }

    public void addBlockEntityTicker(TickingBlockEntity var0) {
        (this.tickingBlockEntities ? this.pendingBlockEntityTickers : this.blockEntityTickers).add(var0);
    }

    protected void tickBlockEntities() {
        GameProfilerFiller var0 = this.getProfiler();
        var0.push("blockEntities");
        this.tickingBlockEntities = true;
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
            this.pendingBlockEntityTickers.clear();
        }
        Iterator<TickingBlockEntity> var1 = this.blockEntityTickers.iterator();
        while (var1.hasNext()) {
            TickingBlockEntity var2 = var1.next();
            if (var2.isRemoved()) {
                var1.remove();
                continue;
            }
            if (!this.shouldTickBlocksAt(ChunkCoordIntPair.asLong(var2.getPos()))) continue;
            var2.tick();
        }
        this.tickingBlockEntities = false;
        var0.pop();
    }

    public <T extends Entity> void guardEntityTick(Consumer<T> var0, T var1) {
        try {
            var0.accept(var1);
        }
        catch (Throwable var2) {
            CrashReport var3 = CrashReport.forThrowable(var2, "Ticking entity");
            CrashReportSystemDetails var4 = var3.addCategory("Entity being ticked");
            var1.fillCrashReportCategory(var4);
            throw new ReportedException(var3);
        }
    }

    public boolean shouldTickDeath(Entity var0) {
        return true;
    }

    public boolean shouldTickBlocksAt(long var0) {
        return true;
    }

    public Explosion explode(@Nullable Entity var0, double var1, double var3, double var5, float var7, Explosion.Effect var8) {
        return this.explode(var0, null, null, var1, var3, var5, var7, false, var8);
    }

    public Explosion explode(@Nullable Entity var0, double var1, double var3, double var5, float var7, boolean var8, Explosion.Effect var9) {
        return this.explode(var0, null, null, var1, var3, var5, var7, var8, var9);
    }

    public Explosion explode(@Nullable Entity var0, @Nullable DamageSource var1, @Nullable ExplosionDamageCalculator var2, double var3, double var5, double var7, float var9, boolean var10, Explosion.Effect var11) {
        Explosion var12 = new Explosion(this, var0, var1, var2, var3, var5, var7, var9, var10, var11);
        var12.explode();
        var12.finalizeExplosion(true);
        return var12;
    }

    public abstract String gatherChunkSourceStats();

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return null;
        }
        if (!this.isClientSide && Thread.currentThread() != this.thread) {
            return null;
        }
        return this.getChunkAt(var0).getBlockEntity(var0, Chunk.EnumTileEntityState.IMMEDIATE);
    }

    public void setBlockEntity(TileEntity var0) {
        BlockPosition var1 = var0.getBlockPos();
        if (this.isOutsideBuildHeight(var1)) {
            return;
        }
        this.getChunkAt(var1).addAndRegisterBlockEntity(var0);
    }

    public void removeBlockEntity(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return;
        }
        this.getChunkAt(var0).removeBlockEntity(var0);
    }

    public boolean isLoaded(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return false;
        }
        return this.getChunkSource().hasChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    public boolean loadedAndEntityCanStandOnFace(BlockPosition var0, Entity var1, EnumDirection var2) {
        if (this.isOutsideBuildHeight(var0)) {
            return false;
        }
        IChunkAccess var3 = this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()), ChunkStatus.FULL, false);
        if (var3 == null) {
            return false;
        }
        return var3.getBlockState(var0).entityCanStandOnFace(this, var0, var1, var2);
    }

    public boolean loadedAndEntityCanStandOn(BlockPosition var0, Entity var1) {
        return this.loadedAndEntityCanStandOnFace(var0, var1, EnumDirection.UP);
    }

    public void updateSkyBrightness() {
        double var0 = 1.0 - (double)(this.getRainLevel(1.0f) * 5.0f) / 16.0;
        double var2 = 1.0 - (double)(this.getThunderLevel(1.0f) * 5.0f) / 16.0;
        double var4 = 0.5 + 2.0 * MathHelper.clamp((double)MathHelper.cos(this.getTimeOfDay(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.skyDarken = (int)((1.0 - var4 * var0 * var2) * 11.0);
    }

    public void setSpawnSettings(boolean var0, boolean var1) {
        this.getChunkSource().setSpawnSettings(var0, var1);
    }

    protected void prepareWeather() {
        if (this.levelData.isRaining()) {
            this.rainLevel = 1.0f;
            if (this.levelData.isThundering()) {
                this.thunderLevel = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getChunkSource().close();
    }

    @Override
    @Nullable
    public IBlockAccess getChunkForCollisions(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.FULL, false);
    }

    @Override
    public List<Entity> getEntities(@Nullable Entity var0, AxisAlignedBB var1, Predicate<? super Entity> var2) {
        this.getProfiler().incrementCounter("getEntities");
        ArrayList var32 = Lists.newArrayList();
        this.getEntities().get(var1, var3 -> {
            if (var3 != var0 && var2.test((Entity)var3)) {
                var32.add(var3);
            }
            if (var3 instanceof EntityEnderDragon) {
                for (EntityComplexPart var7 : ((EntityEnderDragon)var3).getSubEntities()) {
                    if (var3 == var0 || !var2.test(var7)) continue;
                    var32.add(var7);
                }
            }
        });
        return var32;
    }

    @Override
    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var0, AxisAlignedBB var1, Predicate<? super T> var2) {
        this.getProfiler().incrementCounter("getEntities");
        ArrayList var32 = Lists.newArrayList();
        this.getEntities().get(var0, var1, var3 -> {
            if (var2.test(var3)) {
                var32.add(var3);
            }
            if (var3 instanceof EntityEnderDragon) {
                EntityEnderDragon var4 = (EntityEnderDragon)var3;
                for (EntityComplexPart var8 : var4.getSubEntities()) {
                    Entity var9 = (Entity)var0.tryCast(var8);
                    if (var9 == null || !var2.test(var9)) continue;
                    var32.add(var9);
                }
            }
        });
        return var32;
    }

    @Nullable
    public abstract Entity getEntity(int var1);

    public void blockEntityChanged(BlockPosition var0) {
        if (this.hasChunkAt(var0)) {
            this.getChunkAt(var0).setUnsaved(true);
        }
    }

    @Override
    public int getSeaLevel() {
        return 63;
    }

    public int getDirectSignalTo(BlockPosition var0) {
        int var1 = 0;
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.below(), EnumDirection.DOWN))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.above(), EnumDirection.UP))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.north(), EnumDirection.NORTH))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.south(), EnumDirection.SOUTH))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.west(), EnumDirection.WEST))) >= 15) {
            return var1;
        }
        if ((var1 = Math.max(var1, this.getDirectSignal(var0.east(), EnumDirection.EAST))) >= 15) {
            return var1;
        }
        return var1;
    }

    public boolean hasSignal(BlockPosition var0, EnumDirection var1) {
        return this.getSignal(var0, var1) > 0;
    }

    public int getSignal(BlockPosition var0, EnumDirection var1) {
        IBlockData var2 = this.getBlockState(var0);
        int var3 = var2.getSignal(this, var0, var1);
        if (var2.isRedstoneConductor(this, var0)) {
            return Math.max(var3, this.getDirectSignalTo(var0));
        }
        return var3;
    }

    public boolean hasNeighborSignal(BlockPosition var0) {
        if (this.getSignal(var0.below(), EnumDirection.DOWN) > 0) {
            return true;
        }
        if (this.getSignal(var0.above(), EnumDirection.UP) > 0) {
            return true;
        }
        if (this.getSignal(var0.north(), EnumDirection.NORTH) > 0) {
            return true;
        }
        if (this.getSignal(var0.south(), EnumDirection.SOUTH) > 0) {
            return true;
        }
        if (this.getSignal(var0.west(), EnumDirection.WEST) > 0) {
            return true;
        }
        return this.getSignal(var0.east(), EnumDirection.EAST) > 0;
    }

    public int getBestNeighborSignal(BlockPosition var0) {
        int var1 = 0;
        for (EnumDirection var5 : DIRECTIONS) {
            int var6 = this.getSignal(var0.relative(var5), var5);
            if (var6 >= 15) {
                return 15;
            }
            if (var6 <= var1) continue;
            var1 = var6;
        }
        return var1;
    }

    public void disconnect() {
    }

    public long getGameTime() {
        return this.levelData.getGameTime();
    }

    public long getDayTime() {
        return this.levelData.getDayTime();
    }

    public boolean mayInteract(EntityHuman var0, BlockPosition var1) {
        return true;
    }

    public void broadcastEntityEvent(Entity var0, byte var1) {
    }

    public void blockEvent(BlockPosition var0, Block var1, int var2, int var3) {
        this.getBlockState(var0).triggerEvent(this, var0, var2, var3);
    }

    @Override
    public WorldData getLevelData() {
        return this.levelData;
    }

    public GameRules getGameRules() {
        return this.levelData.getGameRules();
    }

    public float getThunderLevel(float var0) {
        return MathHelper.lerp(var0, this.oThunderLevel, this.thunderLevel) * this.getRainLevel(var0);
    }

    public void setThunderLevel(float var0) {
        float var1;
        this.oThunderLevel = var1 = MathHelper.clamp(var0, 0.0f, 1.0f);
        this.thunderLevel = var1;
    }

    public float getRainLevel(float var0) {
        return MathHelper.lerp(var0, this.oRainLevel, this.rainLevel);
    }

    public void setRainLevel(float var0) {
        float var1;
        this.oRainLevel = var1 = MathHelper.clamp(var0, 0.0f, 1.0f);
        this.rainLevel = var1;
    }

    public boolean isThundering() {
        if (!this.dimensionType().hasSkyLight() || this.dimensionType().hasCeiling()) {
            return false;
        }
        return (double)this.getThunderLevel(1.0f) > 0.9;
    }

    public boolean isRaining() {
        return (double)this.getRainLevel(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPosition var0) {
        if (!this.isRaining()) {
            return false;
        }
        if (!this.canSeeSky(var0)) {
            return false;
        }
        if (this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, var0).getY() > var0.getY()) {
            return false;
        }
        BiomeBase var1 = this.getBiome(var0);
        return var1.getPrecipitation() == BiomeBase.Precipitation.RAIN && var1.warmEnoughToRain(var0);
    }

    public boolean isHumidAt(BlockPosition var0) {
        BiomeBase var1 = this.getBiome(var0);
        return var1.isHumid();
    }

    @Nullable
    public abstract WorldMap getMapData(String var1);

    public abstract void setMapData(String var1, WorldMap var2);

    public abstract int getFreeMapId();

    public void globalLevelEvent(int var0, BlockPosition var1, int var2) {
    }

    public CrashReportSystemDetails fillReportDetails(CrashReport var0) {
        CrashReportSystemDetails var1 = var0.addCategory("Affected level", 1);
        var1.setDetail("All players", () -> this.players().size() + " total; " + this.players());
        var1.setDetail("Chunk stats", this.getChunkSource()::gatherStats);
        var1.setDetail("Level dimension", () -> this.dimension().location().toString());
        try {
            this.levelData.fillCrashReportCategory(var1, this);
        }
        catch (Throwable var2) {
            var1.setDetailError("Level Data Unobtainable", var2);
        }
        return var1;
    }

    public abstract void destroyBlockProgress(int var1, BlockPosition var2, int var3);

    public void createFireworks(double var0, double var2, double var4, double var6, double var8, double var10, @Nullable NBTTagCompound var12) {
    }

    public abstract Scoreboard getScoreboard();

    public void updateNeighbourForOutputSignal(BlockPosition var0, Block var1) {
        for (EnumDirection var3 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var4 = var0.relative(var3);
            if (!this.hasChunkAt(var4)) continue;
            IBlockData var5 = this.getBlockState(var4);
            if (var5.is(Blocks.COMPARATOR)) {
                var5.neighborChanged(this, var4, var1, var0, false);
                continue;
            }
            if (!var5.isRedstoneConductor(this, var4) || !(var5 = this.getBlockState(var4 = var4.relative(var3))).is(Blocks.COMPARATOR)) continue;
            var5.neighborChanged(this, var4, var1, var0, false);
        }
    }

    @Override
    public DifficultyDamageScaler getCurrentDifficultyAt(BlockPosition var0) {
        long var1 = 0L;
        float var3 = 0.0f;
        if (this.hasChunkAt(var0)) {
            var3 = this.getMoonBrightness();
            var1 = this.getChunkAt(var0).getInhabitedTime();
        }
        return new DifficultyDamageScaler(this.getDifficulty(), this.getDayTime(), var1, var3);
    }

    @Override
    public int getSkyDarken() {
        return this.skyDarken;
    }

    public void setSkyFlashTime(int var0) {
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public void sendPacketToServer(Packet<?> var0) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager dimensionType() {
        return this.dimensionType;
    }

    public ResourceKey<World> dimension() {
        return this.dimension;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public boolean isStateAtPosition(BlockPosition var0, Predicate<IBlockData> var1) {
        return var1.test(this.getBlockState(var0));
    }

    @Override
    public boolean isFluidAtPosition(BlockPosition var0, Predicate<Fluid> var1) {
        return var1.test(this.getFluidState(var0));
    }

    public abstract CraftingManager getRecipeManager();

    public abstract ITagRegistry getTagManager();

    public BlockPosition getBlockRandomPos(int var0, int var1, int var2, int var3) {
        this.randValue = this.randValue * 3 + 1013904223;
        int var4 = this.randValue >> 2;
        return new BlockPosition(var0 + (var4 & 0xF), var1 + (var4 >> 16 & var3), var2 + (var4 >> 8 & 0xF));
    }

    public boolean noSave() {
        return false;
    }

    public GameProfilerFiller getProfiler() {
        return this.profiler.get();
    }

    public Supplier<GameProfilerFiller> getProfilerSupplier() {
        return this.profiler;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public abstract LevelEntityGetter<Entity> getEntities();

    protected void postGameEventInRadius(@Nullable Entity var0, GameEvent var1, BlockPosition var2, int var3) {
        int var4 = SectionPosition.blockToSectionCoord(var2.getX() - var3);
        int var5 = SectionPosition.blockToSectionCoord(var2.getZ() - var3);
        int var6 = SectionPosition.blockToSectionCoord(var2.getX() + var3);
        int var7 = SectionPosition.blockToSectionCoord(var2.getZ() + var3);
        int var8 = SectionPosition.blockToSectionCoord(var2.getY() - var3);
        int var9 = SectionPosition.blockToSectionCoord(var2.getY() + var3);
        for (int var10 = var4; var10 <= var6; ++var10) {
            for (int var11 = var5; var11 <= var7; ++var11) {
                Chunk var12 = this.getChunkSource().getChunkNow(var10, var11);
                if (var12 == null) continue;
                for (int var13 = var8; var13 <= var9; ++var13) {
                    ((IChunkAccess)var12).getEventDispatcher(var13).post(var1, var0, var2);
                }
            }
        }
    }

    @Override
    public long nextSubTickCount() {
        return this.subTickCount++;
    }

    public boolean shouldDelayFallingBlockEntityRemoval(Entity.RemovalReason var0) {
        return false;
    }

    @Override
    public /* synthetic */ IChunkAccess getChunk(int n2, int n3) {
        return this.getChunk(n2, n3);
    }
}

