/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreatureProbabilities;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenNether;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SpawnerCreature {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MIN_SPAWN_DISTANCE = 24;
    public static final int SPAWN_DISTANCE_CHUNK = 8;
    public static final int SPAWN_DISTANCE_BLOCK = 128;
    static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    private static final EnumCreatureType[] SPAWNING_CATEGORIES = (EnumCreatureType[])Stream.of(EnumCreatureType.values()).filter(var0 -> var0 != EnumCreatureType.MISC).toArray(EnumCreatureType[]::new);

    private SpawnerCreature() {
    }

    public static d createState(int var0, Iterable<Entity> var1, b var2, LocalMobCapCalculator var3) {
        SpawnerCreatureProbabilities var4 = new SpawnerCreatureProbabilities();
        Object2IntOpenHashMap var5 = new Object2IntOpenHashMap();
        for (Entity var7 : var1) {
            Object var8;
            if (var7 instanceof EntityInsentient && (((EntityInsentient)(var8 = (EntityInsentient)var7)).isPersistenceRequired() || ((EntityInsentient)var8).requiresCustomPersistence()) || (var8 = var7.getType().getCategory()) == EnumCreatureType.MISC) continue;
            BlockPosition var9 = var7.blockPosition();
            var2.query(ChunkCoordIntPair.asLong(var9), arg_0 -> SpawnerCreature.a(var9, var7, var4, var3, (EnumCreatureType)var8, var5, arg_0));
        }
        return new d(var0, (Object2IntOpenHashMap<EnumCreatureType>)var5, var4, var3);
    }

    static BiomeBase getRoughBiome(BlockPosition var0, IChunkAccess var1) {
        return var1.getNoiseBiome(QuartPos.fromBlock(var0.getX()), QuartPos.fromBlock(var0.getY()), QuartPos.fromBlock(var0.getZ()));
    }

    public static void spawnForChunk(WorldServer var0, Chunk var1, d var2, boolean var3, boolean var4, boolean var5) {
        var0.getProfiler().push("spawner");
        for (EnumCreatureType var9 : SPAWNING_CATEGORIES) {
            if (!var3 && var9.isFriendly() || !var4 && !var9.isFriendly() || !var5 && var9.isPersistent() || !var2.canSpawnForCategory(var9, var1.getPos())) continue;
            SpawnerCreature.spawnCategoryForChunk(var9, var0, var1, var2::canSpawn, var2::afterSpawn);
        }
        var0.getProfiler().pop();
    }

    public static void spawnCategoryForChunk(EnumCreatureType var0, WorldServer var1, Chunk var2, c var3, a var4) {
        BlockPosition var5 = SpawnerCreature.getRandomPosWithin(var1, var2);
        if (var5.getY() < var1.getMinBuildHeight() + 1) {
            return;
        }
        SpawnerCreature.spawnCategoryForPosition(var0, var1, var2, var5, var3, var4);
    }

    @VisibleForDebug
    public static void spawnCategoryForPosition(EnumCreatureType var02, WorldServer var12, BlockPosition var22) {
        SpawnerCreature.spawnCategoryForPosition(var02, var12, var12.getChunk(var22), var22, (var0, var1, var2) -> true, (var0, var1) -> {});
    }

    public static void spawnCategoryForPosition(EnumCreatureType var0, WorldServer var1, IChunkAccess var2, BlockPosition var3, c var4, a var5) {
        StructureManager var6 = var1.structureFeatureManager();
        ChunkGenerator var7 = var1.getChunkSource().getGenerator();
        int var8 = var3.getY();
        IBlockData var9 = var2.getBlockState(var3);
        if (var9.isRedstoneConductor(var2, var3)) {
            return;
        }
        BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
        int var11 = 0;
        block0: for (int var12 = 0; var12 < 3; ++var12) {
            int var13 = var3.getX();
            int var14 = var3.getZ();
            int var15 = 6;
            BiomeSettingsMobs.c var16 = null;
            GroupDataEntity var17 = null;
            int var18 = MathHelper.ceil(var1.random.nextFloat() * 4.0f);
            int var19 = 0;
            for (int var20 = 0; var20 < var18; ++var20) {
                Object var28;
                double var26;
                var10.set(var13 += var1.random.nextInt(6) - var1.random.nextInt(6), var8, var14 += var1.random.nextInt(6) - var1.random.nextInt(6));
                double var21 = (double)var13 + 0.5;
                double var23 = (double)var14 + 0.5;
                EntityHuman var25 = var1.getNearestPlayer(var21, (double)var8, var23, -1.0, false);
                if (var25 == null || !SpawnerCreature.isRightDistanceToPlayerAndSpawnPoint(var1, var2, var10, var26 = var25.distanceToSqr(var21, var8, var23))) continue;
                if (var16 == null) {
                    var28 = SpawnerCreature.getRandomSpawnMobAt(var1, var6, var7, var0, var1.random, var10);
                    if (((Optional)var28).isEmpty()) continue block0;
                    var16 = ((Optional)var28).get();
                    var18 = var16.minCount + var1.random.nextInt(1 + var16.maxCount - var16.minCount);
                }
                if (!SpawnerCreature.isValidSpawnPostitionForType(var1, var0, var6, var7, var16, var10, var26) || !var4.test(var16.type, var10, var2)) continue;
                var28 = SpawnerCreature.getMobForSpawn(var1, var16.type);
                if (var28 == null) {
                    return;
                }
                ((Entity)var28).moveTo(var21, var8, var23, var1.random.nextFloat() * 360.0f, 0.0f);
                if (!SpawnerCreature.isValidPositionForMob(var1, (EntityInsentient)var28, var26)) continue;
                var17 = ((EntityInsentient)var28).finalizeSpawn(var1, var1.getCurrentDifficultyAt(((Entity)var28).blockPosition()), EnumMobSpawn.NATURAL, var17, null);
                ++var19;
                var1.addFreshEntityWithPassengers((Entity)var28);
                var5.run((EntityInsentient)var28, var2);
                if (++var11 >= ((EntityInsentient)var28).getMaxSpawnClusterSize()) {
                    return;
                }
                if (((EntityInsentient)var28).isMaxGroupSizeReached(var19)) continue block0;
            }
        }
    }

    private static boolean isRightDistanceToPlayerAndSpawnPoint(WorldServer var0, IChunkAccess var1, BlockPosition.MutableBlockPosition var2, double var3) {
        if (var3 <= 576.0) {
            return false;
        }
        if (var0.getSharedSpawnPos().closerThan(new Vec3D((double)var2.getX() + 0.5, var2.getY(), (double)var2.getZ() + 0.5), 24.0)) {
            return false;
        }
        return Objects.equals(new ChunkCoordIntPair(var2), var1.getPos()) || var0.isPositionEntityTicking(var2);
    }

    private static boolean isValidSpawnPostitionForType(WorldServer var0, EnumCreatureType var1, StructureManager var2, ChunkGenerator var3, BiomeSettingsMobs.c var4, BlockPosition.MutableBlockPosition var5, double var6) {
        EntityTypes<?> var8 = var4.type;
        if (var8.getCategory() == EnumCreatureType.MISC) {
            return false;
        }
        if (!var8.canSpawnFarFromPlayer() && var6 > (double)(var8.getCategory().getDespawnDistance() * var8.getCategory().getDespawnDistance())) {
            return false;
        }
        if (!var8.canSummon() || !SpawnerCreature.canSpawnMobAt(var0, var2, var3, var1, var4, var5)) {
            return false;
        }
        EntityPositionTypes.Surface var9 = EntityPositionTypes.getPlacementType(var8);
        if (!SpawnerCreature.isSpawnPositionOk(var9, var0, var5, var8)) {
            return false;
        }
        if (!EntityPositionTypes.checkSpawnRules(var8, var0, EnumMobSpawn.NATURAL, var5, var0.random)) {
            return false;
        }
        return var0.noCollision(var8.getAABB((double)var5.getX() + 0.5, var5.getY(), (double)var5.getZ() + 0.5));
    }

    @Nullable
    private static EntityInsentient getMobForSpawn(WorldServer var0, EntityTypes<?> var1) {
        EntityInsentient var2;
        try {
            Object var3 = var1.create(var0);
            if (!(var3 instanceof EntityInsentient)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + IRegistry.ENTITY_TYPE.getKey(var1));
            }
            var2 = (EntityInsentient)var3;
        }
        catch (Exception var3) {
            LOGGER.warn("Failed to create mob", (Throwable)var3);
            return null;
        }
        return var2;
    }

    private static boolean isValidPositionForMob(WorldServer var0, EntityInsentient var1, double var2) {
        if (var2 > (double)(var1.getType().getCategory().getDespawnDistance() * var1.getType().getCategory().getDespawnDistance()) && var1.removeWhenFarAway(var2)) {
            return false;
        }
        return var1.checkSpawnRules(var0, EnumMobSpawn.NATURAL) && var1.checkSpawnObstruction(var0);
    }

    private static Optional<BiomeSettingsMobs.c> getRandomSpawnMobAt(WorldServer var0, StructureManager var1, ChunkGenerator var2, EnumCreatureType var3, Random var4, BlockPosition var5) {
        BiomeBase var6 = var0.getBiome(var5);
        if (var3 == EnumCreatureType.WATER_AMBIENT && var6.getBiomeCategory() == BiomeBase.Geography.RIVER && var4.nextFloat() < 0.98f) {
            return Optional.empty();
        }
        return SpawnerCreature.mobsAt(var0, var1, var2, var3, var5, var6).getRandom(var4);
    }

    private static boolean canSpawnMobAt(WorldServer var0, StructureManager var1, ChunkGenerator var2, EnumCreatureType var3, BiomeSettingsMobs.c var4, BlockPosition var5) {
        return SpawnerCreature.mobsAt(var0, var1, var2, var3, var5, null).unwrap().contains(var4);
    }

    private static WeightedRandomList<BiomeSettingsMobs.c> mobsAt(WorldServer var0, StructureManager var1, ChunkGenerator var2, EnumCreatureType var3, BlockPosition var4, @Nullable BiomeBase var5) {
        if (SpawnerCreature.isInNetherFortressBounds(var4, var0, var3, var1)) {
            return WorldGenNether.FORTRESS_ENEMIES;
        }
        return var2.getMobsAt(var5 != null ? var5 : var0.getBiome(var4), var1, var3, var4);
    }

    public static boolean isInNetherFortressBounds(BlockPosition var0, WorldServer var1, EnumCreatureType var2, StructureManager var3) {
        return var2 == EnumCreatureType.MONSTER && var1.getBlockState(var0.below()).is(Blocks.NETHER_BRICKS) && var3.getStructureAt(var0, StructureGenerator.NETHER_BRIDGE).isValid();
    }

    private static BlockPosition getRandomPosWithin(World var0, Chunk var1) {
        ChunkCoordIntPair var2 = var1.getPos();
        int var3 = var2.getMinBlockX() + var0.random.nextInt(16);
        int var4 = var2.getMinBlockZ() + var0.random.nextInt(16);
        int var5 = var1.getHeight(HeightMap.Type.WORLD_SURFACE, var3, var4) + 1;
        int var6 = MathHelper.randomBetweenInclusive(var0.random, var0.getMinBuildHeight(), var5);
        return new BlockPosition(var3, var6, var4);
    }

    public static boolean isValidEmptySpawnBlock(IBlockAccess var0, BlockPosition var1, IBlockData var2, Fluid var3, EntityTypes<?> var4) {
        if (var2.isCollisionShapeFullBlock(var0, var1)) {
            return false;
        }
        if (var2.isSignalSource()) {
            return false;
        }
        if (!var3.isEmpty()) {
            return false;
        }
        if (var2.is(TagsBlock.PREVENT_MOB_SPAWNING_INSIDE)) {
            return false;
        }
        return !var4.isBlockDangerous(var2);
    }

    public static boolean isSpawnPositionOk(EntityPositionTypes.Surface var0, IWorldReader var1, BlockPosition var2, @Nullable EntityTypes<?> var3) {
        if (var0 == EntityPositionTypes.Surface.NO_RESTRICTIONS) {
            return true;
        }
        if (var3 == null || !var1.getWorldBorder().isWithinBounds(var2)) {
            return false;
        }
        IBlockData var4 = var1.getBlockState(var2);
        Fluid var5 = var1.getFluidState(var2);
        BlockPosition var6 = var2.above();
        BlockPosition var7 = var2.below();
        switch (var0) {
            case IN_WATER: {
                return var5.is(TagsFluid.WATER) && !var1.getBlockState(var6).isRedstoneConductor(var1, var6);
            }
            case IN_LAVA: {
                return var5.is(TagsFluid.LAVA);
            }
        }
        IBlockData var8 = var1.getBlockState(var7);
        if (!var8.isValidSpawn(var1, var7, var3)) {
            return false;
        }
        return SpawnerCreature.isValidEmptySpawnBlock(var1, var2, var4, var5, var3) && SpawnerCreature.isValidEmptySpawnBlock(var1, var6, var1.getBlockState(var6), var1.getFluidState(var6), var3);
    }

    public static void spawnMobsForChunkGeneration(WorldAccess var0, BiomeBase var1, ChunkCoordIntPair var2, Random var3) {
        BiomeSettingsMobs var4 = var1.getMobSettings();
        WeightedRandomList<BiomeSettingsMobs.c> var5 = var4.getMobs(EnumCreatureType.CREATURE);
        if (var5.isEmpty()) {
            return;
        }
        int var6 = var2.getMinBlockX();
        int var7 = var2.getMinBlockZ();
        while (var3.nextFloat() < var4.getCreatureProbability()) {
            Optional<BiomeSettingsMobs.c> var8 = var5.getRandom(var3);
            if (!var8.isPresent()) continue;
            BiomeSettingsMobs.c var9 = var8.get();
            int var10 = var9.minCount + var3.nextInt(1 + var9.maxCount - var9.minCount);
            GroupDataEntity var11 = null;
            int var12 = var6 + var3.nextInt(16);
            int var13 = var7 + var3.nextInt(16);
            int var14 = var12;
            int var15 = var13;
            for (int var16 = 0; var16 < var10; ++var16) {
                boolean var17 = false;
                for (int var18 = 0; !var17 && var18 < 4; ++var18) {
                    BlockPosition var19 = SpawnerCreature.getTopNonCollidingPos(var0, var9.type, var12, var13);
                    if (var9.type.canSummon() && SpawnerCreature.isSpawnPositionOk(EntityPositionTypes.getPlacementType(var9.type), var0, var19, var9.type)) {
                        Object var25;
                        float var20 = var9.type.getWidth();
                        double var21 = MathHelper.clamp((double)var12, (double)var6 + (double)var20, (double)var6 + 16.0 - (double)var20);
                        double var23 = MathHelper.clamp((double)var13, (double)var7 + (double)var20, (double)var7 + 16.0 - (double)var20);
                        if (!var0.noCollision(var9.type.getAABB(var21, var19.getY(), var23)) || !EntityPositionTypes.checkSpawnRules(var9.type, var0, EnumMobSpawn.CHUNK_GENERATION, new BlockPosition(var21, (double)var19.getY(), var23), var0.getRandom())) continue;
                        try {
                            var25 = var9.type.create(var0.getLevel());
                        }
                        catch (Exception var26) {
                            LOGGER.warn("Failed to create mob", (Throwable)var26);
                            continue;
                        }
                        ((Entity)var25).moveTo(var21, var19.getY(), var23, var3.nextFloat() * 360.0f, 0.0f);
                        if (var25 instanceof EntityInsentient && (var26 = (EntityInsentient)var25).checkSpawnRules(var0, EnumMobSpawn.CHUNK_GENERATION) && var26.checkSpawnObstruction(var0)) {
                            var11 = var26.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var26.blockPosition()), EnumMobSpawn.CHUNK_GENERATION, var11, null);
                            var0.addFreshEntityWithPassengers(var26);
                            var17 = true;
                        }
                    }
                    var12 += var3.nextInt(5) - var3.nextInt(5);
                    var13 += var3.nextInt(5) - var3.nextInt(5);
                    while (var12 < var6 || var12 >= var6 + 16 || var13 < var7 || var13 >= var7 + 16) {
                        var12 = var14 + var3.nextInt(5) - var3.nextInt(5);
                        var13 = var15 + var3.nextInt(5) - var3.nextInt(5);
                    }
                }
            }
        }
    }

    private static BlockPosition getTopNonCollidingPos(IWorldReader var0, EntityTypes<?> var1, int var2, int var3) {
        BaseBlockPosition var6;
        int var4 = var0.getHeight(EntityPositionTypes.getHeightmapType(var1), var2, var3);
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition(var2, var4, var3);
        if (var0.dimensionType().hasCeiling()) {
            do {
                var5.move(EnumDirection.DOWN);
            } while (!var0.getBlockState(var5).isAir());
            do {
                var5.move(EnumDirection.DOWN);
            } while (var0.getBlockState(var5).isAir() && var5.getY() > var0.getMinBuildHeight());
        }
        if (EntityPositionTypes.getPlacementType(var1) == EntityPositionTypes.Surface.ON_GROUND && var0.getBlockState((BlockPosition)(var6 = var5.below())).isPathfindable(var0, (BlockPosition)var6, PathMode.LAND)) {
            return var6;
        }
        return var5.immutable();
    }

    private static /* synthetic */ void a(BlockPosition var0, Entity var1, SpawnerCreatureProbabilities var2, LocalMobCapCalculator var3, EnumCreatureType var4, Object2IntOpenHashMap var5, Chunk var6) {
        BiomeSettingsMobs.b var7 = SpawnerCreature.getRoughBiome(var0, var6).getMobSettings().getMobSpawnCost(var1.getType());
        if (var7 != null) {
            var2.addCharge(var1.blockPosition(), var7.getCharge());
        }
        if (var1 instanceof EntityInsentient) {
            var3.addMob(var6.getPos(), var4);
        }
        var5.addTo((Object)var4, 1);
    }

    @FunctionalInterface
    public static interface b {
        public void query(long var1, Consumer<Chunk> var3);
    }

    public static class d {
        private final int spawnableChunkCount;
        private final Object2IntOpenHashMap<EnumCreatureType> mobCategoryCounts;
        private final SpawnerCreatureProbabilities spawnPotential;
        private final Object2IntMap<EnumCreatureType> unmodifiableMobCategoryCounts;
        private final LocalMobCapCalculator localMobCapCalculator;
        @Nullable
        private BlockPosition lastCheckedPos;
        @Nullable
        private EntityTypes<?> lastCheckedType;
        private double lastCharge;

        d(int var0, Object2IntOpenHashMap<EnumCreatureType> var1, SpawnerCreatureProbabilities var2, LocalMobCapCalculator var3) {
            this.spawnableChunkCount = var0;
            this.mobCategoryCounts = var1;
            this.spawnPotential = var2;
            this.localMobCapCalculator = var3;
            this.unmodifiableMobCategoryCounts = Object2IntMaps.unmodifiable(var1);
        }

        private boolean canSpawn(EntityTypes<?> var0, BlockPosition var1, IChunkAccess var2) {
            double var4;
            this.lastCheckedPos = var1;
            this.lastCheckedType = var0;
            BiomeSettingsMobs.b var3 = SpawnerCreature.getRoughBiome(var1, var2).getMobSettings().getMobSpawnCost(var0);
            if (var3 == null) {
                this.lastCharge = 0.0;
                return true;
            }
            this.lastCharge = var4 = var3.getCharge();
            double var6 = this.spawnPotential.getPotentialEnergyChange(var1, var4);
            return var6 <= var3.getEnergyBudget();
        }

        private void afterSpawn(EntityInsentient var0, IChunkAccess var1) {
            Object var6;
            EntityTypes<?> var2 = var0.getType();
            BlockPosition var5 = var0.blockPosition();
            double var3 = var5.equals(this.lastCheckedPos) && var2 == this.lastCheckedType ? this.lastCharge : ((var6 = SpawnerCreature.getRoughBiome(var5, var1).getMobSettings().getMobSpawnCost(var2)) != null ? ((BiomeSettingsMobs.b)var6).getCharge() : 0.0);
            this.spawnPotential.addCharge(var5, var3);
            var6 = var2.getCategory();
            this.mobCategoryCounts.addTo(var6, 1);
            this.localMobCapCalculator.addMob(new ChunkCoordIntPair(var5), (EnumCreatureType)var6);
        }

        public int getSpawnableChunkCount() {
            return this.spawnableChunkCount;
        }

        public Object2IntMap<EnumCreatureType> getMobCategoryCounts() {
            return this.unmodifiableMobCategoryCounts;
        }

        boolean canSpawnForCategory(EnumCreatureType var0, ChunkCoordIntPair var1) {
            int var2 = var0.getMaxInstancesPerChunk() * this.spawnableChunkCount / MAGIC_NUMBER;
            if (this.mobCategoryCounts.getInt((Object)var0) >= var2) {
                return false;
            }
            return this.localMobCapCalculator.canSpawn(var0, var1);
        }
    }

    @FunctionalInterface
    public static interface c {
        public boolean test(EntityTypes<?> var1, BlockPosition var2, IChunkAccess var3);
    }

    @FunctionalInterface
    public static interface a {
        public void run(EntityInsentient var1, IChunkAccess var2);
    }
}

