/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.VoxelShapeSpliterator;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public interface ICollisionAccess
extends IBlockAccess {
    public WorldBorder getWorldBorder();

    @Nullable
    public IBlockAccess getChunkForCollisions(int var1, int var2);

    default public boolean isUnobstructed(@Nullable Entity var0, VoxelShape var1) {
        return true;
    }

    default public boolean isUnobstructed(IBlockData var0, BlockPosition var1, VoxelShapeCollision var2) {
        VoxelShape var3 = var0.getCollisionShape(this, var1, var2);
        return var3.isEmpty() || this.isUnobstructed(null, var3.move(var1.getX(), var1.getY(), var1.getZ()));
    }

    default public boolean isUnobstructed(Entity var0) {
        return this.isUnobstructed(var0, VoxelShapes.create(var0.getBoundingBox()));
    }

    default public boolean noCollision(AxisAlignedBB var0) {
        return this.noCollision(null, var0);
    }

    default public boolean noCollision(Entity var0) {
        return this.noCollision(var0, var0.getBoundingBox());
    }

    default public boolean noCollision(@Nullable Entity var0, AxisAlignedBB var1) {
        for (VoxelShape var3 : this.getBlockCollisions(var0, var1)) {
            if (var3.isEmpty()) continue;
            return false;
        }
        if (!this.getEntityCollisions(var0, var1).isEmpty()) {
            return false;
        }
        if (var0 != null) {
            VoxelShape var2 = this.borderCollision(var0, var1);
            return var2 == null || !VoxelShapes.joinIsNotEmpty(var2, VoxelShapes.create(var1), OperatorBoolean.AND);
        }
        return true;
    }

    public List<VoxelShape> getEntityCollisions(@Nullable Entity var1, AxisAlignedBB var2);

    default public Iterable<VoxelShape> getCollisions(@Nullable Entity var0, AxisAlignedBB var1) {
        List<VoxelShape> var2 = this.getEntityCollisions(var0, var1);
        Iterable var3 = this.getBlockCollisions(var0, var1);
        return var2.isEmpty() ? var3 : Iterables.concat(var2, var3);
    }

    default public Iterable<VoxelShape> getBlockCollisions(@Nullable Entity var0, AxisAlignedBB var1) {
        return () -> new VoxelShapeSpliterator(this, var0, var1);
    }

    @Nullable
    private VoxelShape borderCollision(Entity var0, AxisAlignedBB var1) {
        WorldBorder var2 = this.getWorldBorder();
        return var2.isInsideCloseToBorder(var0, var1) ? var2.getCollisionShape() : null;
    }

    default public boolean collidesWithSuffocatingBlock(@Nullable Entity var0, AxisAlignedBB var1) {
        VoxelShapeSpliterator var2 = new VoxelShapeSpliterator(this, var0, var1, true);
        while (var2.hasNext()) {
            if (((VoxelShape)var2.next()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    default public Optional<Vec3D> findFreePosition(@Nullable Entity var02, VoxelShape var1, Vec3D var2, double var3, double var5, double var7) {
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        AxisAlignedBB var9 = var1.bounds().inflate(var3, var5, var7);
        VoxelShape var10 = StreamSupport.stream(this.getBlockCollisions(var02, var9).spliterator(), false).filter(var0 -> this.getWorldBorder() == null || this.getWorldBorder().isWithinBounds(var0.bounds())).flatMap(var0 -> var0.toAabbs().stream()).map(var6 -> var6.inflate(var3 / 2.0, var5 / 2.0, var7 / 2.0)).map(VoxelShapes::create).reduce(VoxelShapes.empty(), VoxelShapes::or);
        VoxelShape var11 = VoxelShapes.join(var1, var10, OperatorBoolean.ONLY_FIRST);
        return var11.closestPointTo(var2);
    }
}

