/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkCache
implements IBlockAccess,
ICollisionAccess {
    protected final int centerX;
    protected final int centerZ;
    protected final IChunkAccess[][] chunks;
    protected boolean allEmpty;
    protected final World level;

    public ChunkCache(World var0, BlockPosition var1, BlockPosition var2) {
        int var7;
        int var6;
        this.level = var0;
        this.centerX = SectionPosition.blockToSectionCoord(var1.getX());
        this.centerZ = SectionPosition.blockToSectionCoord(var1.getZ());
        int var3 = SectionPosition.blockToSectionCoord(var2.getX());
        int var4 = SectionPosition.blockToSectionCoord(var2.getZ());
        this.chunks = new IChunkAccess[var3 - this.centerX + 1][var4 - this.centerZ + 1];
        IChunkProvider var5 = var0.getChunkSource();
        this.allEmpty = true;
        for (var6 = this.centerX; var6 <= var3; ++var6) {
            for (var7 = this.centerZ; var7 <= var4; ++var7) {
                this.chunks[var6 - this.centerX][var7 - this.centerZ] = var5.getChunkNow(var6, var7);
            }
        }
        for (var6 = SectionPosition.blockToSectionCoord(var1.getX()); var6 <= SectionPosition.blockToSectionCoord(var2.getX()); ++var6) {
            for (var7 = SectionPosition.blockToSectionCoord(var1.getZ()); var7 <= SectionPosition.blockToSectionCoord(var2.getZ()); ++var7) {
                IChunkAccess var8 = this.chunks[var6 - this.centerX][var7 - this.centerZ];
                if (var8 == null || var8.isYSpaceEmpty(var1.getY(), var2.getY())) continue;
                this.allEmpty = false;
                return;
            }
        }
    }

    private IChunkAccess getChunk(BlockPosition var0) {
        return this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()));
    }

    private IChunkAccess getChunk(int var0, int var1) {
        int var2 = var0 - this.centerX;
        int var3 = var1 - this.centerZ;
        if (var2 < 0 || var2 >= this.chunks.length || var3 < 0 || var3 >= this.chunks[var2].length) {
            return new ChunkEmpty(this.level, new ChunkCoordIntPair(var0, var1));
        }
        IChunkAccess var4 = this.chunks[var2][var3];
        return var4 != null ? var4 : new ChunkEmpty(this.level, new ChunkCoordIntPair(var0, var1));
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.level.getWorldBorder();
    }

    @Override
    public IBlockAccess getChunkForCollisions(int var0, int var1) {
        return this.getChunk(var0, var1);
    }

    @Override
    public List<VoxelShape> getEntityCollisions(@Nullable Entity var0, AxisAlignedBB var1) {
        return List.of();
    }

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        IChunkAccess var1 = this.getChunk(var0);
        return var1.getBlockEntity(var0);
    }

    @Override
    public IBlockData getBlockState(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return Blocks.AIR.defaultBlockState();
        }
        IChunkAccess var1 = this.getChunk(var0);
        return var1.getBlockState(var0);
    }

    @Override
    public Fluid getFluidState(BlockPosition var0) {
        if (this.isOutsideBuildHeight(var0)) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        IChunkAccess var1 = this.getChunk(var0);
        return var1.getFluidState(var0);
    }

    @Override
    public int getMinBuildHeight() {
        return this.level.getMinBuildHeight();
    }

    @Override
    public int getHeight() {
        return this.level.getHeight();
    }

    public GameProfilerFiller getProfiler() {
        return this.level.getProfiler();
    }
}

