/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentSlotType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class EnchantmentFrostWalker
extends Enchantment {
    public EnchantmentFrostWalker(Enchantment.Rarity var0, EnumItemSlot ... var1) {
        super(var0, EnchantmentSlotType.ARMOR_FEET, var1);
    }

    @Override
    public int getMinCost(int var0) {
        return var0 * 10;
    }

    @Override
    public int getMaxCost(int var0) {
        return this.getMinCost(var0) + 15;
    }

    @Override
    public boolean isTreasureOnly() {
        return true;
    }

    @Override
    public int getMaxLevel() {
        return 2;
    }

    public static void onEntityMoved(EntityLiving var0, World var1, BlockPosition var2, int var3) {
        if (!var0.isOnGround()) {
            return;
        }
        IBlockData var4 = Blocks.FROSTED_ICE.defaultBlockState();
        float var5 = Math.min(16, 2 + var3);
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        for (BlockPosition var8 : BlockPosition.betweenClosed(var2.offset(-var5, -1.0, -var5), var2.offset(var5, -1.0, var5))) {
            IBlockData var10;
            if (!var8.closerThan(var0.position(), (double)var5)) continue;
            var6.set(var8.getX(), var8.getY() + 1, var8.getZ());
            IBlockData var9 = var1.getBlockState(var6);
            if (!var9.isAir() || (var10 = var1.getBlockState(var8)).getMaterial() != Material.WATER || var10.getValue(BlockFluids.LEVEL) != 0 || !var4.canSurvive(var1, var8) || !var1.isUnobstructed(var4, var8, VoxelShapeCollision.empty())) continue;
            var1.setBlockAndUpdate(var8, var4);
            var1.scheduleTick(var8, Blocks.FROSTED_ICE, MathHelper.nextInt(var0.getRandom(), 60, 120));
        }
    }

    @Override
    public boolean checkCompatibility(Enchantment var0) {
        return super.checkCompatibility(var0) && var0 != Enchantments.DEPTH_STRIDER;
    }
}

