/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;

public abstract class RecipeSingleItem
implements IRecipe<IInventory> {
    protected final RecipeItemStack ingredient;
    protected final ItemStack result;
    private final Recipes<?> type;
    private final RecipeSerializer<?> serializer;
    protected final MinecraftKey id;
    protected final String group;

    public RecipeSingleItem(Recipes<?> var0, RecipeSerializer<?> var1, MinecraftKey var2, String var3, RecipeItemStack var4, ItemStack var5) {
        this.type = var0;
        this.serializer = var1;
        this.id = var2;
        this.group = var3;
        this.ingredient = var4;
        this.result = var5;
    }

    @Override
    public Recipes<?> getType() {
        return this.type;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public MinecraftKey getId() {
        return this.id;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public ItemStack getResultItem() {
        return this.result;
    }

    @Override
    public NonNullList<RecipeItemStack> getIngredients() {
        NonNullList<RecipeItemStack> var0 = NonNullList.create();
        var0.add(this.ingredient);
        return var0;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return true;
    }

    @Override
    public ItemStack assemble(IInventory var0) {
        return this.result.copy();
    }

    public static class net.minecraft.world.item.crafting.RecipeSingleItem$a<T extends RecipeSingleItem>
    implements RecipeSerializer<T> {
        final a<T> factory;

        protected net.minecraft.world.item.crafting.RecipeSingleItem$a(a<T> var0) {
            this.factory = var0;
        }

        @Override
        public T fromJson(MinecraftKey var0, JsonObject var1) {
            String var2 = ChatDeserializer.getAsString(var1, "group", "");
            RecipeItemStack var3 = ChatDeserializer.isArrayNode(var1, "ingredient") ? RecipeItemStack.fromJson((JsonElement)ChatDeserializer.getAsJsonArray(var1, "ingredient")) : RecipeItemStack.fromJson((JsonElement)ChatDeserializer.getAsJsonObject(var1, "ingredient"));
            String var4 = ChatDeserializer.getAsString(var1, "result");
            int var5 = ChatDeserializer.getAsInt(var1, "count");
            ItemStack var6 = new ItemStack(IRegistry.ITEM.get(new MinecraftKey(var4)), var5);
            return this.factory.create(var0, var2, var3, var6);
        }

        @Override
        public T fromNetwork(MinecraftKey var0, PacketDataSerializer var1) {
            String var2 = var1.readUtf();
            RecipeItemStack var3 = RecipeItemStack.fromNetwork(var1);
            ItemStack var4 = var1.readItem();
            return this.factory.create(var0, var2, var3, var4);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, T var1) {
            var0.writeUtf(((RecipeSingleItem)var1).group);
            ((RecipeSingleItem)var1).ingredient.toNetwork(var0);
            var0.writeItem(((RecipeSingleItem)var1).result);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(MinecraftKey minecraftKey, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(minecraftKey, packetDataSerializer);
        }

        @Override
        public /* synthetic */ IRecipe fromJson(MinecraftKey minecraftKey, JsonObject jsonObject) {
            return this.fromJson(minecraftKey, jsonObject);
        }

        static interface a<T extends RecipeSingleItem> {
            public T create(MinecraftKey var1, String var2, RecipeItemStack var3, ItemStack var4);
        }
    }
}

