/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemFireworks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeFireworksStar
extends IRecipeComplex {
    private static final RecipeItemStack SHAPE_INGREDIENT = RecipeItemStack.of(Items.FIRE_CHARGE, Items.FEATHER, Items.GOLD_NUGGET, Items.SKELETON_SKULL, Items.WITHER_SKELETON_SKULL, Items.CREEPER_HEAD, Items.PLAYER_HEAD, Items.DRAGON_HEAD, Items.ZOMBIE_HEAD);
    private static final RecipeItemStack TRAIL_INGREDIENT = RecipeItemStack.of(Items.DIAMOND);
    private static final RecipeItemStack FLICKER_INGREDIENT = RecipeItemStack.of(Items.GLOWSTONE_DUST);
    private static final Map<Item, ItemFireworks.EffectType> SHAPE_BY_ITEM = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put(Items.FIRE_CHARGE, ItemFireworks.EffectType.LARGE_BALL);
        var0.put(Items.FEATHER, ItemFireworks.EffectType.BURST);
        var0.put(Items.GOLD_NUGGET, ItemFireworks.EffectType.STAR);
        var0.put(Items.SKELETON_SKULL, ItemFireworks.EffectType.CREEPER);
        var0.put(Items.WITHER_SKELETON_SKULL, ItemFireworks.EffectType.CREEPER);
        var0.put(Items.CREEPER_HEAD, ItemFireworks.EffectType.CREEPER);
        var0.put(Items.PLAYER_HEAD, ItemFireworks.EffectType.CREEPER);
        var0.put(Items.DRAGON_HEAD, ItemFireworks.EffectType.CREEPER);
        var0.put(Items.ZOMBIE_HEAD, ItemFireworks.EffectType.CREEPER);
    });
    private static final RecipeItemStack GUNPOWDER_INGREDIENT = RecipeItemStack.of(Items.GUNPOWDER);

    public RecipeFireworksStar(MinecraftKey var0) {
        super(var0);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        boolean var2 = false;
        boolean var3 = false;
        boolean var4 = false;
        boolean var5 = false;
        boolean var6 = false;
        for (int var7 = 0; var7 < var0.getContainerSize(); ++var7) {
            ItemStack var8 = var0.getItem(var7);
            if (var8.isEmpty()) continue;
            if (SHAPE_INGREDIENT.test(var8)) {
                if (var4) {
                    return false;
                }
                var4 = true;
                continue;
            }
            if (FLICKER_INGREDIENT.test(var8)) {
                if (var6) {
                    return false;
                }
                var6 = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test(var8)) {
                if (var5) {
                    return false;
                }
                var5 = true;
                continue;
            }
            if (GUNPOWDER_INGREDIENT.test(var8)) {
                if (var2) {
                    return false;
                }
                var2 = true;
                continue;
            }
            if (var8.getItem() instanceof ItemDye) {
                var3 = true;
                continue;
            }
            return false;
        }
        return var2 && var3;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        ItemStack var1 = new ItemStack(Items.FIREWORK_STAR);
        NBTTagCompound var2 = var1.getOrCreateTagElement("Explosion");
        ItemFireworks.EffectType var3 = ItemFireworks.EffectType.SMALL_BALL;
        ArrayList var4 = Lists.newArrayList();
        for (int var5 = 0; var5 < var0.getContainerSize(); ++var5) {
            ItemStack var6 = var0.getItem(var5);
            if (var6.isEmpty()) continue;
            if (SHAPE_INGREDIENT.test(var6)) {
                var3 = SHAPE_BY_ITEM.get(var6.getItem());
                continue;
            }
            if (FLICKER_INGREDIENT.test(var6)) {
                var2.putBoolean("Flicker", true);
                continue;
            }
            if (TRAIL_INGREDIENT.test(var6)) {
                var2.putBoolean("Trail", true);
                continue;
            }
            if (!(var6.getItem() instanceof ItemDye)) continue;
            var4.add(((ItemDye)var6.getItem()).getDyeColor().getFireworkColor());
        }
        var2.putIntArray("Colors", var4);
        var2.putByte("Type", (byte)var3.getId());
        return var1;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 * var1 >= 2;
    }

    @Override
    public ItemStack getResultItem() {
        return new ItemStack(Items.FIREWORK_STAR);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR;
    }
}

