/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBookAndQuill;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class ItemWrittenBook
extends Item {
    public static final int TITLE_LENGTH = 16;
    public static final int TITLE_MAX_LENGTH = 32;
    public static final int PAGE_EDIT_LENGTH = 1024;
    public static final int PAGE_LENGTH = Short.MAX_VALUE;
    public static final int MAX_PAGES = 100;
    public static final int MAX_GENERATION = 2;
    public static final String TAG_TITLE = "title";
    public static final String TAG_FILTERED_TITLE = "filtered_title";
    public static final String TAG_AUTHOR = "author";
    public static final String TAG_PAGES = "pages";
    public static final String TAG_FILTERED_PAGES = "filtered_pages";
    public static final String TAG_GENERATION = "generation";
    public static final String TAG_RESOLVED = "resolved";

    public ItemWrittenBook(Item.Info var0) {
        super(var0);
    }

    public static boolean makeSureTagIsValid(@Nullable NBTTagCompound var0) {
        if (!ItemBookAndQuill.makeSureTagIsValid(var0)) {
            return false;
        }
        if (!var0.contains(TAG_TITLE, 8)) {
            return false;
        }
        String var1 = var0.getString(TAG_TITLE);
        if (var1.length() > 32) {
            return false;
        }
        return var0.contains(TAG_AUTHOR, 8);
    }

    public static int getGeneration(ItemStack var0) {
        return var0.getTag().getInt(TAG_GENERATION);
    }

    public static int getPageCount(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        return var1 != null ? var1.getList(TAG_PAGES, 8).size() : 0;
    }

    @Override
    public IChatBaseComponent getName(ItemStack var0) {
        String var2;
        NBTTagCompound var1 = var0.getTag();
        if (var1 != null && !UtilColor.isNullOrEmpty(var2 = var1.getString(TAG_TITLE))) {
            return new ChatComponentText(var2);
        }
        return super.getName(var0);
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        if (var0.hasTag()) {
            NBTTagCompound var4 = var0.getTag();
            String var5 = var4.getString(TAG_AUTHOR);
            if (!UtilColor.isNullOrEmpty(var5)) {
                var2.add(new ChatMessage("book.byAuthor", var5).withStyle(EnumChatFormat.GRAY));
            }
            var2.add(new ChatMessage("book.generation." + var4.getInt(TAG_GENERATION)).withStyle(EnumChatFormat.GRAY));
        }
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (var3.is(Blocks.LECTERN)) {
            return BlockLectern.tryPlaceBook(var0.getPlayer(), var1, var2, var3, var0.getItemInHand()) ? EnumInteractionResult.sidedSuccess(var1.isClientSide) : EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        var1.openItemGui(var3, var2);
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        return InteractionResultWrapper.sidedSuccess(var3, var0.isClientSide());
    }

    public static boolean resolveBookComponents(ItemStack var0, @Nullable CommandListenerWrapper var1, @Nullable EntityHuman var2) {
        NBTTagCompound var3 = var0.getTag();
        if (var3 == null || var3.getBoolean(TAG_RESOLVED)) {
            return false;
        }
        var3.putBoolean(TAG_RESOLVED, true);
        if (!ItemWrittenBook.makeSureTagIsValid(var3)) {
            return false;
        }
        NBTTagList var4 = var3.getList(TAG_PAGES, 8);
        for (int var5 = 0; var5 < var4.size(); ++var5) {
            var4.set(var5, NBTTagString.valueOf(ItemWrittenBook.resolvePage(var1, var2, var4.getString(var5))));
        }
        if (var3.contains(TAG_FILTERED_PAGES, 10)) {
            NBTTagCompound var5 = var3.getCompound(TAG_FILTERED_PAGES);
            for (String var7 : var5.getAllKeys()) {
                var5.putString(var7, ItemWrittenBook.resolvePage(var1, var2, var5.getString(var7)));
            }
        }
        return true;
    }

    private static String resolvePage(@Nullable CommandListenerWrapper var0, @Nullable EntityHuman var1, String var2) {
        IChatMutableComponent var3;
        try {
            var3 = IChatBaseComponent.ChatSerializer.fromJsonLenient(var2);
            var3 = ChatComponentUtils.updateForEntity(var0, var3, (Entity)var1, 0);
        }
        catch (Exception var4) {
            var3 = new ChatComponentText(var2);
        }
        return IChatBaseComponent.ChatSerializer.toJson(var3);
    }

    @Override
    public boolean isFoil(ItemStack var0) {
        return true;
    }
}

