/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.ITagRegistry;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModeCheck;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentDurability;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStack {
    public static final Codec<ItemStack> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)IRegistry.ITEM.byNameCodec().fieldOf("id").forGetter(var0 -> var0.item), (App)Codec.INT.fieldOf("Count").forGetter(var0 -> var0.count), (App)NBTTagCompound.CODEC.optionalFieldOf("tag").forGetter(var0 -> Optional.ofNullable(var0.tag))).apply((Applicative)var02, ItemStack::new));
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ItemStack EMPTY = new ItemStack((IMaterial)null);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = SystemUtils.make(new DecimalFormat("#.##"), var0 -> var0.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final String TAG_ENCH = "Enchantments";
    public static final String TAG_DISPLAY = "display";
    public static final String TAG_DISPLAY_NAME = "Name";
    public static final String TAG_LORE = "Lore";
    public static final String TAG_DAMAGE = "Damage";
    public static final String TAG_COLOR = "color";
    private static final String TAG_UNBREAKABLE = "Unbreakable";
    private static final String TAG_REPAIR_COST = "RepairCost";
    private static final String TAG_CAN_DESTROY_BLOCK_LIST = "CanDestroy";
    private static final String TAG_CAN_PLACE_ON_BLOCK_LIST = "CanPlaceOn";
    private static final String TAG_HIDE_FLAGS = "HideFlags";
    private static final int DONT_HIDE_TOOLTIP = 0;
    private static final ChatModifier LORE_STYLE = ChatModifier.EMPTY.withColor(EnumChatFormat.DARK_PURPLE).withItalic(true);
    private int count;
    private int popTime;
    @Deprecated
    private Item item;
    @Nullable
    private NBTTagCompound tag;
    private boolean emptyCacheFlag;
    @Nullable
    private Entity entityRepresentation;
    @Nullable
    private AdventureModeCheck adventureBreakCheck;
    @Nullable
    private AdventureModeCheck adventurePlaceCheck;

    public Optional<TooltipComponent> getTooltipImage() {
        return this.getItem().getTooltipImage(this);
    }

    public ItemStack(IMaterial var0) {
        this(var0, 1);
    }

    private ItemStack(IMaterial var0, int var1, Optional<NBTTagCompound> var2) {
        this(var0, var1);
        var2.ifPresent(this::setTag);
    }

    public ItemStack(IMaterial var0, int var1) {
        this.item = var0 == null ? null : var0.asItem();
        this.count = var1;
        if (this.item != null && this.item.canBeDepleted()) {
            this.setDamageValue(this.getDamageValue());
        }
        this.updateEmptyCacheFlag();
    }

    private void updateEmptyCacheFlag() {
        this.emptyCacheFlag = false;
        this.emptyCacheFlag = this.isEmpty();
    }

    private ItemStack(NBTTagCompound var0) {
        this.item = IRegistry.ITEM.get(new MinecraftKey(var0.getString("id")));
        this.count = var0.getByte("Count");
        if (var0.contains("tag", 10)) {
            this.tag = var0.getCompound("tag");
            this.getItem().verifyTagAfterLoad(this.tag);
        }
        if (this.getItem().canBeDepleted()) {
            this.setDamageValue(this.getDamageValue());
        }
        this.updateEmptyCacheFlag();
    }

    public static ItemStack of(NBTTagCompound var0) {
        try {
            return new ItemStack(var0);
        }
        catch (RuntimeException var1) {
            LOGGER.debug("Tried to load invalid item: {}", (Object)var0, (Object)var1);
            return EMPTY;
        }
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        if (this.getItem() == null || this.is(Items.AIR)) {
            return true;
        }
        return this.count <= 0;
    }

    public ItemStack split(int var0) {
        int var1 = Math.min(var0, this.count);
        ItemStack var2 = this.copy();
        var2.setCount(var1);
        this.shrink(var1);
        return var2;
    }

    public Item getItem() {
        return this.emptyCacheFlag ? Items.AIR : this.item;
    }

    public boolean is(Tag<Item> var0) {
        return var0.contains(this.getItem());
    }

    public boolean is(Item var0) {
        return this.getItem() == var0;
    }

    public EnumInteractionResult useOn(ItemActionContext var0) {
        EntityHuman var1 = var0.getPlayer();
        BlockPosition var2 = var0.getClickedPos();
        ShapeDetectorBlock var3 = new ShapeDetectorBlock(var0.getLevel(), var2, false);
        if (var1 != null && !var1.getAbilities().mayBuild && !this.hasAdventureModePlaceTagForBlock(var0.getLevel().getTagManager(), var3)) {
            return EnumInteractionResult.PASS;
        }
        Item var4 = this.getItem();
        EnumInteractionResult var5 = var4.useOn(var0);
        if (var1 != null && var5.shouldAwardStats()) {
            var1.awardStat(StatisticList.ITEM_USED.get(var4));
        }
        return var5;
    }

    public float getDestroySpeed(IBlockData var0) {
        return this.getItem().getDestroySpeed(this, var0);
    }

    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        return this.getItem().use(var0, var1, var2);
    }

    public ItemStack finishUsingItem(World var0, EntityLiving var1) {
        return this.getItem().finishUsingItem(this, var0, var1);
    }

    public NBTTagCompound save(NBTTagCompound var0) {
        MinecraftKey var1 = IRegistry.ITEM.getKey(this.getItem());
        var0.putString("id", var1 == null ? "minecraft:air" : var1.toString());
        var0.putByte("Count", (byte)this.count);
        if (this.tag != null) {
            var0.put("tag", this.tag.copy());
        }
        return var0;
    }

    public int getMaxStackSize() {
        return this.getItem().getMaxStackSize();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        if (this.emptyCacheFlag || this.getItem().getMaxDamage() <= 0) {
            return false;
        }
        NBTTagCompound var0 = this.getTag();
        return var0 == null || !var0.getBoolean(TAG_UNBREAKABLE);
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        return this.tag == null ? 0 : this.tag.getInt(TAG_DAMAGE);
    }

    public void setDamageValue(int var0) {
        this.getOrCreateTag().putInt(TAG_DAMAGE, Math.max(0, var0));
    }

    public int getMaxDamage() {
        return this.getItem().getMaxDamage();
    }

    public boolean hurt(int var0, Random var1, @Nullable EntityPlayer var2) {
        int var3;
        if (!this.isDamageableItem()) {
            return false;
        }
        if (var0 > 0) {
            var3 = EnchantmentManager.getItemEnchantmentLevel(Enchantments.UNBREAKING, this);
            int var4 = 0;
            for (int var5 = 0; var3 > 0 && var5 < var0; ++var5) {
                if (!EnchantmentDurability.shouldIgnoreDurabilityDrop(this, var3, var1)) continue;
                ++var4;
            }
            if ((var0 -= var4) <= 0) {
                return false;
            }
        }
        if (var2 != null && var0 != 0) {
            CriterionTriggers.ITEM_DURABILITY_CHANGED.trigger(var2, this, this.getDamageValue() + var0);
        }
        var3 = this.getDamageValue() + var0;
        this.setDamageValue(var3);
        return var3 >= this.getMaxDamage();
    }

    public <T extends EntityLiving> void hurtAndBreak(int var0, T var1, Consumer<T> var2) {
        if (var1.level.isClientSide || var1 instanceof EntityHuman && ((EntityHuman)var1).getAbilities().instabuild) {
            return;
        }
        if (!this.isDamageableItem()) {
            return;
        }
        if (this.hurt(var0, var1.getRandom(), var1 instanceof EntityPlayer ? (EntityPlayer)var1 : null)) {
            var2.accept(var1);
            Item var3 = this.getItem();
            this.shrink(1);
            if (var1 instanceof EntityHuman) {
                ((EntityHuman)var1).awardStat(StatisticList.ITEM_BROKEN.get(var3));
            }
            this.setDamageValue(0);
        }
    }

    public boolean isBarVisible() {
        return this.item.isBarVisible(this);
    }

    public int getBarWidth() {
        return this.item.getBarWidth(this);
    }

    public int getBarColor() {
        return this.item.getBarColor(this);
    }

    public boolean overrideStackedOnOther(Slot var0, ClickAction var1, EntityHuman var2) {
        return this.getItem().overrideStackedOnOther(this, var0, var1, var2);
    }

    public boolean overrideOtherStackedOnMe(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3, SlotAccess var4) {
        return this.getItem().overrideOtherStackedOnMe(this, var0, var1, var2, var3, var4);
    }

    public void hurtEnemy(EntityLiving var0, EntityHuman var1) {
        Item var2 = this.getItem();
        if (var2.hurtEnemy(this, var0, var1)) {
            var1.awardStat(StatisticList.ITEM_USED.get(var2));
        }
    }

    public void mineBlock(World var0, IBlockData var1, BlockPosition var2, EntityHuman var3) {
        Item var4 = this.getItem();
        if (var4.mineBlock(this, var0, var1, var2, var3)) {
            var3.awardStat(StatisticList.ITEM_USED.get(var4));
        }
    }

    public boolean isCorrectToolForDrops(IBlockData var0) {
        return this.getItem().isCorrectToolForDrops(var0);
    }

    public EnumInteractionResult interactLivingEntity(EntityHuman var0, EntityLiving var1, EnumHand var2) {
        return this.getItem().interactLivingEntity(this, var0, var1, var2);
    }

    public ItemStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack var0 = new ItemStack(this.getItem(), this.count);
        var0.setPopTime(this.getPopTime());
        if (this.tag != null) {
            var0.tag = this.tag.copy();
        }
        return var0;
    }

    public static boolean tagMatches(ItemStack var0, ItemStack var1) {
        if (var0.isEmpty() && var1.isEmpty()) {
            return true;
        }
        if (var0.isEmpty() || var1.isEmpty()) {
            return false;
        }
        if (var0.tag == null && var1.tag != null) {
            return false;
        }
        return var0.tag == null || var0.tag.equals(var1.tag);
    }

    public static boolean matches(ItemStack var0, ItemStack var1) {
        if (var0.isEmpty() && var1.isEmpty()) {
            return true;
        }
        if (var0.isEmpty() || var1.isEmpty()) {
            return false;
        }
        return var0.matches(var1);
    }

    private boolean matches(ItemStack var0) {
        if (this.count != var0.count) {
            return false;
        }
        if (!this.is(var0.getItem())) {
            return false;
        }
        if (this.tag == null && var0.tag != null) {
            return false;
        }
        return this.tag == null || this.tag.equals(var0.tag);
    }

    public static boolean isSame(ItemStack var0, ItemStack var1) {
        if (var0 == var1) {
            return true;
        }
        if (!var0.isEmpty() && !var1.isEmpty()) {
            return var0.sameItem(var1);
        }
        return false;
    }

    public static boolean isSameIgnoreDurability(ItemStack var0, ItemStack var1) {
        if (var0 == var1) {
            return true;
        }
        if (!var0.isEmpty() && !var1.isEmpty()) {
            return var0.sameItemStackIgnoreDurability(var1);
        }
        return false;
    }

    public boolean sameItem(ItemStack var0) {
        return !var0.isEmpty() && this.is(var0.getItem());
    }

    public boolean sameItemStackIgnoreDurability(ItemStack var0) {
        if (this.isDamageableItem()) {
            return !var0.isEmpty() && this.is(var0.getItem());
        }
        return this.sameItem(var0);
    }

    public static boolean isSameItemSameTags(ItemStack var0, ItemStack var1) {
        return var0.is(var1.getItem()) && ItemStack.tagMatches(var0, var1);
    }

    public String getDescriptionId() {
        return this.getItem().getDescriptionId(this);
    }

    public String toString() {
        return this.count + " " + this.getItem();
    }

    public void inventoryTick(World var0, Entity var1, int var2, boolean var3) {
        if (this.popTime > 0) {
            --this.popTime;
        }
        if (this.getItem() != null) {
            this.getItem().inventoryTick(this, var0, var1, var2, var3);
        }
    }

    public void onCraftedBy(World var0, EntityHuman var1, int var2) {
        var1.awardStat(StatisticList.ITEM_CRAFTED.get(this.getItem()), var2);
        this.getItem().onCraftedBy(this, var0, var1);
    }

    public int getUseDuration() {
        return this.getItem().getUseDuration(this);
    }

    public EnumAnimation getUseAnimation() {
        return this.getItem().getUseAnimation(this);
    }

    public void releaseUsing(World var0, EntityLiving var1, int var2) {
        this.getItem().releaseUsing(this, var0, var1, var2);
    }

    public boolean useOnRelease() {
        return this.getItem().useOnRelease(this);
    }

    public boolean hasTag() {
        return !this.emptyCacheFlag && this.tag != null && !this.tag.isEmpty();
    }

    @Nullable
    public NBTTagCompound getTag() {
        return this.tag;
    }

    public NBTTagCompound getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new NBTTagCompound());
        }
        return this.tag;
    }

    public NBTTagCompound getOrCreateTagElement(String var0) {
        if (this.tag == null || !this.tag.contains(var0, 10)) {
            NBTTagCompound var1 = new NBTTagCompound();
            this.addTagElement(var0, var1);
            return var1;
        }
        return this.tag.getCompound(var0);
    }

    @Nullable
    public NBTTagCompound getTagElement(String var0) {
        if (this.tag == null || !this.tag.contains(var0, 10)) {
            return null;
        }
        return this.tag.getCompound(var0);
    }

    public void removeTagKey(String var0) {
        if (this.tag != null && this.tag.contains(var0)) {
            this.tag.remove(var0);
            if (this.tag.isEmpty()) {
                this.tag = null;
            }
        }
    }

    public NBTTagList getEnchantmentTags() {
        if (this.tag != null) {
            return this.tag.getList(TAG_ENCH, 10);
        }
        return new NBTTagList();
    }

    public void setTag(@Nullable NBTTagCompound var0) {
        this.tag = var0;
        if (this.getItem().canBeDepleted()) {
            this.setDamageValue(this.getDamageValue());
        }
        if (var0 != null) {
            this.getItem().verifyTagAfterLoad(var0);
        }
    }

    public IChatBaseComponent getHoverName() {
        NBTTagCompound var0 = this.getTagElement(TAG_DISPLAY);
        if (var0 != null && var0.contains(TAG_DISPLAY_NAME, 8)) {
            try {
                IChatMutableComponent var1 = IChatBaseComponent.ChatSerializer.fromJson(var0.getString(TAG_DISPLAY_NAME));
                if (var1 != null) {
                    return var1;
                }
                var0.remove(TAG_DISPLAY_NAME);
            }
            catch (Exception var1) {
                var0.remove(TAG_DISPLAY_NAME);
            }
        }
        return this.getItem().getName(this);
    }

    public ItemStack setHoverName(@Nullable IChatBaseComponent var0) {
        NBTTagCompound var1 = this.getOrCreateTagElement(TAG_DISPLAY);
        if (var0 != null) {
            var1.putString(TAG_DISPLAY_NAME, IChatBaseComponent.ChatSerializer.toJson(var0));
        } else {
            var1.remove(TAG_DISPLAY_NAME);
        }
        return this;
    }

    public void resetHoverName() {
        NBTTagCompound var0 = this.getTagElement(TAG_DISPLAY);
        if (var0 != null) {
            var0.remove(TAG_DISPLAY_NAME);
            if (var0.isEmpty()) {
                this.removeTagKey(TAG_DISPLAY);
            }
        }
        if (this.tag != null && this.tag.isEmpty()) {
            this.tag = null;
        }
    }

    public boolean hasCustomHoverName() {
        NBTTagCompound var0 = this.getTagElement(TAG_DISPLAY);
        return var0 != null && var0.contains(TAG_DISPLAY_NAME, 8);
    }

    public List<IChatBaseComponent> getTooltipLines(@Nullable EntityHuman var0, TooltipFlag var1) {
        Object var9;
        Object var8;
        Object var5;
        int var4;
        Integer var42;
        ArrayList var2 = Lists.newArrayList();
        IChatMutableComponent var3 = new ChatComponentText("").append(this.getHoverName()).withStyle(this.getRarity().color);
        if (this.hasCustomHoverName()) {
            var3.withStyle(EnumChatFormat.ITALIC);
        }
        var2.add(var3);
        if (!var1.isAdvanced() && !this.hasCustomHoverName() && this.is(Items.FILLED_MAP) && (var42 = ItemWorldMap.getMapId(this)) != null) {
            var2.add(new ChatComponentText("#" + var42).withStyle(EnumChatFormat.GRAY));
        }
        if (ItemStack.shouldShowInTooltip(var4 = this.getHideFlags(), HideFlags.ADDITIONAL)) {
            this.getItem().appendHoverText(this, var0 == null ? null : var0.level, var2, var1);
        }
        if (this.hasTag()) {
            if (ItemStack.shouldShowInTooltip(var4, HideFlags.ENCHANTMENTS)) {
                ItemStack.appendEnchantmentNames(var2, this.getEnchantmentTags());
            }
            if (this.tag.contains(TAG_DISPLAY, 10)) {
                var5 = this.tag.getCompound(TAG_DISPLAY);
                if (ItemStack.shouldShowInTooltip(var4, HideFlags.DYE) && ((NBTTagCompound)var5).contains(TAG_COLOR, 99)) {
                    if (var1.isAdvanced()) {
                        var2.add(new ChatMessage("item.color", String.format("#%06X", ((NBTTagCompound)var5).getInt(TAG_COLOR))).withStyle(EnumChatFormat.GRAY));
                    } else {
                        var2.add(new ChatMessage("item.dyed").withStyle(EnumChatFormat.GRAY, EnumChatFormat.ITALIC));
                    }
                }
                if (((NBTTagCompound)var5).getTagType(TAG_LORE) == 9) {
                    NBTTagList var6 = ((NBTTagCompound)var5).getList(TAG_LORE, 8);
                    for (int var7 = 0; var7 < var6.size(); ++var7) {
                        var8 = var6.getString(var7);
                        try {
                            var9 = IChatBaseComponent.ChatSerializer.fromJson((String)var8);
                            if (var9 == null) continue;
                            var2.add(ChatComponentUtils.mergeStyles(var9, LORE_STYLE));
                            continue;
                        }
                        catch (Exception var92) {
                            ((NBTTagCompound)var5).remove(TAG_LORE);
                        }
                    }
                }
            }
        }
        if (ItemStack.shouldShowInTooltip(var4, HideFlags.MODIFIERS)) {
            var5 = EnumItemSlot.values();
            int var6 = ((EnumItemSlot[])var5).length;
            for (int i2 = 0; i2 < var6; ++i2) {
                var8 = var5[i2];
                var9 = this.getAttributeModifiers((EnumItemSlot)((Object)var8));
                if (var9.isEmpty()) continue;
                var2.add(ChatComponentText.EMPTY);
                var2.add(new ChatMessage("item.modifiers." + var8.getName()).withStyle(EnumChatFormat.GRAY));
                for (Map.Entry var11 : var9.entries()) {
                    AttributeModifier var12 = (AttributeModifier)var11.getValue();
                    double var13 = var12.getAmount();
                    boolean var17 = false;
                    if (var0 != null) {
                        if (var12.getId() == Item.BASE_ATTACK_DAMAGE_UUID) {
                            var13 += var0.getAttributeBaseValue(GenericAttributes.ATTACK_DAMAGE);
                            var13 += (double)EnchantmentManager.getDamageBonus(this, EnumMonsterType.UNDEFINED);
                            var17 = true;
                        } else if (var12.getId() == Item.BASE_ATTACK_SPEED_UUID) {
                            var13 += var0.getAttributeBaseValue(GenericAttributes.ATTACK_SPEED);
                            var17 = true;
                        }
                    }
                    double var15 = var12.getOperation() == AttributeModifier.Operation.MULTIPLY_BASE || var12.getOperation() == AttributeModifier.Operation.MULTIPLY_TOTAL ? var13 * 100.0 : (((AttributeBase)var11.getKey()).equals(GenericAttributes.KNOCKBACK_RESISTANCE) ? var13 * 10.0 : var13);
                    if (var17) {
                        var2.add(new ChatComponentText(" ").append(new ChatMessage("attribute.modifier.equals." + var12.getOperation().toValue(), ATTRIBUTE_MODIFIER_FORMAT.format(var15), new ChatMessage(((AttributeBase)var11.getKey()).getDescriptionId()))).withStyle(EnumChatFormat.DARK_GREEN));
                        continue;
                    }
                    if (var13 > 0.0) {
                        var2.add(new ChatMessage("attribute.modifier.plus." + var12.getOperation().toValue(), ATTRIBUTE_MODIFIER_FORMAT.format(var15), new ChatMessage(((AttributeBase)var11.getKey()).getDescriptionId())).withStyle(EnumChatFormat.BLUE));
                        continue;
                    }
                    if (!(var13 < 0.0)) continue;
                    var2.add(new ChatMessage("attribute.modifier.take." + var12.getOperation().toValue(), ATTRIBUTE_MODIFIER_FORMAT.format(var15 *= -1.0), new ChatMessage(((AttributeBase)var11.getKey()).getDescriptionId())).withStyle(EnumChatFormat.RED));
                }
            }
        }
        if (this.hasTag()) {
            if (ItemStack.shouldShowInTooltip(var4, HideFlags.UNBREAKABLE) && this.tag.getBoolean(TAG_UNBREAKABLE)) {
                var2.add(new ChatMessage("item.unbreakable").withStyle(EnumChatFormat.BLUE));
            }
            if (ItemStack.shouldShowInTooltip(var4, HideFlags.CAN_DESTROY) && this.tag.contains(TAG_CAN_DESTROY_BLOCK_LIST, 9) && !((NBTTagList)(var5 = this.tag.getList(TAG_CAN_DESTROY_BLOCK_LIST, 8))).isEmpty()) {
                var2.add(ChatComponentText.EMPTY);
                var2.add(new ChatMessage("item.canBreak").withStyle(EnumChatFormat.GRAY));
                for (int var6 = 0; var6 < ((NBTTagList)var5).size(); ++var6) {
                    var2.addAll(ItemStack.expandBlockState(((NBTTagList)var5).getString(var6)));
                }
            }
            if (ItemStack.shouldShowInTooltip(var4, HideFlags.CAN_PLACE) && this.tag.contains(TAG_CAN_PLACE_ON_BLOCK_LIST, 9) && !((NBTTagList)(var5 = this.tag.getList(TAG_CAN_PLACE_ON_BLOCK_LIST, 8))).isEmpty()) {
                var2.add(ChatComponentText.EMPTY);
                var2.add(new ChatMessage("item.canPlace").withStyle(EnumChatFormat.GRAY));
                for (int var6 = 0; var6 < ((NBTTagList)var5).size(); ++var6) {
                    var2.addAll(ItemStack.expandBlockState(((NBTTagList)var5).getString(var6)));
                }
            }
        }
        if (var1.isAdvanced()) {
            if (this.isDamaged()) {
                var2.add(new ChatMessage("item.durability", this.getMaxDamage() - this.getDamageValue(), this.getMaxDamage()));
            }
            var2.add(new ChatComponentText(IRegistry.ITEM.getKey(this.getItem()).toString()).withStyle(EnumChatFormat.DARK_GRAY));
            if (this.hasTag()) {
                var2.add(new ChatMessage("item.nbt_tags", this.tag.getAllKeys().size()).withStyle(EnumChatFormat.DARK_GRAY));
            }
        }
        return var2;
    }

    private static boolean shouldShowInTooltip(int var0, HideFlags var1) {
        return (var0 & var1.getMask()) == 0;
    }

    private int getHideFlags() {
        if (this.hasTag() && this.tag.contains(TAG_HIDE_FLAGS, 99)) {
            return this.tag.getInt(TAG_HIDE_FLAGS);
        }
        return 0;
    }

    public void hideTooltipPart(HideFlags var0) {
        NBTTagCompound var1 = this.getOrCreateTag();
        var1.putInt(TAG_HIDE_FLAGS, var1.getInt(TAG_HIDE_FLAGS) | var0.getMask());
    }

    public static void appendEnchantmentNames(List<IChatBaseComponent> var0, NBTTagList var1) {
        for (int var22 = 0; var22 < var1.size(); ++var22) {
            NBTTagCompound var3 = var1.getCompound(var22);
            IRegistry.ENCHANTMENT.getOptional(EnchantmentManager.getEnchantmentId(var3)).ifPresent(var2 -> var0.add(var2.getFullname(EnchantmentManager.getEnchantmentLevel(var3))));
        }
    }

    private static Collection<IChatBaseComponent> expandBlockState(String var02) {
        try {
            boolean var5;
            ArgumentBlock var1 = new ArgumentBlock(new StringReader(var02), true).parse(true);
            IBlockData var2 = var1.getState();
            MinecraftKey var3 = var1.getTag();
            boolean var4 = var2 != null;
            boolean bl = var5 = var3 != null;
            if (var4 || var5) {
                List<Block> var7;
                if (var4) {
                    return Lists.newArrayList((Object[])new IChatBaseComponent[]{var2.getBlock().getName().withStyle(EnumChatFormat.DARK_GRAY)});
                }
                Tag<Block> var6 = TagsBlock.getAllTags().getTag(var3);
                if (var6 != null && !(var7 = var6.getValues()).isEmpty()) {
                    return var7.stream().map(Block::getName).map(var0 -> var0.withStyle(EnumChatFormat.DARK_GRAY)).collect(Collectors.toList());
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return Lists.newArrayList((Object[])new IChatBaseComponent[]{new ChatComponentText("missingno").withStyle(EnumChatFormat.DARK_GRAY)});
    }

    public boolean hasFoil() {
        return this.getItem().isFoil(this);
    }

    public EnumItemRarity getRarity() {
        return this.getItem().getRarity(this);
    }

    public boolean isEnchantable() {
        if (!this.getItem().isEnchantable(this)) {
            return false;
        }
        return !this.isEnchanted();
    }

    public void enchant(Enchantment var0, int var1) {
        this.getOrCreateTag();
        if (!this.tag.contains(TAG_ENCH, 9)) {
            this.tag.put(TAG_ENCH, new NBTTagList());
        }
        NBTTagList var2 = this.tag.getList(TAG_ENCH, 10);
        var2.add(EnchantmentManager.storeEnchantment(EnchantmentManager.getEnchantmentId(var0), (byte)var1));
    }

    public boolean isEnchanted() {
        if (this.tag != null && this.tag.contains(TAG_ENCH, 9)) {
            return !this.tag.getList(TAG_ENCH, 10).isEmpty();
        }
        return false;
    }

    public void addTagElement(String var0, NBTBase var1) {
        this.getOrCreateTag().put(var0, var1);
    }

    public boolean isFramed() {
        return this.entityRepresentation instanceof EntityItemFrame;
    }

    public void setEntityRepresentation(@Nullable Entity var0) {
        this.entityRepresentation = var0;
    }

    @Nullable
    public EntityItemFrame getFrame() {
        return this.entityRepresentation instanceof EntityItemFrame ? (EntityItemFrame)this.getEntityRepresentation() : null;
    }

    @Nullable
    public Entity getEntityRepresentation() {
        return !this.emptyCacheFlag ? this.entityRepresentation : null;
    }

    public int getBaseRepairCost() {
        if (this.hasTag() && this.tag.contains(TAG_REPAIR_COST, 3)) {
            return this.tag.getInt(TAG_REPAIR_COST);
        }
        return 0;
    }

    public void setRepairCost(int var0) {
        this.getOrCreateTag().putInt(TAG_REPAIR_COST, var0);
    }

    public Multimap<AttributeBase, AttributeModifier> getAttributeModifiers(EnumItemSlot var0) {
        HashMultimap var1;
        if (this.hasTag() && this.tag.contains("AttributeModifiers", 9)) {
            var1 = HashMultimap.create();
            NBTTagList var2 = this.tag.getList("AttributeModifiers", 10);
            for (int var3 = 0; var3 < var2.size(); ++var3) {
                AttributeModifier var6;
                Optional<AttributeBase> var5;
                NBTTagCompound var4 = var2.getCompound(var3);
                if (var4.contains("Slot", 8) && !var4.getString("Slot").equals(var0.getName()) || !(var5 = IRegistry.ATTRIBUTE.getOptional(MinecraftKey.tryParse(var4.getString("AttributeName")))).isPresent() || (var6 = AttributeModifier.load(var4)) == null || var6.getId().getLeastSignificantBits() == 0L || var6.getId().getMostSignificantBits() == 0L) continue;
                var1.put((Object)var5.get(), (Object)var6);
            }
        } else {
            var1 = this.getItem().getDefaultAttributeModifiers(var0);
        }
        return var1;
    }

    public void addAttributeModifier(AttributeBase var0, AttributeModifier var1, @Nullable EnumItemSlot var2) {
        this.getOrCreateTag();
        if (!this.tag.contains("AttributeModifiers", 9)) {
            this.tag.put("AttributeModifiers", new NBTTagList());
        }
        NBTTagList var3 = this.tag.getList("AttributeModifiers", 10);
        NBTTagCompound var4 = var1.save();
        var4.putString("AttributeName", IRegistry.ATTRIBUTE.getKey(var0).toString());
        if (var2 != null) {
            var4.putString("Slot", var2.getName());
        }
        var3.add(var4);
    }

    public IChatBaseComponent getDisplayName() {
        IChatMutableComponent var02 = new ChatComponentText("").append(this.getHoverName());
        if (this.hasCustomHoverName()) {
            var02.withStyle(EnumChatFormat.ITALIC);
        }
        IChatMutableComponent var1 = ChatComponentUtils.wrapInSquareBrackets(var02);
        if (!this.emptyCacheFlag) {
            var1.withStyle(this.getRarity().color).withStyle(var0 -> var0.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ITEM, new ChatHoverable.c(this))));
        }
        return var1;
    }

    public boolean hasAdventureModePlaceTagForBlock(ITagRegistry var0, ShapeDetectorBlock var1) {
        if (this.adventurePlaceCheck == null) {
            this.adventurePlaceCheck = new AdventureModeCheck(TAG_CAN_PLACE_ON_BLOCK_LIST);
        }
        return this.adventurePlaceCheck.test(this, var0, var1);
    }

    public boolean hasAdventureModeBreakTagForBlock(ITagRegistry var0, ShapeDetectorBlock var1) {
        if (this.adventureBreakCheck == null) {
            this.adventureBreakCheck = new AdventureModeCheck(TAG_CAN_DESTROY_BLOCK_LIST);
        }
        return this.adventureBreakCheck.test(this, var0, var1);
    }

    public int getPopTime() {
        return this.popTime;
    }

    public void setPopTime(int var0) {
        this.popTime = var0;
    }

    public int getCount() {
        return this.emptyCacheFlag ? 0 : this.count;
    }

    public void setCount(int var0) {
        this.count = var0;
        this.updateEmptyCacheFlag();
    }

    public void grow(int var0) {
        this.setCount(this.count + var0);
    }

    public void shrink(int var0) {
        this.grow(-var0);
    }

    public void onUseTick(World var0, EntityLiving var1, int var2) {
        this.getItem().onUseTick(var0, var1, this, var2);
    }

    public void onDestroyed(EntityItem var0) {
        this.getItem().onDestroyed(var0);
    }

    public boolean isEdible() {
        return this.getItem().isEdible();
    }

    public SoundEffect getDrinkingSound() {
        return this.getItem().getDrinkingSound();
    }

    public SoundEffect getEatingSound() {
        return this.getItem().getEatingSound();
    }

    @Nullable
    public SoundEffect getEquipSound() {
        return this.getItem().getEquipSound();
    }

    public static final class HideFlags
    extends Enum<HideFlags> {
        public static final /* enum */ HideFlags ENCHANTMENTS = new HideFlags();
        public static final /* enum */ HideFlags MODIFIERS = new HideFlags();
        public static final /* enum */ HideFlags UNBREAKABLE = new HideFlags();
        public static final /* enum */ HideFlags CAN_DESTROY = new HideFlags();
        public static final /* enum */ HideFlags CAN_PLACE = new HideFlags();
        public static final /* enum */ HideFlags ADDITIONAL = new HideFlags();
        public static final /* enum */ HideFlags DYE = new HideFlags();
        private final int mask = 1 << this.ordinal();
        private static final /* synthetic */ HideFlags[] i;

        public static HideFlags[] values() {
            return (HideFlags[])i.clone();
        }

        public static HideFlags valueOf(String var0) {
            return Enum.valueOf(HideFlags.class, var0);
        }

        public int getMask() {
            return this.mask;
        }

        private static /* synthetic */ HideFlags[] b() {
            return new HideFlags[]{ENCHANTMENTS, MODIFIERS, UNBREAKABLE, CAN_DESTROY, CAN_PLACE, ADDITIONAL, DYE};
        }

        static {
            i = HideFlags.b();
        }
    }
}

