/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.function.Predicate;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public abstract class ItemProjectileWeapon
extends Item {
    public static final Predicate<ItemStack> ARROW_ONLY = var0 -> var0.is(TagsItem.ARROWS);
    public static final Predicate<ItemStack> ARROW_OR_FIREWORK = ARROW_ONLY.or(var0 -> var0.is(Items.FIREWORK_ROCKET));

    public ItemProjectileWeapon(Item.Info var0) {
        super(var0);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    public static ItemStack getHeldProjectile(EntityLiving var0, Predicate<ItemStack> var1) {
        if (var1.test(var0.getItemInHand(EnumHand.OFF_HAND))) {
            return var0.getItemInHand(EnumHand.OFF_HAND);
        }
        if (var1.test(var0.getItemInHand(EnumHand.MAIN_HAND))) {
            return var0.getItemInHand(EnumHand.MAIN_HAND);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    public abstract int getDefaultProjectileRange();
}

