/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemCompass
extends Item
implements ItemVanishable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String TAG_LODESTONE_POS = "LodestonePos";
    public static final String TAG_LODESTONE_DIMENSION = "LodestoneDimension";
    public static final String TAG_LODESTONE_TRACKED = "LodestoneTracked";

    public ItemCompass(Item.Info var0) {
        super(var0);
    }

    public static boolean isLodestoneCompass(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        return var1 != null && (var1.contains(TAG_LODESTONE_DIMENSION) || var1.contains(TAG_LODESTONE_POS));
    }

    @Override
    public boolean isFoil(ItemStack var0) {
        return ItemCompass.isLodestoneCompass(var0) || super.isFoil(var0);
    }

    public static Optional<ResourceKey<World>> getLodestoneDimension(NBTTagCompound var0) {
        return World.RESOURCE_KEY_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0.get(TAG_LODESTONE_DIMENSION)).result();
    }

    @Override
    public void inventoryTick(ItemStack var0, World var1, Entity var2, int var3, boolean var4) {
        if (var1.isClientSide) {
            return;
        }
        if (ItemCompass.isLodestoneCompass(var0)) {
            BlockPosition var7;
            NBTTagCompound var5 = var0.getOrCreateTag();
            if (var5.contains(TAG_LODESTONE_TRACKED) && !var5.getBoolean(TAG_LODESTONE_TRACKED)) {
                return;
            }
            Optional<ResourceKey<World>> var6 = ItemCompass.getLodestoneDimension(var5);
            if (var6.isPresent() && var6.get() == var1.dimension() && var5.contains(TAG_LODESTONE_POS) && (!var1.isInWorldBounds(var7 = GameProfileSerializer.readBlockPos(var5.getCompound(TAG_LODESTONE_POS))) || !((WorldServer)var1).getPoiManager().existsAtPosition(VillagePlaceType.LODESTONE, var7))) {
                var5.remove(TAG_LODESTONE_POS);
            }
        }
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var1 = var0.getClickedPos();
        World var2 = var0.getLevel();
        if (var2.getBlockState(var1).is(Blocks.LODESTONE)) {
            boolean var5;
            var2.playSound(null, var1, SoundEffects.LODESTONE_COMPASS_LOCK, SoundCategory.PLAYERS, 1.0f, 1.0f);
            EntityHuman var3 = var0.getPlayer();
            ItemStack var4 = var0.getItemInHand();
            boolean bl = var5 = !var3.getAbilities().instabuild && var4.getCount() == 1;
            if (var5) {
                this.addLodestoneTags(var2.dimension(), var1, var4.getOrCreateTag());
            } else {
                ItemStack var6 = new ItemStack(Items.COMPASS, 1);
                NBTTagCompound var7 = var4.hasTag() ? var4.getTag().copy() : new NBTTagCompound();
                var6.setTag(var7);
                if (!var3.getAbilities().instabuild) {
                    var4.shrink(1);
                }
                this.addLodestoneTags(var2.dimension(), var1, var7);
                if (!var3.getInventory().add(var6)) {
                    var3.drop(var6, false);
                }
            }
            return EnumInteractionResult.sidedSuccess(var2.isClientSide);
        }
        return super.useOn(var0);
    }

    private void addLodestoneTags(ResourceKey<World> var0, BlockPosition var12, NBTTagCompound var2) {
        var2.put(TAG_LODESTONE_POS, GameProfileSerializer.writeBlockPos(var12));
        World.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var0).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var2.put(TAG_LODESTONE_DIMENSION, (NBTBase)var1));
        var2.putBoolean(TAG_LODESTONE_TRACKED, true);
    }

    @Override
    public String getDescriptionId(ItemStack var0) {
        return ItemCompass.isLodestoneCompass(var0) ? "item.minecraft.lodestone_compass" : super.getDescriptionId(var0);
    }
}

