/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.LazyInitVar;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;

public final class EnumArmorMaterial
extends Enum<EnumArmorMaterial>
implements ArmorMaterial {
    public static final /* enum */ EnumArmorMaterial LEATHER = new EnumArmorMaterial("leather", 5, new int[]{1, 2, 3, 1}, 15, SoundEffects.ARMOR_EQUIP_LEATHER, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.LEATHER));
    public static final /* enum */ EnumArmorMaterial CHAIN = new EnumArmorMaterial("chainmail", 15, new int[]{1, 4, 5, 2}, 12, SoundEffects.ARMOR_EQUIP_CHAIN, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.IRON_INGOT));
    public static final /* enum */ EnumArmorMaterial IRON = new EnumArmorMaterial("iron", 15, new int[]{2, 5, 6, 2}, 9, SoundEffects.ARMOR_EQUIP_IRON, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.IRON_INGOT));
    public static final /* enum */ EnumArmorMaterial GOLD = new EnumArmorMaterial("gold", 7, new int[]{1, 3, 5, 2}, 25, SoundEffects.ARMOR_EQUIP_GOLD, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.GOLD_INGOT));
    public static final /* enum */ EnumArmorMaterial DIAMOND = new EnumArmorMaterial("diamond", 33, new int[]{3, 6, 8, 3}, 10, SoundEffects.ARMOR_EQUIP_DIAMOND, 2.0f, 0.0f, () -> RecipeItemStack.of(Items.DIAMOND));
    public static final /* enum */ EnumArmorMaterial TURTLE = new EnumArmorMaterial("turtle", 25, new int[]{2, 5, 6, 2}, 9, SoundEffects.ARMOR_EQUIP_TURTLE, 0.0f, 0.0f, () -> RecipeItemStack.of(Items.SCUTE));
    public static final /* enum */ EnumArmorMaterial NETHERITE = new EnumArmorMaterial("netherite", 37, new int[]{3, 6, 8, 3}, 15, SoundEffects.ARMOR_EQUIP_NETHERITE, 3.0f, 0.1f, () -> RecipeItemStack.of(Items.NETHERITE_INGOT));
    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEffect sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyInitVar<RecipeItemStack> repairIngredient;
    private static final /* synthetic */ EnumArmorMaterial[] q;

    public static EnumArmorMaterial[] values() {
        return (EnumArmorMaterial[])q.clone();
    }

    public static EnumArmorMaterial valueOf(String var0) {
        return Enum.valueOf(EnumArmorMaterial.class, var0);
    }

    private EnumArmorMaterial(String var2, int var3, int[] var4, int var5, SoundEffect var6, float var7, float var8, Supplier var9) {
        this.name = var2;
        this.durabilityMultiplier = var3;
        this.slotProtections = var4;
        this.enchantmentValue = var5;
        this.sound = var6;
        this.toughness = var7;
        this.knockbackResistance = var8;
        this.repairIngredient = new LazyInitVar(var9);
    }

    @Override
    public int getDurabilityForSlot(EnumItemSlot var0) {
        return HEALTH_PER_SLOT[var0.getIndex()] * this.durabilityMultiplier;
    }

    @Override
    public int getDefenseForSlot(EnumItemSlot var0) {
        return this.slotProtections[var0.getIndex()];
    }

    @Override
    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    @Override
    public SoundEffect getEquipSound() {
        return this.sound;
    }

    @Override
    public RecipeItemStack getRepairIngredient() {
        return this.repairIngredient.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getToughness() {
        return this.toughness;
    }

    @Override
    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    private static /* synthetic */ EnumArmorMaterial[] n() {
        return new EnumArmorMaterial[]{LEATHER, CHAIN, IRON, GOLD, DIAMOND, TURTLE, NETHERITE};
    }

    static {
        q = EnumArmorMaterial.n();
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

