/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;

public abstract class ContainerAnvilAbstract
extends Container {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    protected final InventoryCraftResult resultSlots = new InventoryCraftResult();
    protected final IInventory inputSlots = new InventorySubcontainer(2){

        @Override
        public void setChanged() {
            super.setChanged();
            ContainerAnvilAbstract.this.slotsChanged(this);
        }
    };
    protected final ContainerAccess access;
    protected final EntityHuman player;

    protected abstract boolean mayPickup(EntityHuman var1, boolean var2);

    protected abstract void onTake(EntityHuman var1, ItemStack var2);

    protected abstract boolean isValidBlock(IBlockData var1);

    public ContainerAnvilAbstract(@Nullable Containers<?> var0, int var1, PlayerInventory var2, ContainerAccess var3) {
        super(var0, var1);
        int var4;
        this.access = var3;
        this.player = var2.player;
        this.addSlot(new Slot(this.inputSlots, 0, 27, 47));
        this.addSlot(new Slot(this.inputSlots, 1, 76, 47));
        this.addSlot(new Slot(this.resultSlots, 2, 134, 47){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return false;
            }

            @Override
            public boolean mayPickup(EntityHuman var0) {
                return ContainerAnvilAbstract.this.mayPickup(var0, this.hasItem());
            }

            @Override
            public void onTake(EntityHuman var0, ItemStack var1) {
                ContainerAnvilAbstract.this.onTake(var0, var1);
            }
        });
        for (var4 = 0; var4 < 3; ++var4) {
            for (int var5 = 0; var5 < 9; ++var5) {
                this.addSlot(new Slot(var2, var5 + var4 * 9 + 9, 8 + var5 * 18, 84 + var4 * 18));
            }
        }
        for (var4 = 0; var4 < 9; ++var4) {
            this.addSlot(new Slot(var2, var4, 8 + var4 * 18, 142));
        }
    }

    public abstract void createResult();

    @Override
    public void slotsChanged(IInventory var0) {
        super.slotsChanged(var0);
        if (var0 == this.inputSlots) {
            this.createResult();
        }
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.inputSlots));
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.access.evaluate((var1, var2) -> {
            if (!this.isValidBlock(var1.getBlockState((BlockPosition)var2))) {
                return false;
            }
            return var0.distanceToSqr((double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5) <= 64.0;
        }, true);
    }

    protected boolean shouldQuickMoveToAdditionalSlot(ItemStack var0) {
        return false;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == 2) {
                if (!this.moveItemStackTo(var4, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 == 0 || var1 == 1) {
                if (!this.moveItemStackTo(var4, 3, 39, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (var1 >= 3 && var1 < 39) {
                int var5;
                int n2 = var5 = this.shouldQuickMoveToAdditionalSlot(var2) ? 1 : 0;
                if (!this.moveItemStackTo(var4, var5, 2, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (var4.isEmpty()) {
                var3.set(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }
}

