/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;

public class EntityMinecartTNT
extends EntityMinecartAbstract {
    private static final byte EVENT_PRIME = 10;
    private int fuse = -1;

    public EntityMinecartTNT(EntityTypes<? extends EntityMinecartTNT> var0, World var1) {
        super(var0, var1);
    }

    public EntityMinecartTNT(World var0, double var1, double var3, double var5) {
        super(EntityTypes.TNT_MINECART, var0, var1, var3, var5);
    }

    @Override
    public EntityMinecartAbstract.EnumMinecartType getMinecartType() {
        return EntityMinecartAbstract.EnumMinecartType.TNT;
    }

    @Override
    public IBlockData getDefaultDisplayBlockState() {
        return Blocks.TNT.defaultBlockState();
    }

    @Override
    public void tick() {
        double var0;
        super.tick();
        if (this.fuse > 0) {
            --this.fuse;
            this.level.addParticle(Particles.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explode(this.getDeltaMovement().horizontalDistanceSqr());
        }
        if (this.horizontalCollision && (var0 = this.getDeltaMovement().horizontalDistanceSqr()) >= (double)0.01f) {
            this.explode(var0);
        }
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        EntityArrow var3;
        Entity var2 = var0.getDirectEntity();
        if (var2 instanceof EntityArrow && (var3 = (EntityArrow)var2).isOnFire()) {
            this.explode(var3.getDeltaMovement().lengthSqr());
        }
        return super.hurt(var0, var1);
    }

    @Override
    public void destroy(DamageSource var0) {
        double var1 = this.getDeltaMovement().horizontalDistanceSqr();
        if (var0.isFire() || var0.isExplosion() || var1 >= (double)0.01f) {
            if (this.fuse < 0) {
                this.primeFuse();
                this.fuse = this.random.nextInt(20) + this.random.nextInt(20);
            }
            return;
        }
        super.destroy(var0);
        if (!var0.isExplosion() && this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.spawnAtLocation(Blocks.TNT);
        }
    }

    protected void explode(double var0) {
        if (!this.level.isClientSide) {
            double var2 = Math.sqrt(var0);
            if (var2 > 5.0) {
                var2 = 5.0;
            }
            this.level.explode(this, this.getX(), this.getY(), this.getZ(), (float)(4.0 + this.random.nextDouble() * 1.5 * var2), Explosion.Effect.BREAK);
            this.discard();
        }
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        if (var0 >= 3.0f) {
            float var3 = var0 / 10.0f;
            this.explode(var3 * var3);
        }
        return super.causeFallDamage(var0, var1, var2);
    }

    @Override
    public void activateMinecart(int var0, int var1, int var2, boolean var3) {
        if (var3 && this.fuse < 0) {
            this.primeFuse();
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 10) {
            this.primeFuse();
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public void primeFuse() {
        this.fuse = 80;
        if (!this.level.isClientSide) {
            this.level.broadcastEntityEvent(this, (byte)10);
            if (!this.isSilent()) {
                this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    @Override
    public float getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, Fluid var4, float var5) {
        if (this.isPrimed() && (var3.is(TagsBlock.RAILS) || var1.getBlockState(var2.above()).is(TagsBlock.RAILS))) {
            return 0.0f;
        }
        return super.getBlockExplosionResistance(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean shouldBlockExplode(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, float var4) {
        if (this.isPrimed() && (var3.is(TagsBlock.RAILS) || var1.getBlockState(var2.above()).is(TagsBlock.RAILS))) {
            return false;
        }
        return super.shouldBlockExplode(var0, var1, var2, var3, var4);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("TNTFuse", 99)) {
            this.fuse = var0.getInt("TNTFuse");
        }
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("TNTFuse", this.fuse);
    }
}

