/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnaceFurace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class EntityMinecartFurnace
extends EntityMinecartAbstract {
    private static final DataWatcherObject<Boolean> DATA_ID_FUEL = DataWatcher.defineId(EntityMinecartFurnace.class, DataWatcherRegistry.BOOLEAN);
    public int fuel;
    public double xPush;
    public double zPush;
    private static final RecipeItemStack INGREDIENT = RecipeItemStack.of(Items.COAL, Items.CHARCOAL);

    public EntityMinecartFurnace(EntityTypes<? extends EntityMinecartFurnace> var0, World var1) {
        super(var0, var1);
    }

    public EntityMinecartFurnace(World var0, double var1, double var3, double var5) {
        super(EntityTypes.FURNACE_MINECART, var0, var1, var3, var5);
    }

    @Override
    public EntityMinecartAbstract.EnumMinecartType getMinecartType() {
        return EntityMinecartAbstract.EnumMinecartType.FURNACE;
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_ID_FUEL, false);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide()) {
            if (this.fuel > 0) {
                --this.fuel;
            }
            if (this.fuel <= 0) {
                this.xPush = 0.0;
                this.zPush = 0.0;
            }
            this.setHasFuel(this.fuel > 0);
        }
        if (this.hasFuel() && this.random.nextInt(4) == 0) {
            this.level.addParticle(Particles.LARGE_SMOKE, this.getX(), this.getY() + 0.8, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected double getMaxSpeed() {
        return (this.isInWater() ? 3.0 : 4.0) / 20.0;
    }

    @Override
    public void destroy(DamageSource var0) {
        super.destroy(var0);
        if (!var0.isExplosion() && this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.spawnAtLocation(Blocks.FURNACE);
        }
    }

    @Override
    protected void moveAlongTrack(BlockPosition var0, IBlockData var1) {
        double var2 = 1.0E-4;
        double var4 = 0.001;
        super.moveAlongTrack(var0, var1);
        Vec3D var6 = this.getDeltaMovement();
        double var7 = var6.horizontalDistanceSqr();
        double var9 = this.xPush * this.xPush + this.zPush * this.zPush;
        if (var9 > 1.0E-4 && var7 > 0.001) {
            double var11 = Math.sqrt(var7);
            double var13 = Math.sqrt(var9);
            this.xPush = var6.x / var11 * var13;
            this.zPush = var6.z / var11 * var13;
        }
    }

    @Override
    protected void applyNaturalSlowdown() {
        double var0 = this.xPush * this.xPush + this.zPush * this.zPush;
        if (var0 > 1.0E-7) {
            var0 = Math.sqrt(var0);
            this.xPush /= var0;
            this.zPush /= var0;
            Vec3D var2 = this.getDeltaMovement().multiply(0.8, 0.0, 0.8).add(this.xPush, 0.0, this.zPush);
            if (this.isInWater()) {
                var2 = var2.scale(0.1);
            }
            this.setDeltaMovement(var2);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.98, 0.0, 0.98));
        }
        super.applyNaturalSlowdown();
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (INGREDIENT.test(var2) && this.fuel + 3600 <= 32000) {
            if (!var0.getAbilities().instabuild) {
                var2.shrink(1);
            }
            this.fuel += 3600;
        }
        if (this.fuel > 0) {
            this.xPush = this.getX() - var0.getX();
            this.zPush = this.getZ() - var0.getZ();
        }
        return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putDouble("PushX", this.xPush);
        var0.putDouble("PushZ", this.zPush);
        var0.putShort("Fuel", (short)this.fuel);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.xPush = var0.getDouble("PushX");
        this.zPush = var0.getDouble("PushZ");
        this.fuel = var0.getShort("Fuel");
    }

    protected boolean hasFuel() {
        return this.entityData.get(DATA_ID_FUEL);
    }

    protected void setHasFuel(boolean var0) {
        this.entityData.set(DATA_ID_FUEL, var0);
    }

    @Override
    public IBlockData getDefaultDisplayBlockState() {
        return (IBlockData)((IBlockData)Blocks.FURNACE.defaultBlockState().setValue(BlockFurnaceFurace.FACING, EnumDirection.NORTH)).setValue(BlockFurnaceFurace.LIT, this.hasFuel());
    }
}

