/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityThrownTrident
extends EntityArrow {
    private static final DataWatcherObject<Byte> ID_LOYALTY = DataWatcher.defineId(EntityThrownTrident.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Boolean> ID_FOIL = DataWatcher.defineId(EntityThrownTrident.class, DataWatcherRegistry.BOOLEAN);
    public ItemStack tridentItem = new ItemStack(Items.TRIDENT);
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public EntityThrownTrident(EntityTypes<? extends EntityThrownTrident> var0, World var1) {
        super((EntityTypes<? extends EntityArrow>)var0, var1);
    }

    public EntityThrownTrident(World var0, EntityLiving var1, ItemStack var2) {
        super(EntityTypes.TRIDENT, var1, var0);
        this.tridentItem = var2.copy();
        this.entityData.set(ID_LOYALTY, (byte)EnchantmentManager.getLoyalty(var2));
        this.entityData.set(ID_FOIL, var2.hasFoil());
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(ID_LOYALTY, (byte)0);
        this.entityData.define(ID_FOIL, false);
    }

    @Override
    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity var0 = this.getOwner();
        byte var1 = this.entityData.get(ID_LOYALTY);
        if (var1 > 0 && (this.dealtDamage || this.isNoPhysics()) && var0 != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level.isClientSide && this.pickup == EntityArrow.PickupStatus.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3D var2 = var0.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + var2.y * 0.015 * (double)var1, this.getZ());
                if (this.level.isClientSide) {
                    this.yOld = this.getY();
                }
                double var3 = 0.05 * (double)var1;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(var2.normalize().scale(var3)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.playSound(SoundEffects.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity var0 = this.getOwner();
        if (var0 == null || !var0.isAlive()) {
            return false;
        }
        return !(var0 instanceof EntityPlayer) || !var0.isSpectator();
    }

    @Override
    protected ItemStack getPickupItem() {
        return this.tridentItem.copy();
    }

    public boolean isFoil() {
        return this.entityData.get(ID_FOIL);
    }

    @Override
    @Nullable
    protected MovingObjectPositionEntity findHitEntity(Vec3D var0, Vec3D var1) {
        if (this.dealtDamage) {
            return null;
        }
        return super.findHitEntity(var0, var1);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        BlockPosition var7;
        Entity var3;
        Entity var1 = var0.getEntity();
        float var2 = 8.0f;
        if (var1 instanceof EntityLiving) {
            var3 = (EntityLiving)var1;
            var2 += EnchantmentManager.getDamageBonus(this.tridentItem, ((EntityLiving)var3).getMobType());
        }
        DamageSource var4 = DamageSource.trident(this, (var3 = this.getOwner()) == null ? this : var3);
        this.dealtDamage = true;
        SoundEffect var5 = SoundEffects.TRIDENT_HIT;
        if (var1.hurt(var4, var2)) {
            if (var1.getType() == EntityTypes.ENDERMAN) {
                return;
            }
            if (var1 instanceof EntityLiving) {
                EntityLiving var6 = (EntityLiving)var1;
                if (var3 instanceof EntityLiving) {
                    EnchantmentManager.doPostHurtEffects(var6, var3);
                    EnchantmentManager.doPostDamageEffects((EntityLiving)var3, var6);
                }
                this.doPostHurtEffects(var6);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        float var6 = 1.0f;
        if (this.level instanceof WorldServer && this.level.isThundering() && this.isChanneling() && this.level.canSeeSky(var7 = var1.blockPosition())) {
            EntityLightning var8 = EntityTypes.LIGHTNING_BOLT.create(this.level);
            var8.moveTo(Vec3D.atBottomCenterOf(var7));
            var8.setCause(var3 instanceof EntityPlayer ? (EntityPlayer)var3 : null);
            this.level.addFreshEntity(var8);
            var5 = SoundEffects.TRIDENT_THUNDER;
            var6 = 5.0f;
        }
        this.playSound(var5, var6, 1.0f);
    }

    public boolean isChanneling() {
        return EnchantmentManager.hasChanneling(this.tridentItem);
    }

    @Override
    protected boolean tryPickup(EntityHuman var0) {
        return super.tryPickup(var0) || this.isNoPhysics() && this.ownedBy(var0) && var0.getInventory().add(this.getPickupItem());
    }

    @Override
    protected SoundEffect getDefaultHitGroundSoundEvent() {
        return SoundEffects.TRIDENT_HIT_GROUND;
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (this.ownedBy(var0) || this.getOwner() == null) {
            super.playerTouch(var0);
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("Trident", 10)) {
            this.tridentItem = ItemStack.of(var0.getCompound("Trident"));
        }
        this.dealtDamage = var0.getBoolean("DealtDamage");
        this.entityData.set(ID_LOYALTY, (byte)EnchantmentManager.getLoyalty(this.tridentItem));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.put("Trident", this.tridentItem.save(new NBTTagCompound()));
        var0.putBoolean("DealtDamage", this.dealtDamage);
    }

    @Override
    public void tickDespawn() {
        byte var0 = this.entityData.get(ID_LOYALTY);
        if (this.pickup != EntityArrow.PickupStatus.ALLOWED || var0 <= 0) {
            super.tickDespawn();
        }
    }

    @Override
    protected float getWaterInertia() {
        return 0.99f;
    }

    @Override
    public boolean shouldRender(double var0, double var2, double var4) {
        return true;
    }
}

