/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class EntityArrow
extends IProjectile {
    private static final double ARROW_BASE_DAMAGE = 2.0;
    private static final DataWatcherObject<Byte> ID_FLAGS = DataWatcher.defineId(EntityArrow.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Byte> PIERCE_LEVEL = DataWatcher.defineId(EntityArrow.class, DataWatcherRegistry.BYTE);
    private static final int FLAG_CRIT = 1;
    private static final int FLAG_NOPHYSICS = 2;
    private static final int FLAG_CROSSBOW = 4;
    @Nullable
    private IBlockData lastState;
    public boolean inGround;
    protected int inGroundTime;
    public PickupStatus pickup = PickupStatus.DISALLOWED;
    public int shakeTime;
    public int life;
    private double baseDamage = 2.0;
    public int knockback;
    private SoundEffect soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;

    protected EntityArrow(EntityTypes<? extends EntityArrow> var0, World var1) {
        super((EntityTypes<? extends IProjectile>)var0, var1);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> var0, double var1, double var3, double var5, World var7) {
        this(var0, var7);
        this.setPos(var1, var3, var5);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> var0, EntityLiving var1, World var2) {
        this(var0, var1.getX(), var1.getEyeY() - (double)0.1f, var1.getZ(), var2);
        this.setOwner(var1);
        if (var1 instanceof EntityHuman) {
            this.pickup = PickupStatus.ALLOWED;
        }
    }

    public void setSoundEvent(SoundEffect var0) {
        this.soundEvent = var0;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN(var2)) {
            var2 = 1.0;
        }
        return var0 < (var2 *= 64.0 * EntityArrow.getViewScale()) * var2;
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(ID_FLAGS, (byte)0);
        this.entityData.define(PIERCE_LEVEL, (byte)0);
    }

    @Override
    public void shoot(double var0, double var2, double var4, float var6, float var7) {
        super.shoot(var0, var2, var4, var6, var7);
        this.life = 0;
    }

    @Override
    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8, boolean var9) {
        this.setPos(var0, var2, var4);
        this.setRot(var6, var7);
    }

    @Override
    public void lerpMotion(double var0, double var2, double var4) {
        super.lerpMotion(var0, var2, var4);
        this.life = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        Vec3D var5;
        Object var4;
        BlockPosition var2;
        IBlockData var3;
        super.tick();
        boolean var0 = this.isNoPhysics();
        Vec3D var1 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double var22 = var1.horizontalDistance();
            this.setYRot((float)(MathHelper.atan2(var1.x, var1.z) * 57.2957763671875));
            this.setXRot((float)(MathHelper.atan2(var1.y, var22) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        if (!((var3 = this.level.getBlockState(var2 = this.blockPosition())).isAir() || var0 || ((VoxelShape)(var4 = var3.getCollisionShape(this.level, var2))).isEmpty())) {
            var5 = this.position();
            for (AxisAlignedBB axisAlignedBB : ((VoxelShape)var4).toAabbs()) {
                if (!axisAlignedBB.move(var2).contains(var5)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain() || var3.is(Blocks.POWDER_SNOW)) {
            this.clearFire();
        }
        if (this.inGround && !var0) {
            if (this.lastState != var3 && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level.isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
            return;
        }
        this.inGroundTime = 0;
        var4 = this.position();
        MovingObjectPosition var6 = this.level.clip(new RayTrace((Vec3D)var4, var5 = ((Vec3D)var4).add(var1), RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, this));
        if (var6.getType() != MovingObjectPosition.EnumMovingObjectType.MISS) {
            var5 = var6.getLocation();
        }
        while (!this.isRemoved()) {
            void var8_13;
            MovingObjectPositionEntity movingObjectPositionEntity = this.findHitEntity((Vec3D)var4, var5);
            if (movingObjectPositionEntity != null) {
                var6 = movingObjectPositionEntity;
            }
            if (var6 != null && var6.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY) {
                Entity var8 = ((MovingObjectPositionEntity)var6).getEntity();
                Entity var9 = this.getOwner();
                if (var8 instanceof EntityHuman && var9 instanceof EntityHuman && !((EntityHuman)var9).canHarmPlayer((EntityHuman)var8)) {
                    var6 = null;
                    Object var8_12 = null;
                }
            }
            if (var6 != null && !var0) {
                this.onHit(var6);
                this.hasImpulse = true;
            }
            if (var8_13 == null || this.getPierceLevel() <= 0) break;
            var6 = null;
        }
        var1 = this.getDeltaMovement();
        double d2 = var1.x;
        double var9 = var1.y;
        double var11 = var1.z;
        if (this.isCritArrow()) {
            for (int var13 = 0; var13 < 4; ++var13) {
                this.level.addParticle(Particles.CRIT, this.getX() + d2 * (double)var13 / 4.0, this.getY() + var9 * (double)var13 / 4.0, this.getZ() + var11 * (double)var13 / 4.0, -d2, -var9 + 0.2, -var11);
            }
        }
        double var13 = this.getX() + d2;
        double var15 = this.getY() + var9;
        double var17 = this.getZ() + var11;
        double var19 = var1.horizontalDistance();
        if (var0) {
            this.setYRot((float)(MathHelper.atan2(-d2, -var11) * 57.2957763671875));
        } else {
            this.setYRot((float)(MathHelper.atan2(d2, var11) * 57.2957763671875));
        }
        this.setXRot((float)(MathHelper.atan2(var9, var19) * 57.2957763671875));
        this.setXRot(EntityArrow.lerpRotation(this.xRotO, this.getXRot()));
        this.setYRot(EntityArrow.lerpRotation(this.yRotO, this.getYRot()));
        float var21 = 0.99f;
        float var22 = 0.05f;
        if (this.isInWater()) {
            for (int var23 = 0; var23 < 4; ++var23) {
                float var24 = 0.25f;
                this.level.addParticle(Particles.BUBBLE, var13 - d2 * 0.25, var15 - var9 * 0.25, var17 - var11 * 0.25, d2, var9, var11);
            }
            var21 = this.getWaterInertia();
        }
        this.setDeltaMovement(var1.scale(var21));
        if (!this.isNoGravity() && !var0) {
            Vec3D var23 = this.getDeltaMovement();
            this.setDeltaMovement(var23.x, var23.y - (double)0.05f, var23.z);
        }
        this.setPos(var13, var15, var17);
        this.checkInsideBlocks();
    }

    private boolean shouldFall() {
        return this.inGround && this.level.noCollision(new AxisAlignedBB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3D var0 = this.getDeltaMovement();
        this.setDeltaMovement(var0.multiply(this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f));
        this.life = 0;
    }

    @Override
    public void move(EnumMoveType var0, Vec3D var1) {
        super.move(var0, var1);
        if (var0 != EnumMoveType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.discard();
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        DamageSource var4;
        Entity var5;
        super.onHitEntity(var0);
        Entity var1 = var0.getEntity();
        float var2 = (float)this.getDeltaMovement().length();
        int var3 = MathHelper.ceil(MathHelper.clamp((double)var2 * this.baseDamage, 0.0, 2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() < this.getPierceLevel() + 1) {
                this.piercingIgnoreEntityIds.add(var1.getId());
            } else {
                this.discard();
                return;
            }
        }
        if (this.isCritArrow()) {
            long var42 = this.random.nextInt(var3 / 2 + 2);
            var3 = (int)Math.min(var42 + (long)var3, Integer.MAX_VALUE);
        }
        if ((var5 = this.getOwner()) == null) {
            var4 = DamageSource.arrow(this, this);
        } else {
            var4 = DamageSource.arrow(this, var5);
            if (var5 instanceof EntityLiving) {
                ((EntityLiving)var5).setLastHurtMob(var1);
            }
        }
        boolean var6 = var1.getType() == EntityTypes.ENDERMAN;
        int var7 = var1.getRemainingFireTicks();
        if (this.isOnFire() && !var6) {
            var1.setSecondsOnFire(5);
        }
        if (var1.hurt(var4, var3)) {
            if (var6) {
                return;
            }
            if (var1 instanceof EntityLiving) {
                Object var9;
                EntityLiving var8 = (EntityLiving)var1;
                if (!this.level.isClientSide && this.getPierceLevel() <= 0) {
                    var8.setArrowCount(var8.getArrowCount() + 1);
                }
                if (this.knockback > 0 && ((Vec3D)(var9 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6))).lengthSqr() > 0.0) {
                    var8.push(((Vec3D)var9).x, 0.1, ((Vec3D)var9).z);
                }
                if (!this.level.isClientSide && var5 instanceof EntityLiving) {
                    EnchantmentManager.doPostHurtEffects(var8, var5);
                    EnchantmentManager.doPostDamageEffects((EntityLiving)var5, var8);
                }
                this.doPostHurtEffects(var8);
                if (var5 != null && var8 != var5 && var8 instanceof EntityHuman && var5 instanceof EntityPlayer && !this.isSilent()) {
                    ((EntityPlayer)var5).connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!var1.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(var8);
                }
                if (!this.level.isClientSide && var5 instanceof EntityPlayer) {
                    var9 = (EntityPlayer)var5;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriterionTriggers.KILLED_BY_CROSSBOW.trigger((EntityPlayer)var9, this.piercedAndKilledEntities);
                    } else if (!var1.isAlive() && this.shotFromCrossbow()) {
                        CriterionTriggers.KILLED_BY_CROSSBOW.trigger((EntityPlayer)var9, Arrays.asList(var1));
                    }
                }
            }
            this.playSound(this.soundEvent, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        } else {
            var1.setRemainingFireTicks(var7);
            this.setDeltaMovement(this.getDeltaMovement().scale(-0.1));
            this.setYRot(this.getYRot() + 180.0f);
            this.yRotO += 180.0f;
            if (!this.level.isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == PickupStatus.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            }
        }
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        this.lastState = this.level.getBlockState(var0.getBlockPos());
        super.onHitBlock(var0);
        Vec3D var1 = var0.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(var1);
        Vec3D var2 = var1.normalize().scale(0.05f);
        this.setPosRaw(this.getX() - var2.x, this.getY() - var2.y, this.getZ() - var2.z);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEffects.ARROW_HIT);
        this.setShotFromCrossbow(false);
        this.resetPiercedEntities();
    }

    protected SoundEffect getDefaultHitGroundSoundEvent() {
        return SoundEffects.ARROW_HIT;
    }

    protected final SoundEffect getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(EntityLiving var0) {
    }

    @Nullable
    protected MovingObjectPositionEntity findHitEntity(Vec3D var0, Vec3D var1) {
        return ProjectileHelper.getEntityHitResult(this.level, this, var0, var1, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        return super.canHitEntity(var0) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(var0.getId()));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putShort("life", (short)this.life);
        if (this.lastState != null) {
            var0.put("inBlockState", GameProfileSerializer.writeBlockState(this.lastState));
        }
        var0.putByte("shake", (byte)this.shakeTime);
        var0.putBoolean("inGround", this.inGround);
        var0.putByte("pickup", (byte)this.pickup.ordinal());
        var0.putDouble("damage", this.baseDamage);
        var0.putBoolean("crit", this.isCritArrow());
        var0.putByte("PierceLevel", this.getPierceLevel());
        var0.putString("SoundEvent", IRegistry.SOUND_EVENT.getKey(this.soundEvent).toString());
        var0.putBoolean("ShotFromCrossbow", this.shotFromCrossbow());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.life = var0.getShort("life");
        if (var0.contains("inBlockState", 10)) {
            this.lastState = GameProfileSerializer.readBlockState(var0.getCompound("inBlockState"));
        }
        this.shakeTime = var0.getByte("shake") & 0xFF;
        this.inGround = var0.getBoolean("inGround");
        if (var0.contains("damage", 99)) {
            this.baseDamage = var0.getDouble("damage");
        }
        this.pickup = PickupStatus.byOrdinal(var0.getByte("pickup"));
        this.setCritArrow(var0.getBoolean("crit"));
        this.setPierceLevel(var0.getByte("PierceLevel"));
        if (var0.contains("SoundEvent", 8)) {
            this.soundEvent = IRegistry.SOUND_EVENT.getOptional(new MinecraftKey(var0.getString("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
        this.setShotFromCrossbow(var0.getBoolean("ShotFromCrossbow"));
    }

    @Override
    public void setOwner(@Nullable Entity var0) {
        super.setOwner(var0);
        if (var0 instanceof EntityHuman) {
            this.pickup = ((EntityHuman)var0).getAbilities().instabuild ? PickupStatus.CREATIVE_ONLY : PickupStatus.ALLOWED;
        }
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (this.level.isClientSide || !this.inGround && !this.isNoPhysics() || this.shakeTime > 0) {
            return;
        }
        if (this.tryPickup(var0)) {
            var0.take(this, 1);
            this.discard();
        }
    }

    protected boolean tryPickup(EntityHuman var0) {
        switch (this.pickup) {
            case ALLOWED: {
                return var0.getInventory().add(this.getPickupItem());
            }
            case CREATIVE_ONLY: {
                return var0.getAbilities().instabuild;
            }
        }
        return false;
    }

    protected abstract ItemStack getPickupItem();

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void setBaseDamage(double var0) {
        this.baseDamage = var0;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setKnockback(int var0) {
        this.knockback = var0;
    }

    public int getKnockback() {
        return this.knockback;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    protected float getEyeHeight(EntityPose var0, EntitySize var1) {
        return 0.13f;
    }

    public void setCritArrow(boolean var0) {
        this.setFlag(1, var0);
    }

    public void setPierceLevel(byte var0) {
        this.entityData.set(PIERCE_LEVEL, var0);
    }

    private void setFlag(int var0, boolean var1) {
        byte var2 = this.entityData.get(ID_FLAGS);
        if (var1) {
            this.entityData.set(ID_FLAGS, (byte)(var2 | var0));
        } else {
            this.entityData.set(ID_FLAGS, (byte)(var2 & ~var0));
        }
    }

    public boolean isCritArrow() {
        byte var0 = this.entityData.get(ID_FLAGS);
        return (var0 & 1) != 0;
    }

    public boolean shotFromCrossbow() {
        byte var0 = this.entityData.get(ID_FLAGS);
        return (var0 & 4) != 0;
    }

    public byte getPierceLevel() {
        return this.entityData.get(PIERCE_LEVEL);
    }

    public void setEnchantmentEffectsFromEntity(EntityLiving var0, float var1) {
        int var2 = EnchantmentManager.getEnchantmentLevel(Enchantments.POWER_ARROWS, var0);
        int var3 = EnchantmentManager.getEnchantmentLevel(Enchantments.PUNCH_ARROWS, var0);
        this.setBaseDamage((double)(var1 * 2.0f) + (this.random.nextGaussian() * 0.25 + (double)((float)this.level.getDifficulty().getId() * 0.11f)));
        if (var2 > 0) {
            this.setBaseDamage(this.getBaseDamage() + (double)var2 * 0.5 + 0.5);
        }
        if (var3 > 0) {
            this.setKnockback(var3);
        }
        if (EnchantmentManager.getEnchantmentLevel(Enchantments.FLAMING_ARROWS, var0) > 0) {
            this.setSecondsOnFire(100);
        }
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean var0) {
        this.noPhysics = var0;
        this.setFlag(2, var0);
    }

    public boolean isNoPhysics() {
        if (!this.level.isClientSide) {
            return this.noPhysics;
        }
        return (this.entityData.get(ID_FLAGS) & 2) != 0;
    }

    public void setShotFromCrossbow(boolean var0) {
        this.setFlag(4, var0);
    }

    public static final class PickupStatus
    extends Enum<PickupStatus> {
        public static final /* enum */ PickupStatus DISALLOWED = new PickupStatus();
        public static final /* enum */ PickupStatus ALLOWED = new PickupStatus();
        public static final /* enum */ PickupStatus CREATIVE_ONLY = new PickupStatus();
        private static final /* synthetic */ PickupStatus[] d;

        public static PickupStatus[] values() {
            return (PickupStatus[])d.clone();
        }

        public static PickupStatus valueOf(String var0) {
            return Enum.valueOf(PickupStatus.class, var0);
        }

        public static PickupStatus byOrdinal(int var0) {
            if (var0 < 0 || var0 > PickupStatus.values().length) {
                var0 = 0;
            }
            return PickupStatus.values()[var0];
        }

        private static /* synthetic */ PickupStatus[] a() {
            return new PickupStatus[]{DISALLOWED, ALLOWED, CREATIVE_ONLY};
        }

        static {
            d = PickupStatus.a();
        }
    }
}

