/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.storage.IWorldDataServer;

public class MobSpawnerTrader
implements MobSpawner {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private final Random random = new Random();
    private final IWorldDataServer serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public MobSpawnerTrader(IWorldDataServer var0) {
        this.serverLevelData = var0;
        this.tickDelay = 1200;
        this.spawnDelay = var0.getWanderingTraderSpawnDelay();
        this.spawnChance = var0.getWanderingTraderSpawnChance();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 24000;
            var0.setWanderingTraderSpawnDelay(this.spawnDelay);
            this.spawnChance = 25;
            var0.setWanderingTraderSpawnChance(this.spawnChance);
        }
    }

    @Override
    public int tick(WorldServer var0, boolean var1, boolean var2) {
        if (!var0.getGameRules().getBoolean(GameRules.RULE_DO_TRADER_SPAWNING)) {
            return 0;
        }
        if (--this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = 1200;
        this.spawnDelay -= 1200;
        this.serverLevelData.setWanderingTraderSpawnDelay(this.spawnDelay);
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = 24000;
        if (!var0.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return 0;
        }
        int var3 = this.spawnChance;
        this.spawnChance = MathHelper.clamp(this.spawnChance + 25, 25, 75);
        this.serverLevelData.setWanderingTraderSpawnChance(this.spawnChance);
        if (this.random.nextInt(100) > var3) {
            return 0;
        }
        if (this.spawn(var0)) {
            this.spawnChance = 25;
            return 1;
        }
        return 0;
    }

    private boolean spawn(WorldServer var02) {
        EntityPlayer var1 = var02.getRandomPlayer();
        if (var1 == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        BlockPosition var2 = var1.blockPosition();
        int var3 = 48;
        VillagePlace var4 = var02.getPoiManager();
        Optional<BlockPosition> var5 = var4.find(VillagePlaceType.MEETING.getPredicate(), var0 -> true, var2, 48, VillagePlace.Occupancy.ANY);
        BlockPosition var6 = var5.orElse(var2);
        BlockPosition var7 = this.findSpawnPositionNear(var02, var6, 48);
        if (var7 != null && this.hasEnoughSpace(var02, var7)) {
            if (var02.getBiomeName(var7).equals(Optional.of(Biomes.THE_VOID))) {
                return false;
            }
            EntityVillagerTrader var8 = EntityTypes.WANDERING_TRADER.spawn(var02, null, null, null, var7, EnumMobSpawn.EVENT, false, false);
            if (var8 != null) {
                for (int var9 = 0; var9 < 2; ++var9) {
                    this.tryToSpawnLlamaFor(var02, var8, 4);
                }
                this.serverLevelData.setWanderingTraderId(var8.getUUID());
                var8.setDespawnDelay(48000);
                var8.setWanderTarget(var6);
                var8.restrictTo(var6, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnLlamaFor(WorldServer var0, EntityVillagerTrader var1, int var2) {
        BlockPosition var3 = this.findSpawnPositionNear(var0, var1.blockPosition(), var2);
        if (var3 == null) {
            return;
        }
        EntityLlamaTrader var4 = EntityTypes.TRADER_LLAMA.spawn(var0, null, null, null, var3, EnumMobSpawn.EVENT, false, false);
        if (var4 == null) {
            return;
        }
        var4.setLeashedTo(var1, true);
    }

    @Nullable
    private BlockPosition findSpawnPositionNear(IWorldReader var0, BlockPosition var1, int var2) {
        BlockPosition var3 = null;
        for (int var4 = 0; var4 < 10; ++var4) {
            int var6;
            int var7;
            int var5 = var1.getX() + this.random.nextInt(var2 * 2) - var2;
            BlockPosition var8 = new BlockPosition(var5, var7 = var0.getHeight(HeightMap.Type.WORLD_SURFACE, var5, var6 = var1.getZ() + this.random.nextInt(var2 * 2) - var2), var6);
            if (!SpawnerCreature.isSpawnPositionOk(EntityPositionTypes.Surface.ON_GROUND, var0, var8, EntityTypes.WANDERING_TRADER)) continue;
            var3 = var8;
            break;
        }
        return var3;
    }

    private boolean hasEnoughSpace(IBlockAccess var0, BlockPosition var1) {
        for (BlockPosition var3 : BlockPosition.betweenClosed(var1, var1.offset(1, 2, 1))) {
            if (var0.getBlockState(var3).getCollisionShape(var0, var3).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

