/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3fa;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3D;

public interface ICrossbow
extends IRangedEntity {
    public void setChargingCrossbow(boolean var1);

    public void shootCrossbowProjectile(EntityLiving var1, ItemStack var2, IProjectile var3, float var4);

    @Nullable
    public EntityLiving getTarget();

    public void onCrossbowAttackPerformed();

    default public void performCrossbowAttack(EntityLiving var0, float var1) {
        EnumHand var2 = ProjectileHelper.getWeaponHoldingHand(var0, Items.CROSSBOW);
        ItemStack var3 = var0.getItemInHand(var2);
        if (var0.isHolding(Items.CROSSBOW)) {
            ItemCrossbow.performShooting(var0.level, var0, var2, var3, var1, 14 - var0.level.getDifficulty().getId() * 4);
        }
        this.onCrossbowAttackPerformed();
    }

    default public void shootCrossbowProjectile(EntityLiving var0, EntityLiving var1, IProjectile var2, float var3, float var4) {
        IProjectile var5 = var2;
        double var6 = var1.getX() - var0.getX();
        double var8 = var1.getZ() - var0.getZ();
        double var10 = Math.sqrt(var6 * var6 + var8 * var8);
        double var12 = var1.getY(0.3333333333333333) - var5.getY() + var10 * (double)0.2f;
        Vector3fa var14 = this.getProjectileShotVector(var0, new Vec3D(var6, var12, var8), var3);
        var2.shoot(var14.x(), var14.y(), var14.z(), var4, 14 - var0.level.getDifficulty().getId() * 4);
        var0.playSound(SoundEffects.CROSSBOW_SHOOT, 1.0f, 1.0f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    default public Vector3fa getProjectileShotVector(EntityLiving var0, Vec3D var1, float var2) {
        Vec3D var3 = var1.normalize();
        Vec3D var4 = var3.cross(new Vec3D(0.0, 1.0, 0.0));
        if (var4.lengthSqr() <= 1.0E-7) {
            var4 = var3.cross(var0.getUpVector(1.0f));
        }
        Quaternion var5 = new Quaternion(new Vector3fa(var4), 90.0f, true);
        Vector3fa var6 = new Vector3fa(var3);
        var6.transform(var5);
        Quaternion var7 = new Quaternion(var6, var2, true);
        Vector3fa var8 = new Vector3fa(var3);
        var8.transform(var7);
        return var8;
    }
}

