/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public abstract class EntityMonster
extends EntityCreature
implements IMonster {
    protected EntityMonster(EntityTypes<? extends EntityMonster> var0, World var1) {
        super((EntityTypes<? extends EntityCreature>)var0, var1);
        this.xpReward = 5;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    public void aiStep() {
        this.updateSwingTime();
        this.updateNoActionTime();
        super.aiStep();
    }

    protected void updateNoActionTime() {
        float var0 = this.getBrightness();
        if (var0 > 0.5f) {
            this.noActionTime += 2;
        }
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.HOSTILE_SWIM;
    }

    @Override
    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.HOSTILE_SPLASH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.HOSTILE_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.HOSTILE_DEATH;
    }

    @Override
    public EntityLiving.a getFallSounds() {
        return new EntityLiving.a(SoundEffects.HOSTILE_SMALL_FALL, SoundEffects.HOSTILE_BIG_FALL);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.5f - var1.getBrightness(var0);
    }

    public static boolean isDarkEnoughToSpawn(WorldAccess var0, BlockPosition var1, Random var2) {
        if (var0.getBrightness(EnumSkyBlock.SKY, var1) > var2.nextInt(32)) {
            return false;
        }
        if (var0.getBrightness(EnumSkyBlock.BLOCK, var1) > 0) {
            return false;
        }
        int var3 = var0.getLevel().isThundering() ? var0.getMaxLocalRawBrightness(var1, 10) : var0.getMaxLocalRawBrightness(var1);
        return var3 <= var2.nextInt(8);
    }

    public static boolean checkMonsterSpawnRules(EntityTypes<? extends EntityMonster> var0, WorldAccess var1, EnumMobSpawn var2, BlockPosition var3, Random var4) {
        return var1.getDifficulty() != EnumDifficulty.PEACEFUL && EntityMonster.isDarkEnoughToSpawn(var1, var3, var4) && EntityMonster.checkMobSpawnRules(var0, var1, var2, var3, var4);
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityTypes<? extends EntityMonster> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, Random var4) {
        return var1.getDifficulty() != EnumDifficulty.PEACEFUL && EntityMonster.checkMobSpawnRules(var0, var1, var2, var3, var4);
    }

    public static AttributeProvider.Builder createMonsterAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.ATTACK_DAMAGE);
    }

    @Override
    protected boolean shouldDropExperience() {
        return true;
    }

    @Override
    protected boolean shouldDropLoot() {
        return true;
    }

    public boolean isPreventingPlayerRest(EntityHuman var0) {
        return true;
    }

    @Override
    public ItemStack getProjectile(ItemStack var0) {
        if (var0.getItem() instanceof ItemProjectileWeapon) {
            Predicate<ItemStack> var1 = ((ItemProjectileWeapon)var0.getItem()).getSupportedHeldProjectiles();
            ItemStack var2 = ItemProjectileWeapon.getHeldProjectile(this, var1);
            return var2.isEmpty() ? new ItemStack(Items.ARROW) : var2;
        }
        return ItemStack.EMPTY;
    }
}

