/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityPainting;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.Paintings;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;

public class EntityPainting
extends EntityHanging {
    public Paintings motive = Paintings.KEBAB;

    public EntityPainting(EntityTypes<? extends EntityPainting> var0, World var1) {
        super((EntityTypes<? extends EntityHanging>)var0, var1);
    }

    public EntityPainting(World var0, BlockPosition var1, EnumDirection var2) {
        super(EntityTypes.PAINTING, var0, var1);
        Paintings var6;
        ArrayList var3 = Lists.newArrayList();
        int var4 = 0;
        Iterator iterator = IRegistry.MOTIVE.iterator();
        while (iterator.hasNext()) {
            this.motive = var6 = (Paintings)iterator.next();
            this.setDirection(var2);
            if (!this.survives()) continue;
            var3.add(var6);
            int var7 = var6.getWidth() * var6.getHeight();
            if (var7 <= var4) continue;
            var4 = var7;
        }
        if (!var3.isEmpty()) {
            Iterator var5 = var3.iterator();
            while (var5.hasNext()) {
                var6 = (Paintings)var5.next();
                if (var6.getWidth() * var6.getHeight() >= var4) continue;
                var5.remove();
            }
            this.motive = (Paintings)var3.get(this.random.nextInt(var3.size()));
        }
        this.setDirection(var2);
    }

    public EntityPainting(World var0, BlockPosition var1, EnumDirection var2, Paintings var3) {
        this(var0, var1, var2);
        this.motive = var3;
        this.setDirection(var2);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putString("Motive", IRegistry.MOTIVE.getKey(this.motive).toString());
        var0.putByte("Facing", (byte)this.direction.get2DDataValue());
        super.addAdditionalSaveData(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        this.motive = IRegistry.MOTIVE.get(MinecraftKey.tryParse(var0.getString("Motive")));
        this.direction = EnumDirection.from2DDataValue(var0.getByte("Facing"));
        super.readAdditionalSaveData(var0);
        this.setDirection(this.direction);
    }

    @Override
    public int getWidth() {
        return this.motive.getWidth();
    }

    @Override
    public int getHeight() {
        return this.motive.getHeight();
    }

    @Override
    public void dropItem(@Nullable Entity var0) {
        if (!this.level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        this.playSound(SoundEffects.PAINTING_BREAK, 1.0f, 1.0f);
        if (var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            if (var1.getAbilities().instabuild) {
                return;
            }
        }
        this.spawnAtLocation(Items.PAINTING);
    }

    @Override
    public void playPlacementSound() {
        this.playSound(SoundEffects.PAINTING_PLACE, 1.0f, 1.0f);
    }

    @Override
    public void moveTo(double var0, double var2, double var4, float var6, float var7) {
        this.setPos(var0, var2, var4);
    }

    @Override
    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8, boolean var9) {
        BlockPosition var10 = this.pos.offset(var0 - this.getX(), var2 - this.getY(), var4 - this.getZ());
        this.setPos(var10.getX(), var10.getY(), var10.getZ());
    }

    @Override
    public Packet<?> getAddEntityPacket() {
        return new PacketPlayOutSpawnEntityPainting(this);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.PAINTING);
    }
}

