/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorGate;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorMakeLoveAnimal;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorRemoveMemory;
import net.minecraft.world.entity.ai.behavior.BehaviorRunIf;
import net.minecraft.world.entity.ai.behavior.BehaviorRunSometimes;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayOutOfRange;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.RandomSwim;
import net.minecraft.world.entity.ai.behavior.TryFindWater;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.axolotl.PlayDead;
import net.minecraft.world.entity.animal.axolotl.ValidatePlayDead;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;

public class AxolotlAi {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of(5, 16);
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.2f;
    private static final float SPEED_MULTIPLIER_ON_LAND = 0.15f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING_IN_WATER = 0.5f;
    private static final float SPEED_MULTIPLIER_WHEN_CHASING_IN_WATER = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT_IN_WATER = 0.6f;

    protected static BehaviorController<?> makeBrain(BehaviorController<Axolotl> var0) {
        AxolotlAi.initCoreActivity(var0);
        AxolotlAi.initIdleActivity(var0);
        AxolotlAi.initFightActivity(var0);
        AxolotlAi.initPlayDeadActivity(var0);
        var0.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    private static void initPlayDeadActivity(BehaviorController<Axolotl> var0) {
        var0.addActivityAndRemoveMemoriesWhenStopped(Activity.PLAY_DEAD, (ImmutableList<Pair<Integer, Behavior<Axolotl>>>)ImmutableList.of((Object)Pair.of((Object)0, (Object)new PlayDead()), (Object)Pair.of((Object)1, new BehaviorRemoveMemory<Axolotl>(AxolotlAi::isBreeding, MemoryModuleType.PLAY_DEAD_TICKS))), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.PLAY_DEAD_TICKS, (Object)((Object)MemoryStatus.VALUE_PRESENT))), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.PLAY_DEAD_TICKS));
    }

    private static void initFightActivity(BehaviorController<Axolotl> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, (ImmutableList<Behavior<Axolotl>>)ImmutableList.of(new BehaviorAttackTargetForget<Axolotl>(Axolotl::onStopAttacking), (Object)new BehaviorWalkAwayOutOfRange(AxolotlAi::getSpeedModifierChasing), (Object)new BehaviorAttack(20), new BehaviorRemoveMemory<Axolotl>(AxolotlAi::isBreeding, MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCoreActivity(BehaviorController<Axolotl> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<Behavior<Axolotl>>)ImmutableList.of((Object)new BehaviorLook(45, 90), (Object)new BehavorMove(), (Object)new ValidatePlayDead(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(BehaviorController<Axolotl> var0) {
        var0.addActivity(Activity.IDLE, (ImmutableList<Pair<Integer, Behavior<Axolotl>>>)ImmutableList.of((Object)Pair.of((Object)0, new BehaviorRunSometimes<EntityLiving>(new BehaviorLookTarget(EntityTypes.PLAYER, 6.0f), UniformInt.of(30, 60))), (Object)Pair.of((Object)1, (Object)new BehaviorMakeLoveAnimal(EntityTypes.AXOLOTL, 0.2f)), (Object)Pair.of((Object)2, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(AxolotlAi::getSpeedModifier), (Object)1), (Object)Pair.of(new BehaviorFollowAdult(ADULT_FOLLOW_RANGE, AxolotlAi::getSpeedModifierFollowingAdult), (Object)1)))), (Object)Pair.of((Object)3, new BehaviorAttackTargetSet<Axolotl>(AxolotlAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)3, (Object)new TryFindWater(6, 0.15f)), (Object)Pair.of((Object)4, new BehaviorGate((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), (Set<MemoryModuleType<?>>)ImmutableSet.of(), BehaviorGate.Order.ORDERED, BehaviorGate.Execution.TRY_ALL, ImmutableList.of((Object)Pair.of((Object)new RandomSwim(0.5f), (Object)2), (Object)Pair.of((Object)new BehaviorStrollRandomUnconstrained(0.15f, false), (Object)2), (Object)Pair.of((Object)new BehaviorLookWalk(AxolotlAi::canSetWalkTargetFromLookTarget, AxolotlAi::getSpeedModifier, 3), (Object)3), (Object)Pair.of(new BehaviorRunIf<EntityLiving>(Entity::isInWaterOrBubble, new BehaviorNop(30, 60)), (Object)5), (Object)Pair.of(new BehaviorRunIf<EntityLiving>(Entity::isOnGround, new BehaviorNop(200, 400)), (Object)5))))));
    }

    private static boolean canSetWalkTargetFromLookTarget(EntityLiving var0) {
        World var1 = var0.level;
        Optional<BehaviorPosition> var2 = var0.getBrain().getMemory(MemoryModuleType.LOOK_TARGET);
        if (var2.isPresent()) {
            BlockPosition var3 = var2.get().currentBlockPosition();
            return var1.isWaterAt(var3) == var0.isInWaterOrBubble();
        }
        return false;
    }

    public static void updateActivity(Axolotl var0) {
        BehaviorController<Axolotl> var1 = var0.getBrain();
        Activity var2 = var1.getActiveNonCoreActivity().orElse(null);
        if (var2 != Activity.PLAY_DEAD) {
            var1.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.PLAY_DEAD, (Object)Activity.FIGHT, (Object)Activity.IDLE));
            if (var2 == Activity.FIGHT && var1.getActiveNonCoreActivity().orElse(null) != Activity.FIGHT) {
                var1.setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, true, 2400L);
            }
        }
    }

    private static float getSpeedModifierChasing(EntityLiving var0) {
        return var0.isInWaterOrBubble() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifierFollowingAdult(EntityLiving var0) {
        return var0.isInWaterOrBubble() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifier(EntityLiving var0) {
        return var0.isInWaterOrBubble() ? 0.5f : 0.15f;
    }

    private static Optional<? extends EntityLiving> findNearestValidAttackTarget(Axolotl var0) {
        if (AxolotlAi.isBreeding(var0)) {
            return Optional.empty();
        }
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }

    private static boolean isBreeding(Axolotl var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
    }

    public static RecipeItemStack getTemptations() {
        return RecipeItemStack.of(TagsItem.AXOLOTL_TEMPT_ITEMS);
    }
}

