/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AxisAlignedBB;

public class SensorNearestLivingEntities
extends Sensor<EntityLiving> {
    @Override
    protected void doTick(WorldServer var0, EntityLiving var12) {
        AxisAlignedBB var2 = var12.getBoundingBox().inflate(16.0, 16.0, 16.0);
        List<EntityLiving> var3 = var0.getEntitiesOfClass(EntityLiving.class, var2, var1 -> var1 != var12 && var1.isAlive());
        var3.sort(Comparator.comparingDouble(var12::distanceToSqr));
        BehaviorController<?> var4 = var12.getBrain();
        var4.setMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES, var3);
        var4.setMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, new NearestVisibleLivingEntities(var12, var3));
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }
}

