/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.phys.Vec3D;

public class RandomSwim
extends BehaviorStrollRandomUnconstrained {
    public static final int[][] XY_DISTANCE_TIERS = new int[][]{{1, 1}, {3, 3}, {5, 5}, {6, 5}, {7, 7}, {10, 7}};

    public RandomSwim(float var0) {
        super(var0);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return var1.isInWaterOrBubble();
    }

    @Override
    @Nullable
    protected Vec3D getTargetPos(EntityCreature var0) {
        Vec3D var1 = null;
        Vec3D var2 = null;
        for (int[] var6 : XY_DISTANCE_TIERS) {
            var2 = var1 == null ? BehaviorUtil.getRandomSwimmablePos(var0, var6[0], var6[1]) : var0.position().add(var0.position().vectorTo(var1).normalize().multiply(var6[0], var6[1], var6[0]));
            if (var2 == null || var0.level.getFluidState(new BlockPosition(var2)).isEmpty()) {
                return var1;
            }
            var1 = var2;
        }
        return var2;
    }
}

